/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.ftp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.jhime.pectin.ftp.Host;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FtpDocument {
    private Document doc;
    private boolean errorFlag;

    public FtpDocument() {
        this.readDocument();
    }

    private void readDocument() {
        this.errorFlag = true;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String path = pectin.userDir + System.getProperty("file.separator") + "ftphost.xml";
            FileInputStream is = new FileInputStream(path);
            this.doc = builder.parse(is);
            ((InputStream)is).close();
            if (!this.doc.getDocumentElement().getTagName().equals("ftpRoot")) {
                StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059", "\u6587\u66f8\u8981\u7d20\u30a8\u30e9\u30fc");
            } else {
                this.errorFlag = false;
            }
        }
        catch (ParserConfigurationException e) {
            StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u69cb\u6210\u30a8\u30e9\u30fc");
        }
        catch (FileNotFoundException e) {
            this.doc = builder.newDocument();
            try {
                Element root = this.doc.createElement("ftpRoot");
                this.doc.appendChild(root);
                this.errorFlag = false;
            }
            catch (DOMException dOMException) {}
        }
        catch (SAXException e) {
            StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "SAX\u30a8\u30e9\u30fc");
        }
        catch (IOException e) {
            StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
        }
    }

    private Element getHostElement(String name) {
        Element root = this.doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("host");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String ftpName = element.getAttribute("name");
            if (!name.equals(ftpName)) continue;
            return element;
        }
        return null;
    }

    private Element createHostElement(Host host) {
        Element element = this.doc.createElement("host");
        element.setAttribute("name", host.getName());
        element.setAttribute("server", host.getServer());
        element.setAttribute("user", host.getUser());
        element.setAttribute("password", host.getPassword());
        element.setAttribute("localInitDir", host.getLocalDir());
        element.setAttribute("encoding", host.getEncoding());
        if (host.getPasv()) {
            element.setAttribute("pasv", "pasv");
        }
        element.setAttribute("serverInitDir", host.getServerDir());
        return element;
    }

    public boolean transform() {
        boolean flag = false;
        try {
            TransformerFactory formerFactory = TransformerFactory.newInstance();
            Transformer former = formerFactory.newTransformer();
            DOMSource xmlSource = new DOMSource(this.doc.getDocumentElement());
            String path = pectin.userDir + System.getProperty("file.separator") + "ftphost.xml";
            StreamResult outputTarget = new StreamResult(new FileOutputStream(path));
            former.transform(xmlSource, outputTarget);
            flag = true;
        }
        catch (TransformerFactoryConfigurationError e) {
        }
        catch (TransformerConfigurationException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (TransformerException e) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return flag;
    }

    public boolean isError() {
        return this.errorFlag;
    }

    public Vector getFtpNames() {
        Vector<String> host = new Vector<String>();
        Element root = this.doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("host");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String ftpName = element.getAttribute("name");
            host.add(ftpName);
        }
        return host;
    }

    public boolean isFtpNameDuplicate(String name) {
        Element root = this.doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("host");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String ftpName = element.getAttribute("name");
            if (!name.equals(ftpName)) continue;
            return true;
        }
        return false;
    }

    public Host getHost(String name) {
        Element element = this.getHostElement(name);
        if (null == element) {
            return null;
        }
        boolean pasv = false;
        if (element.getAttribute("pasv").equals("pasv")) {
            pasv = true;
        }
        return new Host(element.getAttribute("name"), element.getAttribute("server"), element.getAttribute("user"), element.getAttribute("password"), element.getAttribute("localInitDir"), element.getAttribute("encoding"), pasv, element.getAttribute("serverInitDir"));
    }

    public boolean append(Host host) {
        try {
            Element element = this.createHostElement(host);
            Element root = this.doc.getDocumentElement();
            root.appendChild(element);
        }
        catch (DOMException e) {
            return false;
        }
        return true;
    }

    public boolean update(String oldName, Host host) {
        try {
            Element oldElement = this.getHostElement(oldName);
            Element newElement = this.createHostElement(host);
            Node parentNode = oldElement.getParentNode();
            parentNode.replaceChild(newElement, oldElement);
        }
        catch (DOMException e) {
            return false;
        }
        return true;
    }

    public boolean delete(String name) {
        try {
            Element element = this.getHostElement(name);
            Node parentNode = element.getParentNode();
            parentNode.removeChild(element);
        }
        catch (DOMException e) {
            return false;
        }
        return true;
    }
}

