<?php

/* -------------------------------------------------------------------------
	PC2M Web Contents Converter for Mobile Clients
	Copyright (C) 2005 ucb@rcdtokyo.com http://www.rcdtokyo.com/pc2m/note/
	Version 0.9.3 (beta) issued December 12, 2005

	ΥץϡFree Software FoundationˤGNU General Public
	LicenseΥС2뤤ϤʹߤΥСʰʲGPLפȸˤ
	Ť饤󥹤ޤΥץѼԤϡɬ GPLʸ
	ǧƤGPLʸϡ֥ http://www.gnu.org/licenses/
	ˤơ뤤ϡFree Software Foundation, Inc., 59 Temple Place - Suite
	330, Boston, MA 02111-1307 USAʸդ뤳ȤǤޤ
	ΥץϡPublic DomainʤɤǤϤʤ
	ޤ
	ΥץϡGPLȿʤ¤ꡢѤޤतʤ
	ŪǤѤ¤ΤǤϤޤ󡣤ޤΥץϡGPL
	ʤƤʪƱͤGPL˴Ť饤󥹤
	ʤФʤʤȤﲼǡۤѤʤɤԤȤǤޤ
	ΥץϡͭѤʤΤǤ뤳Ȥä󶡤ΤǤϤޤ
	ŪФŬʤɤۼݾڤޤࡢʤΤ
	ڤΤǤϤޤ󡣤ʤѤϡƼǤˤ
	ԤäƤ
------------------------------------------------------------------------- */

@include_once 'Config.inc.php';
require_once 'ClientDetect.class.php';
$client =& new ClientDetect();
if ((
		defined('RESTRICT_MOZILLA_AGENT')
		and RESTRICT_MOZILLA_AGENT === true
		and $client->dev_type == 'mozilla'
	) or (
		defined('RESTRICT_UNKNOWN_AGENT')
		and RESTRICT_UNKNOWN_AGENT === true
		and $client->dev_type == null
	)) {
	header("HTTP/1.0 403 Forbidden");
	header("Content-Type:text/plain");
	exit('Access forbidden');
}
mb_language('Japanese');
mb_internal_encoding('EUC-JP');
if (!defined('KEY_PREFIX')) {
	define('KEY_PREFIX', '');
}
if (!defined('SIZE_REDUNDANCY')) {
	define('SIZE_REDUNDANCY', 1000);
}
if (!defined('ALLOWABLE_CLENGTH')) {
	define('ALLOWABLE_CLENGTH', 300000);
}
if (!defined('ALLOWABLE_PIXSIZE')) {
	define('ALLOWABLE_PIXSIZE', 640);
}
if (!defined('KANA_CONVOPT')) {
	define('KANA_CONVOPT', 'ask');
}
$remote_url = null;
$content = null;
$title = null;
$rss_url = null;
$start_link = null;
$next_link = null;
$next_trim = null;
$total_chars = null;
$new_image = array();
$image_quality = null;
$_refresh_count = 0;
$_keys = array('d', 'c', 's', 'f', 'm', 'e', 'w', 'h', 't', 'q', 'u');
$_remote_args = $_GET;
$_raw_query = $_SERVER['QUERY_STRING'];
foreach ($_keys as $key) {
	if (isset($_remote_args[KEY_PREFIX.$key])) {
		$local_args[$key] = mb_convert_encoding($_remote_args[KEY_PREFIX.$key], 'EUC-JP', 'SJIS');
		unset($_remote_args[KEY_PREFIX.$key]);
		if ($key == 'u') {
			$search = "'&?".KEY_PREFIX.$key."='";
		} else {
			$search = "'&?".KEY_PREFIX.$key."=[^&]*'";
		}
		$_raw_query = preg_replace($search, '', $_raw_query);
	} else {
		$local_args[$key] = null;
	}
}
$_raw_query = preg_replace('/^(?:&|\+|%20|%81%40|\x20)+(.*)$/', '$1', $_raw_query);
if (defined('ENABLE_SESSION') and ENABLE_SESSION === true) {
	if ($local_args['d'] != null) {
		ini_set('session.use_cookies', '0');
		session_name(KEY_PREFIX.'d');
		session_id($local_args['d']);
		session_start();
	}
} else {
	$local_args['d'] = null;
}
$script_host = 'http'.
	(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).
	'://'.$_SERVER['HTTP_HOST'];
$script_self = basename($_SERVER['SCRIPT_NAME']).'?';
if ($local_args['d'] != null) {
	$script_self = $script_self.strip_tags(SID).'&';
}
if ($local_args['c'] != null) {
	$script_self = $script_self.KEY_PREFIX.'c='.$local_args['c'].'&';
}
if (empty($_GET) or empty($_raw_query)) {
	if (defined('DEFAULT_URL') and DEFAULT_URL) {
		$_raw_query = DEFAULT_URL;
	} else {
		if (false === $content = @include_once 'Frontpage.inc.php') {
			$content = sayError('ERROR_FRONTPAGE_MISSING');
		} else {
			$content = mb_convert_kana($content, KANA_CONVOPT);
			$title = defined('DEFAULT_TITLE')? DEFAULT_TITLE: null;
		}
	}
}
if ($content === null) {
	require_once 'HTTP/Client.php';
	require_once 'HTTP/Request/Listener.php';
	class URL_Listener extends HTTP_Request_Listener {
		var $_url;
		var $_checkedUrl;
		var $_redirUrl;
		function update(&$subject, $event, $data) {
			switch ($event) {
				case 'httpSuccess':
				case 'httpError':
					if ('' == $this->_redirUrl) {
						$this->_url = $this->_checkedUrl;
					} else {
						$this->_url = $this->_redirUrl;
					}
					break;
				case 'httpRedirect':
					$this->_redirUrl = $data;
					break;
				case 'request':
					$this->_checkedUrl = $data;
					$this->_redirUrl = '';
			}
		}
		function getResults() {
			return $this->_url;
		}
	}
	$content = retrieveContent();
}
if (isset($_SESSION)) {
	$_SESSION['referer'] = $remote_url? $remote_url: $script_host.$_SERVER['SCRIPT_NAME'];
}
$title = mb_convert_kana($title, KANA_CONVOPT);
mb_convert_variables('SJIS', 'EUC-JP', $title);
mb_convert_variables('SJIS', 'EUC-JP', $content);
require 'Template.inc.php';

/* -------------------------------------------------------------------------
	retrieveContent
------------------------------------------------------------------------- */

function retrieveContent() {

	global $remote_url;
	global $local_args;
	global $quick_search;
	global $_raw_query;
	global $_remote_args;

	$local_args['m'] = strtolower($local_args['m']);
	if (($local_args['m'] != null and $local_args['e'] == null)
		or ($local_args['e'] != null and $local_args['m'] == null)) {
		return sayError('ERROR_ARG_INVALID');
	}
	foreach($local_args as $key => $value) {
		if ($value != null) {
			switch ($key) {
				case 'd':
					if (!preg_match('/^\w{6}$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'c':
					if (!preg_match('/^\d+$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'm':
					if (!preg_match('/^(?:post|get)$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'e':
					if (!preg_match('/^[\w-_\s]+$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 't':
					if (!preg_match('/^[1-3]$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'w':
				case 'h':
					if (!preg_match('/^\d{1,3}$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
				case 'q':
					if (!preg_match('/^\d{1,3}[^\d\s]*$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
			}
		}
	}
	$_post_data = array();
	if ($local_args['m'] != null and $local_args['e'] != null) {
		if (!$local_args['u']) {
			return sayError('ERROR_URL_EMPTY');
		} else {
			$_url = $local_args['u'];
		}
		if ($local_args['m'] == 'post') {
			foreach($_remote_args as $key => $value)
				$_post_data[mb_convert_encoding($key, $local_args['e'], 'SJIS')]
				= mb_convert_encoding($value, $local_args['e'], 'SJIS');
		} else {
			$array = array();
			foreach($_remote_args as $key => $value)
				$array[count($array)] = mb_convert_encoding($key, $local_args['e'], 'SJIS').
				'='.urlencode(mb_convert_encoding($value, $local_args['e'], 'SJIS'));
			$_url = preg_replace('/(.+)\?$/', '$1', $_url).'?'.implode('&', $array);
		}
	} else {
		if (strpos($_raw_query, '?') === false
			and (
				preg_match('/%3A/i', $_raw_query)
				or preg_match('/%2F/i', $_raw_query)
			)
		) {
			$_raw_query = urldecode($_raw_query);
		}
		if (preg_match('/^(\w+):/', $_raw_query, $matches)) {
			if (!preg_match('/^https?/', $matches[1])) {
				return sayError('ERROR_SCHEME_UNSUPPORTED', $matches[1]);
			} elseif ($matches[1] == 'https'
				and (!defined('SSL_ENABLED') or !SSL_ENABLED)) {
				return sayError('ERROR_SSL_DISABLED', $_raw_query);
			} else {
				$_url = $_raw_query;
			}
		} elseif (preg_match('/^[\w-]+\.[\w-]+/', $_raw_query)) {
				$_url = 'http://'.$_raw_query;
		} else {
			$_raw_query = mb_convert_kana(mb_convert_encoding(urldecode($_raw_query), 'EUC-JP', 'SJIS'), 'asKHV');
			if (defined('QUICK_SEARCH')) {
				if (preg_match('/^\s*(\w+)\s+(.*)$/', $_raw_query, $matches)) {
					$_search_key = strtolower($matches[1]);
					$_search_string = $matches[2];
				}
				if (!isset($_search_key) or !isset($quick_search[$_search_key])) {
					$_search_key = QUICK_SEARCH;
					$_search_string = $_raw_query;
				}
				$_url = $quick_search[$_search_key][0].
					urlencode(mb_convert_encoding($_search_string, $quick_search[$_search_key][1], 'EUC-JP'));
			} else {
				return sayError('ERROR_URL_INVALID', $_raw_query);
			}
		}
	}
	$array = parse_url($_url);
	if ((
			$array['host'] == $_SERVER['HTTP_HOST']
			or (
				isset($array['port'])
				and $array['host'].':'.$array['port'] == $_SERVER['HTTP_HOST']
			)
		) and (
			$array['path'] == $_SERVER['SCRIPT_NAME']
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME'])
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME']).'/'
		)) {
		header('Location:'.$_url);
		exit;
	}
	$_content = sendRequest($_url, $_post_data);
	if (preg_match_all('/<frame\s[^>]*?>/si', $_content, $matches)) {
		$_content = sendRequest(getAttribute('src', $matches[0][0]), null, true);
		for ($i = 1; $i < count($matches[0]); $i++) {
			$_content .= '<hr>'.sendRequest(getAttribute('src', $matches[0][$i]), null, true);
		}
	}
	$_content = mb_convert_kana($_content, KANA_CONVOPT);
	if ($local_args['s'] != null) {
		if (!is_numeric($local_args['s'])) {
			$x = $local_args['s'];
			$x = preg_quote($x);
			$x = preg_replace('/\'/', "\'", $x);
			$search = "'".mb_convert_kana($x, KANA_CONVOPT)."'si";
			if (preg_match($search, $_content, $matches, PREG_OFFSET_CAPTURE)) {
				if (substr($_content, $matches[0][1] -1, 1) == '>') {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1] -1));
				} else {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1]));
				}
			} else {
				return sayError('ERROR_WORD_NOTFOUND', $local_args['s']);
			}
		} else {
			$_trim_from = $local_args['s'];
		}
	} elseif (false === $_trim_from = mb_strpos($_content, '<fragment>')) {
		$_trim_from = 0;
	}
	$_content = str_replace('<fragment>', '', $_content);
	return trimContent($_content, $_trim_from);
}

/* -------------------------------------------------------------------------
	sendRequest
------------------------------------------------------------------------- */

function sendRequest($_url, $_post_data = array(), $_is_framesrc = false) {

	global $remote_url;
	global $local_args;
	global $_current_url;
	global $_remote_charset;

	$_remote_charset = null;
	$_http_client =& new HTTP_Client(
		null,
		array(
			'Accept-Charset' => 'Shift_JIS,utf-8,*',
			'Accept-Language' => 'ja',
		)
	);
	$_http_client->attach($_url_listener =& new URL_Listener());
	if (defined('PEAR_USER_AGENT') and PEAR_USER_AGENT != null) {
		$_http_client->setDefaultHeader('User-Agent', PEAR_USER_AGENT);
	}
	if (isset($_SESSION['referer'])) {
		$_http_client->setDefaultHeader('Referer', $_SESSION['referer']);
	}
	if (isset($_SESSION['cookies'])) {
		foreach ($_SESSION['cookies'] as $key => $value) {
			$_http_client->_cookieManager->addCookie($value);
		}
	}
	if (!empty($_post_data)) {
		$_http_client->post($_url, $_post_data);
		$_response =& $_http_client->currentResponse();
		if (!$_response) {
			if (!$_is_framesrc) {
				$remote_url = $_url;
			}
			return sayError('ERROR_SERVER_NORESPONSE', $_url);
		}
	} else {
		$_http_client->head($_url);
		$_response =& $_http_client->currentResponse();
		if (!$_response) {
			if (!$_is_framesrc) {
				$remote_url = $_url;
			}
			return sayError('ERROR_SERVER_NORESPONSE', $_url);
		}
		if (!isset($_response['headers']['content-type'])
			or preg_match('/^(?:text|application)\/(?:plain|x?html|(?:rdf\+|rss\+)?xml)/i',
			$_response['headers']['content-type'])) {
			$_http_client->get($_url);
			$_response =& $_http_client->currentResponse();
			if (!$_response) {
				if (!$_is_framesrc) {
					$remote_url = $_url;
				}
				return sayError('ERROR_SERVER_NORESPONSE', $_url);
			} else {
				$_response['body'] = preg_replace('/\x0/', '', $_response['body']);
				$_response['body'] = preg_replace('/^\xef\xbb\xbf/', '' , $_response['body']);
			}
		} elseif (preg_match('/^image\/(?:gif|jpeg|png)/', $_response['headers']['content-type'])) {
			if (isset($_response['headers']['content-length'])
				and is_numeric($_response['headers']['content-length'])
				and (int) $_response['headers']['content-length'] > ALLOWABLE_CLENGTH) {
				if (!$_is_framesrc) {
					$remote_url = $_url_listener->getResults();
				}
				return sayError('ERROR_CLENGTH_EXCEEDED',
					$_url_listener->getResults(),
					number_format($_response['headers']['content-length']),
					number_format(ALLOWABLE_CLENGTH));
			}
		} else {
			if (!$_is_framesrc) {
				$remote_url = $_url_listener->getResults();
			}
			return sayError('ERROR_CTYPE_INVALID', $_url_listener->getResults(), $_response['headers']['content-type']);
		}
	}
	$_current_url = parse_url($_url_listener->getResults());
	$_current_url['url'] = $_url_listener->getResults();
	if (!$_is_framesrc) {
		$remote_url = $_current_url['url'];
	}
	if (isset($_SESSION)) {
		foreach ($_http_client->_cookieManager->_cookies as $key => $value) {
			$_SESSION['cookies'][$key] = $value;
		}
	}
	$_http_client->reset();
	preg_match('/^([a-z\/\+\-]+)(.*)$/', $_response['headers']['content-type'], $matches);
	switch ($_ctype = isset($matches[1])? $matches[1]: null) {
		case null:
		case 'text/html':
		case 'text/xhtml';
		case 'application/xhtml+xml':
			if (isset($matches[2]) and preg_match('/^.*\bcharset\s*=\s*(.+)$/', $matches[2], $matches)) {
				$_remote_charset = checkCharset($matches[1]);
			}
			return convertHTML($_response['body'], $_response['code'] != '200', $_is_framesrc);
			break;
		case 'image/gif':
		case 'image/jpeg':
		case 'image/png':
			if (defined('IMAGE_CONVERTER') and IMAGE_CONVERTER != null) {
				return $_is_framesrc?
					'['.mb_strimwidth(getFilename($_current_url['url']), 0, 11, "...").
					'<a href="'.addProxyURL($_current_url['url']).'">+</a>]':
					retrieveImage(
						$_current_url['url'],
						$local_args['w'],
						$local_args['h'],
						$local_args['t'],
						$local_args['q']
					);
			} else {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			break;
		case 'application/xml':
		case 'application/rdf+xml':
		case 'application/rss+xml':
		case 'text/xml':
			if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
				return convertRSS($_response['body']);
			} else {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			break;
		case 'text/plain':
			if (preg_match('/^\s*?<\?xml\s[^>]+?>\s*?<(?:rdf\:|rss\s|feed\s)[^>]+?>/si', $_response['body'])) {
				if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
					return convertRSS($_response['body']);
				} else {
					return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
				}
			} else {
				return nl2br(mb_convert_encoding($_response['body'], 'EUC-JP', 'auto'));
			}
			break;
		default:
			return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
	}
}

/* -------------------------------------------------------------------------
	convertRSS
------------------------------------------------------------------------- */

function convertRSS(&$_content) {

	global $remote_url;
	global $title;

	if (preg_match('/<\?xml\s[^>]+?\?>/si', $_content, $matches)) {
		$_xml_encoding = checkCharset(getAttribute('encoding', $matches[0]));
		$replace = '<?xml version="'.getAttribute('version', $matches[0]).'" encoding="UTF-8"?>';
		$_content = str_replace($matches[0], $replace, $_content);
	} else {
		$_content = '<?xml version="1.0" encoding="UTF-8"?>'.$_content;
	}
	if (!isset($_xml_encoding)) {
		$_xml_encoding = @mb_detect_encoding($_content);
	}
	@mb_convert_variables('UTF-8', $_xml_encoding, $_content);
	require_once 'XML/RSS.php';
	$_xml_rss =& new XML_RSS();
	$_xml_rss->setInputString($_content);
	if (PEAR::isError($_result = $_xml_rss->parse())) {
		$array = get_object_vars($_result);
		return sayError('ERROR_XML_PARSEFAILED', $remote_url, $array['message']);
	}
	if (!$_channel_info = $_xml_rss->getChannelInfo()) {
		return sayError('ERROR_RSS_INVALID', $remote_url);
	}
	$title = @mb_convert_encoding($_channel_info['title'], 'EUC-JP', 'UTF-8');
	$_content = '<p><a href="'.addProxyURL($_channel_info['link']).'">'.
		@mb_convert_encoding($_channel_info['title'], 'EUC-JP', 'UTF-8').'</a>'.
		(isset($_channel_info['description'])?
			'<br>'.@mb_convert_encoding($_channel_info['description'], 'EUC-JP', 'UTF-8').'</p>': '</p>');
	foreach ($_xml_rss->getItems() as $_item) {
		$_content .= '<p><a href="'.addProxyURL($_item['link']).'">'.
			@mb_convert_encoding($_item['title'], 'EUC-JP', 'UTF-8').'</a>';
		if (isset($_item['dc:date'])) {
			$_time =& $_item['dc:date'];
		} elseif (isset($_item['pubdate'])) {
			$_time =& $_item['pubdate'];
		}
		if (isset($_time)) {
			if (-1 != $_unixtime = strtotime($_time)) {
				$_content .= '<br>'.date('Y/m/d H:m:s', $_unixtime).'</p>';
			} else {
				$_content .= '<br>'.$_time.'</p>';
			}
		} else {
			$_content .= '</p>';
		}
		if (isset($_item['content:encoded'])) {
			$_content .= '<p>'.convertHTML($_item['content:encoded']).'</p>';
		} elseif (isset($_item['description'])) {
			$_content .= '<p>'.convertHTML($_item['description']).'</p>';
		}
	}
	$search = array(
		"'(?:<p>\s*){2,}'si",
		"'(?:<\/p>\s*){2,}'si"
	);
	$replace = array(
		"<p>",
		"</p>"
	);
	$_content = preg_replace($search, $replace, $_content);
	return $_content;
}

/* -------------------------------------------------------------------------
	convertHTML
------------------------------------------------------------------------- */

function convertHTML(&$_content, $_is_httperror = false, $_is_framesrc = false) {

	global $remote_url;
	global $rss_url;
	global $title;
	global $local_args;
	global $force_trim;
	global $replace_chars;
	global $_current_url;
	global $_remote_charset;
	global $_base_href;
	global $_refresh_count;

	if (preg_match('/<head.+?<\/head\s*?>/si', $_content, $matches)) {
		$x = preg_replace('/<!--.*?-->/si', '', $matches[0]);
		$x = preg_replace('/<script.+?<\/script\s*?>/si', '', $x);
		$_content = str_replace($matches[0], $x, $_content);
	}
	$_base_href = null;
	if (preg_match('/<base\s[^>]*?>/si', $_content, $matches)) {
		$_base_href = transAbsolutePath(getAttribute('href', $matches[0]));
	}
	if (preg_match_all('/<meta\s[^>]+?>/si', $_content, $nodes)) {
		for ($i = 0; $i < count($nodes[0]); $i++) {
			if (null !== $x = getAttribute('http-equiv', $nodes[0][$i])) {
				if (strtolower($x) == 'refresh') {
					$array = explode(';', getAttribute('content', $nodes[0][$i]));
					if (isset($array[1]) and preg_match('/(?:.*\bURL\b\s*=\s*)?(.+)/si', $array[1], $matches)) {
						if ($_current_url['url'] != $_url = transAbsolutePath($matches[1])) {
							if ($_refresh_count < 10) {
								$_refresh_count++;
								return sendRequest($_url);
							}
						}
					}
				} elseif ($_remote_charset === null
					and strtolower($x) == 'content-type') {
					$array = explode(';', getAttribute('content', $nodes[0][$i]));
					if (isset($array[1]) and preg_match('/.*\bcharset\b\s*=\s*(.+)/si', $array[1], $matches)) {
						$_remote_charset = checkCharset($matches[1]);
					}
				}
			}
		}
	}
	if ($_remote_charset === null) {
		$_remote_charset = @mb_detect_encoding($_content);
	}
	mb_convert_variables('EUC-JP', $_remote_charset, $_content);
	$search = null;
	if ($local_args['f'] != null) {
		$_fragment = preg_quote($local_args['f']);
		$_fragment = preg_replace('/\'/', "\'", $_fragment);
		$_id_search = true;
	} elseif (defined('FORCE_TRIM') and FORCE_TRIM === true) {
		foreach ($force_trim as $key => $value) {
			if (strpos(strtolower($remote_url), strtolower($key))) {
				$_fragment = is_array($value[0])? '(?:'.implode('|', $value[0]).')': $value[0];
				$_id_search = $value[1]? true: false;
				break;
			}
		}
	}
	if (isset($_fragment)) {
		if ($_id_search) {
			$search = "'^(.*?)(<\w+\s[^>]*?\b(?:name|id)\s*?=\s*?[\'\"]?".$_fragment."[^>]*?>.*)$'si";
		} else {
			$search = "'^(.*?)(".$_fragment.".*)$'s";
		}
		if (preg_match($search, $_content, $matches)) {
			$_content = $matches[1].'<fragment>'.$matches[2];
		}
	}

// if you would like to place an additional script
// to modify any element, place it here

	$_content = preg_replace('/<!--pc2m_void-->.+?<!--\/pc2m_void-->/si', '', $_content);
	$_content = preg_replace('/<!--.*?-->/si', '', $_content);
	$_content = preg_replace('/<script.+?<\/script\s*?>/si', '', $_content);
	$_content = preg_replace('/<style.+?<\/style\s*?>/si', '', $_content);
	$_content = preg_replace('/<iframe.+?<\/iframe\s*?>/si', '', $_content);
	$_content = preg_replace('/<noframe.+?<\/noframe\s*?>/si', '', $_content);
	if (!$_is_framesrc
		and preg_match_all('/<title[^>]*?>(.*?)<\/title\s*?>/si', $_content, $matches)) {
		for ($i = 0; $i < count($matches[0]); $i++) {
			$matches[1][$i] = replaceChars(preg_replace('/(?:\r\n|\n)/', '', $matches[1][$i]));
			if ($matches[1][$i] !== '') {
				$title = mb_strimwidth($matches[1][$i], 0, 60, '...');
				if ($_is_httperror) {
					$_content = $title.'<hr>'.$_content;
				}
				break;
			}
		}
	}
	$_content = preg_replace('/<title.+?<\/title\s*?>/si', '', $_content);
	if (!$_is_framesrc and preg_match_all('/<frame\s[^>]*?src[^>]+?>/si', $_content, $matches)) {
		for ($i = 0; $i < count($matches[0]); $i++) {
			$search = getAttribute('src', $matches[0][$i]);
			$replace = transAbsolutePath($search);
			$_content = str_replace($search, $replace, $_content);
		}
		return $_content;
	}
	if (defined('RSS_ENABLED')
		and RSS_ENABLED === true
		and $rss_url === null
		and preg_match('/<link\s[^>]*?\bapplication\/(?:rss\+|rdf\+)?xml\b[^>]*?>/si', $_content, $matches)) {
		$rss_url = addProxyURL(transAbsolutePath(getAttribute('href', $matches[0])));
	}
	$_content = preg_replace('/<head.+?<\/head\s*?>/si', '', $_content);
	$_content = preg_replace_callback(
		'/<pre[^>]*?>(.+?)<\/pre\s*?>/si',
		create_function('$matches','
			return nl2br($matches[1]);
		'), $_content);
	$array = array(
		'fragment', 'frame', 'h[1-6]', 'div', 'p', 'br', 'hr',
		'blockquote', 'ul', 'ol', 'li', 'table', 'tr', 'th', 'td', 'dl', 'dt', 'dd',
		'form', 'input', 'option', 'select', 'textarea',
		'a', 'img', 'image', 'embed', 'area',
	);
	$search = "'<(?!\/?".implode('\b|\/?', $array).")(?:!|\/)?[a-z][^>]*?>'si";
	$_content = preg_replace($search, '', $_content);
	$_content = preg_replace('/<(p|pre|br|hr)\s[^>]*?>/si', '<$1>', $_content);
	$_content = preg_replace(
		'/\s(?:id|class|style|target|autocomplete|cols|rows|wrap|tabindex|border|on[^\s=]+?)\s*=\s*(?:[^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")/si',
		'', $_content);
	$_content = preg_replace_callback(
		'/<input\s[^>]*?type\s*=\s*[\s\'\"]?image[\s\'\"]?[^>]*>/si',
		create_function('$matches', '
			$_alt = getAttribute("alt", $matches[0]);
			return "<input type=\"submit\" ".($_alt? "value=\"{$_alt}\"": null).">";
		'), $_content);
	$_content = preg_replace_callback(
		'/<input\s[^>]*?name\s*=\s*[\s\'\"]?__VIEWSTATE[\s\'\"]?[^>]*>/si',
		create_function('$matches', '
			if (strlen(getAttribute("value", $matches[0]) < 1000)) {
				return null;
			} else {
				return $matches[0];
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/(<a\s[^>]+?>)(.*?)<\/td\s*?>/si',
		create_function('$matches', '
			return !preg_match("/<\/a\s*?>/si", $matches[2])?
				$matches[1].$matches[2]."</a></td>": $matches[0];
		'), $_content);
	$_content = preg_replace_callback(
		'/(<a\s[^>]*?>)(.*?)<\/a\s*?>/si',
		create_function('$matches', '
			if (preg_match("/^\s*$/s", $matches[2])) {
				return null;
			}
			$_url = getAttribute("href", $matches[1]);
			if ($_url and $_url != "#") {
				return $matches[0];
			} else {
				return preg_match("/<a\s[^>]*?>/si", $matches[2])? $matches[2]."</a>": $matches[2];
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<a\s[^>]*?>/si',
		create_function('$matches', '
			$_url = getAttribute("href", $matches[0]);
			return ($_url and $_url != "#")? $matches[0]: null;
		'), $_content);
	$_content = preg_replace_callback(
		'/(<a\s[^>]*?href[^>]+?>)(.+?)<\/a\s*?>/si',
		create_function('$matches', '
			$_full_match = $matches[0];
			$_inner_element = $matches[2];
			$_link_url = getAttribute("href", $matches[1]);
			if ($_link_url and $_link_url != "#") {
				$_link_url = transAbsolutePath($_link_url);
				$_accesskey = getAttribute("accesskey", $matches[1]);
				$_title = getAttribute("title", $matches[1]);
			}
			$_valid_url = preg_match("/^(?:https?|mailto|tel)/", $_link_url);
			$_link = $_valid_url?
				"<a href=\"".addProxyURL($_link_url)."\"".
				($_accesskey? " accesskey=\"".$_accesskey."\"": null).">": null;
			$_link_close = $_valid_url? "</a>": null;
			if (!preg_match_all("/<(?:img|image)\s[^>]+?>/si", $_inner_element, $matches)) {
				return $_link.$_inner_element.$_link_close;
			} else {
				for ($i = 0; $i < count($matches); $i++) {
					$_url = getAttribute("src", $matches[0][$i]);
					$_alt = getAttribute("alt", $matches[0][$i]);
					if ($_alt == null and isset($_title)) {
						$_alt = $_title;
					}
					if ($_alt == null) {
						$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
					} else {
						$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
					}
					$_width = getAttribute("width", $matches[0][$i]);
					$_height = getAttribute("height", $matches[0][$i]);
					if (($_width or $_height)
						and (!preg_match("/^\d+$/", $_width.$_height)
						or (defined("IMG_THRESHOLD") and is_int(IMG_THRESHOLD)
						and (($_width and (int) $_width < IMG_THRESHOLD)
						or ($_height and (int) $_height < IMG_THRESHOLD))))) {
						$replace = "[".$_link.$_alt.$_link_close."]";
					} else {
						$replace = "[".$_link.$_alt.$_link_close.
							"<a href=\"".addProxyURL(transAbsolutePath($_url))."\">+</a>]";
					}
					$_result = str_replace($matches[0][$i], $replace, $_inner_element);
				}
				if (preg_match("/^(.+?)(\[.+)/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[1])) {
						$_result = "<br>".$matches[2];
					} elseif (!preg_match("/^\s+$/s", $matches[1])) {
						$_result = $_link.$matches[1].$_link_close.$matches[2];
					}
				}
				if (preg_match("/^(.+\])(.+)$/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[2])) {
						$_result = $matches[1]."<br>";
					} elseif (!preg_match("/^\s+$/s", $matches[2])) {
						$_result = $matches[1].$_link.$matches[2].$_link_close;
					}
				}
				if (preg_match_all("/\](.+?)\[/s", $_result, $matches)) {
					for ($i = 0; $i < count($matches[0]); $i++) {
						if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[1][$i])) {
							$replace = "]<br>[";
						} elseif (!preg_match("/^\s+$/s", $matches[1][$i])) {
							$replace = "]".$_link.$matches[1][$i].$_link_close."[";
						}
						$_result = str_replace($matches[0][$i], $replace, $_result);
					}
				}
				return $_result;
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<(?:img|image|embed)\s[^>]+?>/si',
		create_function('$matches', '
			$_width = getAttribute("width", $matches[0]);
			$_height = getAttribute("height", $matches[0]);
			if (($_width or $_height)
				and (!preg_match("/^\d+$/", $_width.$_height)
				or (defined("IMG_THRESHOLD")
				and (($_width and (int) $_width < IMG_THRESHOLD)
				or ($_height and (int) $_height < IMG_THRESHOLD))))) {
				return null;
			}
			$_url = getAttribute("src", $matches[0]);
			$_alt = getAttribute("alt", $matches[0]);
			if ($_alt == null) {
				$_alt = getAttribute("title", $matches[0]);
			}
			if ($_alt == null) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			} else {
				$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
			}
			$_url = addProxyURL(transAbsolutePath($_url));
			return "[{$_alt}<a href=\"{$_url}\">+</a>]";
		'), $_content);
	$_content = preg_replace_callback(
		'/<area\s[^>]+?>/si',
		create_function('$matches', '
			$_url = getAttribute("href", $matches[0]);
			$_alt = getAttribute("alt", $matches[0]);
			if ($_alt == null) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			}
			$_url = addProxyURL(transAbsolutePath($_url));
			return "<a href=\"{$_url}\">{$_alt}</a>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<frame\s[^>]+?>/si',
		create_function('$matches', '
			$_url = getAttribute("src", $matches[0]);
			$_alt = getAttribute("name", $matches[0]);
			if ($_alt == null) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			}
			$_url = addProxyURL(transAbsolutePath($_url));
			return "<a href=\"{$_url}\">{$_alt}</a>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<form\s[^>]*?action[^>]+?>/si',
		create_function('$matches', '
			global $_current_url;
			global $local_args;
			global $_remote_charset;
			$_method = getAttribute("method", $matches[0]);
			if ($_method == null) {
				$_method = "get";
			}
			$_action = transAbsolutePath(getAttribute("action", $matches[0]));
			if ($_action == null) {
				$_action = preg_replace("/^([^\?]+).*$/", "$1", $_current_url["url"]);
			}
			return "<form action=\"".basename($_SERVER["SCRIPT_NAME"])."\" method=\"get\">".
				($local_args["d"]? "<input type=\"hidden\" name=\"".KEY_PREFIX."d\" value=\"".$local_args["d"]."\">": null).
				($local_args["c"]? "<input type=\"hidden\" name=\"".KEY_PREFIX."c\" value=\"".$local_args["c"]."\">": null).
				"<input type=\"hidden\" name=\"".KEY_PREFIX."e\" value=\"".$_remote_charset."\">
				<input type=\"hidden\" name=\"".KEY_PREFIX."m\" value=\"".$_method."\">
				<input type=\"hidden\" name=\"".KEY_PREFIX."u\" value=\"".$_action."\">";
		'), $_content);
	$search = array(
		"'<div[^>]*?>'si",
		"'<\/div\s*?>'si",
		"'<(\/?)(?:h[1-6]|dl|dt|dd)[^>]*?>'si",
		"'<\/?blockquote[^>]*?>'si",
		"'<(?:ul|ol)[^>]*?>\s*(?:<li[^>]*?>)?'si",
		"'(?:<\/li>)?\s*<\/(?:ul|ol)[^>]*?>'si",
		"'(?:<\/li>)?\s*<li[^>]*?>'si",
		"'<(\/?)table[^>]*?>'si",
		"'<tr[^>]*?>[^<]*?<t[hd][^>]*?>'si",
		"'<\/t[hd]\s*?>[^<]*?<\/tr\s*?>'si",
		"'<\/t[hd]\s*?>[^<]*?<t[hd][^>]*?>'si",
		"'<t[hd][^>]*?>'si",
		"'<\/t[hd]\s*?>'si",
		"'<\/embed\s*?>'si",
	);
	$replace = array(
		"",
		"<br>",
		"<\\1p>",
		"<hr>",
		"<p>",
		"</p>",
		"<br>",
		"<\\1p>",
		"",
		"<br>",
		"\x20",
		"",
		"",
		"",
	);
	$_content = preg_replace($search, $replace, $_content);
	$_content = replaceChars($_content);
	$search = array(
		"'(?:<br>\s*){2,}'si",
		"'<p>\s*<br>'si",
		"'<br>\s*<p>'si",
		"'<\/p>\s*<br>'si",
		"'<br>\s*<\/p>'si",
		"'<p>\s*(?:<br>)?\s*<\/p>'si",
		"'(?:<hr>\s*){2,}'si",
		"'(?:<p>\s*){2,}'si",
		"'(?:<\/p>\s*){2,}'si",
		"'\x20(\r\n|\n)'",
		"'(?:(\r\n|\n)\s*){2,}'",
		"'\x20{2,}'",
		"'\t'",
	);
	$replace = array(
		"<br>",
		"<p>",
		"<p>",
		"</p>",
		"</p>",
		"",
		"<hr>",
		"<p>",
		"</p>",
		"\\1",
		"\\1",
		"\x20",
		"",
	);
	$_content = preg_replace($search, $replace, $_content);
	if (preg_match('/^(?:\s*|\s*<p>\s*<\/p>\s*)$/', $_content)) {
		return sayError('ERROR_CONTENT_EMPTY');
	}
	return $_content;
}

/* -------------------------------------------------------------------------
	trimContent
------------------------------------------------------------------------- */

function trimContent(&$_content, $_trim_from = 0) {

	global $client;
	global $remote_url;
	global $title;
	global $start_link;
	global $next_link;
	global $next_trim;
	global $total_chars;
	global $local_args;
	global $script_self;
	global $_remote_args;

	$_deduct = SIZE_REDUNDANCY + (strlen(urlencode($remote_url)) *5);
	if ($local_args['c']) {
		$_bytes_per_page = ((int) $local_args['c'] *1000) - $_deduct;
	} else {
		$_bytes_per_page = $client->getCacheSize() - $_deduct;
	}
	if ($_bytes_per_page < 100) {
		return sayError('ERROR_CACHESIZE_TOOSMALL');
	}
	$_total_bytes = mb_strwidth($_content);
	$total_chars = mb_strlen($_content);
	if ($_trim_from != 0 or $_total_bytes > $_bytes_per_page) {
		if ($_trim_from >= $total_chars) {
			return sayError('ERROR_DIVPOINT_OUTRANGE', number_format($_trim_from), number_format($total_chars));
		}
		$_trimmed_segment = mb_strimwidth($_content, $_trim_from, $_bytes_per_page, null);
		if ($_trim_from > 0
			and mb_strpos($_trimmed_segment, '<') > mb_strpos($_trimmed_segment, '>')) {
			$_trim_from = mb_strrpos(mb_substr($_content, 0, $_trim_from), '<');
			$_trimmed_segment = mb_strimwidth($_content, $_trim_from, $_bytes_per_page, null);
		}
		$_content =& $_trimmed_segment;
		$_last_gt = mb_strrpos($_content, '>');
		if (mb_strrpos($_content, '<') > $_last_gt) {
			$_content = mb_substr($_content, 0, ($_last_gt +1));
		}
		$_added_chars = 0;
		$_select_begin = mb_strrpos(strtolower($_content), '<select');
		$_select_end = mb_strrpos(strtolower($_content), '</select>');
		if ($_select_begin) {
			if (!$_select_end or $_select_begin > $_select_end) {
				$_content .= '</select>';
				$_added_chars = strlen('</select>');
			}
		}
		$_select_begin = mb_strpos(strtolower($_content), '<select');
		$_select_end = mb_strpos(strtolower($_content), '</select>');
		if ($_select_end) {
			if (!$_select_begin or $_select_begin > $_select_end) {
				$_content = '<select>'.$_content;
				$_added_chars = strlen('<select>');
			}
		}
		if ($local_args['m'] != 'post') {
			$_proceed = KEY_PREFIX.'u='.$remote_url;
		} else {
			$_proceed = KEY_PREFIX.'m=post'.
				'&'.KEY_PREFIX.'e='.$local_args['e'].
				'&'.KEY_PREFIX.'u='.$local_args['u'];
			foreach ($_remote_args as $key => $value) {
				if ($value != null) {
					$_proceed .= '&'.$key.'='.$value;
				}
			}
		}
		if ($_trim_from != 0) {
			$start_link = $script_self.KEY_PREFIX.'s=0&'.$_proceed;
		}
		$next_trim = $_trim_from + mb_strlen($_content) - $_added_chars;
		if ($total_chars > $next_trim) {
			$next_link = $script_self.KEY_PREFIX.'s='.$next_trim.'&'.$_proceed;
		}
	}
	return $_content;
}

/* -------------------------------------------------------------------------
	retrieveImage
------------------------------------------------------------------------- */

function retrieveImage($_url, $_width, $_height, $_type, $_quality) {

	global $client;
	global $new_image;
	global $image_quality;

	$client->getScreenInfo();
	if ($client->screen['color'] < 256) {
		return sayError('ERROR_COLOR_INCAPABLE');
	}
	if (false === $_original_image = @getImageSize($_url)) {
		return sayError('ERROR_ISNOT_IMAGE', $_url);
	}
	if ($_original_image[2] > 3) {
		return sayError('ERROR_UNSUPPORTED_IMAGE', $_url);
	}
	if (!$_type) {
		$_type = $_original_image[2];
	}
	switch($client->screen['gif_support']
		+ $client->screen['jpg_support']
		+ $client->screen['png_support']) {
		case 1:
			if ($client->screen['gif_support']) {$_type = 1;}
			if ($client->screen['jpg_support']) {$_type = 2;}
			if ($client->screen['png_support']) {$_type = 3;}
			break;
		case 2:
			switch ($_type) {
				case 1:
					$_type = $client->screen['gif_support']? 1: 3;
					break;
				case 2:
					$_type = $client->screen['jpg_support']? 2: 3;
					break;
				case 3:
					$_type = $client->screen['png_support']? 3: 1;
			}
			break;
	}
	if ($_quality != null)
		if (preg_match('/^(\d{1,3})([^\d\s])/', $_quality, $matches)) {
			$_quality = $matches[1];
			$_ratio_identifier = $matches[2];
		if (isset($_ratio_identifier) or $_type == 2) {
			if ($_quality < 0) {
				$_quality = 0;
			}
			if ($_quality > 100) {
				$_quality = 100;
			}
			if (isset($_ratio_identifier)) {
				$_quality = $_quality.$_ratio_identifier;
			}
		} else {
			if ($_quality < 1) {
				$_quality = 1;
			}
			if ($_quality > 256) {
				$_quality = 256;
			}
		}
	}
	$image_quality = $_quality;
	if ($_width > ALLOWABLE_PIXSIZE) {
		$_width = ALLOWABLE_PIXSIZE;
	}
	if ($_height > ALLOWABLE_PIXSIZE) {
		$_height = ALLOWABLE_PIXSIZE;
	}
	if ($_width or $_height) {
		$new_image = array(
			$_width? $_width: round($_original_image[0] * $_height / $_original_image[1]),
			$_height? $_height: round($_original_image[1] * $_width / $_original_image[0]),
			$_type);
	} else {
		$new_image = array(
			$client->screen['width'],
			round($_original_image[1] * $client->screen['width'] / $_original_image[0]),
			$_type);
	}
	if ($new_image[0] > $_original_image[0]) {
		$new_image[0] = $_original_image[0];
	}
	if ($new_image[1] > $_original_image[1]) {
		$new_image[1] = $_original_image[1];
	}
	if ($new_image[0] != $_original_image[0]
		or $new_image[1] != $_original_image[1]
		or $new_image[2] != $_original_image[2]
		or $_quality != null) {
		$_content = '<img src="'.IMAGE_CONVERTER.'?'.
			$new_image[0].','.
			$new_image[1].','.
			$new_image[2].','.
			$_original_image[0].','.
			$_original_image[1].','.
			$_original_image[2].','.
			$_quality.','.
			urlencode($_url).
			'">';
	} else {
		$_content = '<img src="'.$_url.'">';
	}
	return $_content;
}

/* -------------------------------------------------------------------------
	Miscellaneous Functions
------------------------------------------------------------------------- */

function sayError($_error_string) {

	if (false === $_messages = @include 'ErrorMessages.inc.php') {
		$_message =& $_error_string;
	} else {
		if (isset($_messages[$_error_string])) {
			$_message =& $_messages[$_error_string];
		} else {
			$_message =& $_error_string;
		}
	}
	$args = func_get_args();
	for ($i = 1; $i < count($args); $i++) {
		$search = "'{%".$i."}'";
		$_message = preg_replace($search, "$args[$i]", $_message);
	}
	return mb_convert_kana($_message, KANA_CONVOPT);
}

function replaceChars($_content) {

	global $replace_chars;

	$_content = mb_decode_numericentity($_content,
		array(
			0x2000, 0xDFFF, 0x0000, 0xFFFF,
			0xFA00, 0xFFFF, 0x0000, 0xFFFF,
		)
	);
	if (isset($replace_chars)) {
		$search = array();
		$replace = array();
		foreach ($replace_chars as $key => $value) {
			$search[count($search)] = $key;
			$replace[count($replace)] = $value;
		}
		return preg_replace($search, $replace, $_content);
	} else {
		return $_content;
	}
}

function checkCharset($_string) {

	$_string = preg_replace('/^x-(.+)$/', '$1', $_string);
	$_charsets = array(
		"'^UTF-(?:7|8|16|32)(?:BE|LE)?$'i",
		"'^(?:SJIS|Shift_JIS|EUC-JP|ISO-2022-JP)$'i",
		"'^(?:ISO-8859-(?:1|15)|Windows-1252)$'i",
		"'^(?:Big5|EUC-TW|HZ)$'i",
		"'^(?:EUC-KR|ISO-2022-KR|UHC)$'i",
		"'^(?:ISO-8859-(?:[2-9]|1[0-4])|Windows-1251|KOI8-R)$'i",
	);
	foreach ($_charsets as $search) {
		if (preg_match($search, $_string)) {
			return $_string;
			break;
		}
	}
	return null;
}

function transAbsolutePath($_path) {

	global $_base_href;
	global $_current_url;

	if (preg_match('/^\w+:/i', $_path)) {
		return $_path;
	}
	if (!isset($_base_href)) {
		$_remote_host = $_current_url['scheme'].'://'.$_current_url['host'].
			((isset($_current_url['port']) and $_current_url['port'] != 80)?
			':'.$_current_url['port']: null);
		$_remote_path = isset($_current_url['path'])? $_current_url['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	} else {
		$array = parse_url($_base_href);
		$_remote_host = $array['scheme'].'://'.$array['host'].
			((isset($array['port']) and $array['port'] != 80)?
			':'.$array['port']: null);
		$_remote_path = isset($array['path'])? $array['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	}
	$_path = preg_replace('/^\.\//', '', $_path);
	$search = "'^((?:\.\.\/){1,})'";
	if (preg_match($search, $_path, $matches)) {
		$_path = substr($_path, strlen($matches[1]));
		$count = strlen($matches[1]) / 3;
		$array = explode('/', $_remote_dir);
		array_pop($array);
		while ($count) {
			array_pop($array);
			$count--;
		}
		$_remote_dir = implode('/', $array);
		$_remote_dir .= '/';
	}
	if (preg_match('/^\//', $_path)) {
		$_path = $_remote_host.$_path;
	}
	if (preg_match('/^#/', $_path)) {
		$_path = $_current_url['url'].$_path;
	}
	if (preg_match('/^(?!https?:\/\/)/i', $_path)) {
		$_path = $_remote_host.$_remote_dir.$_path;
	}
	return $_path;
}

function addProxyURL($_url) {

	global $script_self;

	if (!preg_match('/^https?:\/\//', $_url)) {
		return $_url;
	} else {
		if (preg_match('/^([^#]+)#(.+)$/', $_url, $matches)) {
			$_url = KEY_PREFIX.'f='.urlencode($matches[2]).'&'.KEY_PREFIX.'u='.urlencode($matches[1]);
		} else {
			$_url = KEY_PREFIX.'u='.urlencode($_url);
		}
		return $script_self.$_url;
	}
}

function getDirName($_path) {

	return substr($_path, 0, strrpos($_path, '/') +1);
}

function removeQuote($_string) {

	return preg_replace('/[\'\"]?([^\'\"]+)[\'\"]?/', '$1', $_string);
}

function getAttribute($_param, $_string) {

	$search = "'\b{$_param}\s*=\s*([^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")'si";
	if (preg_match($search, $_string, $matches)) {
		return removeQuote($matches[1]);
	}
}

function getFilename($_url) {

	if (preg_match('/^(\w+):(.+)$/', $_url, $matches)
		and !preg_match('/^(?:https?|ftps?)/', $matches[1])) {
		return $matches[2];
	} else {
		$array = @parse_url($_url);
		if ($array) {
			if (isset($array['path']) and basename($array['path']) != null) {
				return preg_replace('/^([\w-_%]+).*$/', '$1', basename($array['path']));
			} elseif (isset($array['fragment'])) {
				return $array['fragment'];
			} elseif (isset($array['host'])) {
				return preg_replace('/^www\./', '', $array['host']);
			}
		} else {
			return $_url;
		}
	}
}

?>