/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.util;

import java.io.File;

import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;

import jp.sf.pal.wiki.WikiConstants;

/**
 * @author shinsuke
 * 
 */
public class WikiUtil {
    public static PortletConfig getPortletConfig() {
        String name = "javax.portlet.PortletConfig";
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new IllegalStateException(
                    "Could not find FacesContext instance.");
        }
        return (PortletConfig) context.getExternalContext().getRequestMap()
                .get(name);
    }

    public static String getInitParameter(String key) {
        return getPortletConfig().getInitParameter(key);
    }

    public static String getWikiRootDir() {
        String rootPath = getInitParameter(WikiConstants.ROOT_DIRECTORY);
        if (rootPath == null) {
            rootPath = getContextRealPath(WikiConstants.DEFAULT_ROOT_DIRECTORY);
        } else if (rootPath.startsWith(WikiConstants.WEBAPP_ROOT_KEY)) {
            return getContextRealPath(rootPath
                    .substring(WikiConstants.WEBAPP_ROOT_KEY.length()));
        }
        return rootPath;
    }

    public static String getContextRealPath(String path) {
        return getPortletConfig().getPortletContext().getRealPath(path);
    }

    public static String getWikiDataDir() {
        return getWikiRootDir() + File.separator + WikiConstants.DATA_DIRECTORY;
    }

    public static String getEncoding() {
        String encoding = getInitParameter(WikiConstants.ENCODING);
        if (encoding != null) {
            return encoding;
        }
        return "UTF-8";
    }

    public static String getRequestContextPath() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new IllegalStateException(
                    "Could not find FacesContext instance.");
        }
        return context.getExternalContext().getRequestContextPath();
    }

    public static String getCreateNewPageIconPath() {
        return getRequestContextPath() + "/images/icons/page_add.png";
    }

    public static String getEditPageIconPath() {
        return getRequestContextPath() + "/images/icons/page_edit.png";
    }

    public static String getDisplayListPageIconPath() {
        return getRequestContextPath() + "/images/icons/folder_page.png";
    }

    public static String getDisplayContentPageIconPath() {
        return getRequestContextPath() + "/images/icons/page.png";
    }

    public static String getBackToPageIconPath() {
        return getRequestContextPath() + "/images/icons/arrow_turn_left.png";
    }
}
