/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpSession;

import jp.sf.pal.facesdevfilter.util.Enumerator;

/**
 * This class is a Map-based implementaion.
 * 
 * @author shinsuke
 * 
 */
public class PortletPreferencesImpl implements PortletPreferences {

    private static final String PREFERENCE_MAP = "PREFERENCE_MAP";

    private HttpSession httpSession;

    private Map preferenceMap;

    public PortletPreferencesImpl(HttpSession httpSession) {
        this.httpSession = httpSession;
        resetPreferences();
    }

    private void resetPreferences() {
        this.preferenceMap = new HashMap();
        Map prefMap = (Map) httpSession.getAttribute(PREFERENCE_MAP);
        if (prefMap != null) {
            prefMap.putAll(preferenceMap);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#getMap()
     */
    public Map getMap() {
        return preferenceMap;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#getNames()
     */
    public Enumeration getNames() {
        return new Enumerator(preferenceMap.keySet().iterator());
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#getValue(java.lang.String,
     *      java.lang.String)
     */
    public String getValue(String key, String defaultValue) {
        String value = (String) preferenceMap.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#getValues(java.lang.String,
     *      java.lang.String[])
     */
    public String[] getValues(String key, String[] defaultValues) {
        String[] values = (String[]) preferenceMap.get(key);
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#isReadOnly(java.lang.String)
     */
    public boolean isReadOnly(String key) {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#reset(java.lang.String)
     */
    public void reset(String key) throws ReadOnlyException {
        preferenceMap.remove(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#setValue(java.lang.String,
     *      java.lang.String)
     */
    public void setValue(String key, String value) throws ReadOnlyException {
        preferenceMap.put(key, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#setValues(java.lang.String,
     *      java.lang.String[])
     */
    public void setValues(String key, String[] values) throws ReadOnlyException {
        preferenceMap.put(key, values);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletPreferences#store()
     */
    public void store() throws IOException, ValidatorException {
        // TODO check if the current thread is in processAction or render
        httpSession.setAttribute(PREFERENCE_MAP, preferenceMap);
        resetPreferences();
    }

}
