/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesresponse.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletContext;
import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.io.BufferedResponseStreamFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BufferedResponseRenderKit
extends RenderKit {
    private static final Log log = LogFactory.getLog((Class)BufferedResponseRenderKit.class);
    private RenderKit parent;

    public BufferedResponseRenderKit(RenderKit parent) {
        this.parent = parent;
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        this.parent.addRenderer(family, rendererType, renderer);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this.parent.createResponseStream(out);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        BufferedResponseStream bufferedResponseStream;
        if (FacesContext.getCurrentInstance().getExternalContext().getContext() instanceof ServletContext) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("createResponseWriter(Writer, String, String) - Servlet environment: context=" + FacesContext.getCurrentInstance().getExternalContext().getContext()));
            }
            return this.parent.createResponseWriter(writer, contentTypeList, characterEncoding);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createResponseWriter(Writer, String, String) - Portlet environment: context=" + FacesContext.getCurrentInstance().getExternalContext().getContext()));
        }
        if ((bufferedResponseStream = BufferedResponseStreamFactory.getBufferedResponseStream()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"createResponseWriter(Writer, String, String) - BufferedResponseStream is null.");
            }
            return this.parent.createResponseWriter(writer, contentTypeList, characterEncoding);
        }
        Writer bufferedWriter = bufferedResponseStream.getFacesWriter();
        if (bufferedWriter == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"createResponseWriter(Writer, String, String) - Writer of the  BufferedResponseStream is null.");
            }
            return this.parent.createResponseWriter(writer, contentTypeList, characterEncoding);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"createResponseWriter(Writer, String, String) - ResponseWriter is replaced.");
        }
        return this.parent.createResponseWriter(writer, contentTypeList, characterEncoding).cloneWithWriter(bufferedWriter);
    }

    public boolean equals(Object obj) {
        return this.parent.equals(obj);
    }

    public Renderer getRenderer(String family, String rendererType) {
        return this.parent.getRenderer(family, rendererType);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.parent.getResponseStateManager();
    }

    public int hashCode() {
        return this.parent.hashCode();
    }

    public String toString() {
        return this.parent.toString();
    }
}

