/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jstock.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;

public class PriceUtil {
    
    public static BigDecimal convertToBigDecimal(String price) throws ParseException {
        
        String subPrice = price.substring(price.indexOf('+')+1);
        
        NumberFormat nf = NumberFormat.getInstance();
        return new BigDecimal(nf.parse(subPrice).toString());
    }
    
}
