/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jmap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.util.ResourceBundle;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * HelloWorldPortlet is a portlet to say "Hello!"
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class JMapPortlet extends GenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(JMapPortlet.class);

    public static final String DEFAULT_MAP_VALUE = "35/40/40.000,139/46/13.600";

    public static final String MAP_VALUE = "MAP_VALUE";

    public static final String MESSAGE = "MESSAGE";

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        String viewPage = "/WEB-INF/jsp/view.jsp";
        renderView(request, response, viewPage);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doEdit(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doEdit(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        String viewPage = "/WEB-INF/jsp/edit.jsp";
        String msg = request.getParameter(MESSAGE);
        if (msg == null)
        {
            msg = "";
        }
        request.setAttribute(MESSAGE, msg);

        renderView(request, response, viewPage);
    }

    protected void renderView(RenderRequest request, RenderResponse response,
            String viewPage) throws PortletException, IOException
    {
        response.setContentType("text/html");

        PortletContext context = getPortletContext();
        PortletPreferences prefs = request.getPreferences();
        request.setAttribute(MAP_VALUE, prefs.getValue(MAP_VALUE,
                DEFAULT_MAP_VALUE));
        PortletRequestDispatcher rd = context.getRequestDispatcher(viewPage);
        rd.include(request, response);
    }

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException
    {
        if (request.getPortletMode().equals(PortletMode.EDIT))
        {
            String value = request.getParameter(MAP_VALUE);
            if (value == null)
            {
                value = "";
            }
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(MAP_VALUE, value);
            prefs.store();

            ResourceBundle bundle = getPortletConfig().getResourceBundle(
                    request.getLocale());
            response.setRenderParameter(MESSAGE, bundle
                    .getString("JMapPortlet.msg.Updated"));
        }

        return;
    }

}
