/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.wrapper;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionsRenderResponseWrapper
implements RenderResponse {
    private static final Log log = LogFactory.getLog((Class)ExtensionsRenderResponseWrapper.class);
    private RenderResponse renderResponse;
    private ByteArrayOutputStream stream = null;
    private ExtendedBufferedOutputStream bufferedStream = null;
    private PrintWriter printWriter = null;

    public ExtensionsRenderResponseWrapper(RenderResponse renderResponse) {
        this.renderResponse = renderResponse;
        this.stream = new ByteArrayOutputStream();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.bufferedStream != null) {
            return this.bufferedStream;
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            OutputStreamWriter streamWriter = new OutputStreamWriter(this.getPortletOutputStream(), Charset.forName(this.getCharacterEncoding()));
            this.printWriter = new PrintWriter((Writer)streamWriter, true);
        }
        return this.printWriter;
    }

    public void reset() {
        this.renderResponse.reset();
        this.stream = new ByteArrayOutputStream();
        this.resetBuffer();
        this.bufferedStream = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("The response has already been committed.");
        }
        if (this.bufferedStream != null) {
            this.bufferedStream.reset();
        } else {
            log.warn((Object)"The buffer size is not defined.");
        }
    }

    public void setBufferSize(int arg0) {
        if (this.isCommitted()) {
            throw new IllegalStateException("The response has already been committed.");
        }
        if (this.bufferedStream == null) {
            this.bufferedStream = new ExtendedBufferedOutputStream(this.stream, arg0);
        } else {
            log.warn((Object)"The buffer has been already defined.");
        }
    }

    public void flushBuffer() throws IOException {
        if (this.bufferedStream != null) {
            this.bufferedStream.flush();
        }
    }

    public int getBufferSize() {
        if (this.bufferedStream != null) {
            this.bufferedStream.getBufferSize();
        }
        return 0;
    }

    public void addProperty(String arg0, String arg1) {
        this.renderResponse.addProperty(arg0, arg1);
    }

    public PortletURL createActionURL() {
        return this.renderResponse.createActionURL();
    }

    public PortletURL createRenderURL() {
        return this.renderResponse.createRenderURL();
    }

    public String encodeURL(String arg0) {
        return this.renderResponse.encodeURL(arg0);
    }

    public String getCharacterEncoding() {
        return this.renderResponse.getCharacterEncoding();
    }

    public String getContentType() {
        return this.renderResponse.getContentType();
    }

    public Locale getLocale() {
        return this.renderResponse.getLocale();
    }

    public String getNamespace() {
        return this.renderResponse.getNamespace();
    }

    public void setContentType(String arg0) {
        this.renderResponse.setContentType(arg0);
    }

    public void setProperty(String arg0, String arg1) {
        this.renderResponse.setProperty(arg0, arg1);
    }

    public void setTitle(String arg0) {
        this.renderResponse.setTitle(arg0);
    }

    public boolean isCommitted() {
        return this.renderResponse.isCommitted();
    }

    public class ExtendedBufferedOutputStream
    extends BufferedOutputStream {
        public ExtendedBufferedOutputStream(OutputStream out, int size) {
            super(out, size);
        }

        public ExtendedBufferedOutputStream(OutputStream out) {
            this(out, 512);
        }

        public void reset() {
            this.count = 0;
        }

        public int getBufferSize() {
            return this.buf.length;
        }
    }
}

