/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.todolist.model;

import java.util.Calendar;
import java.util.Date;

import jp.sf.pal.todolist.AbstractTestCase;
import jp.sf.pal.todolist.TodoListConstants;
import jp.sf.pal.todolist.dao.TodoDao;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class TodoListTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(TodoListTest.class);

    public static long testId = -1;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public TodoListTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new TodoListTest("addTodo"));
        suite.addTest(new TodoListTest("deleteTodo"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void addTodo()
    {

        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/todolist/TodoList.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        TodoDao todoDao = (TodoDao) container.getComponent(TodoDao.class);

        Todo todo = new Todo();
        Date now = Calendar.getInstance().getTime();
        todo.setCreatedtime(now);
        todo.setDescription("Description");
        todo.setDuedate(now);
        todo.setOwner("owner");
        todo.setViewmode(TodoListConstants.PUBLIC_VIEW_MODE);
        todo.setStatus("NONE");
        todo.setTitle("TITLE");

        todoDao.save(todo);

        testId = todo.getId();

        SingletonS2ContainerFactory.destroy();

        assertTrue(testId != -1);

    }

    public void deleteTodo()
    {
        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/todolist/TodoList.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        TodoDao todoDao = (TodoDao) container.getComponent(TodoDao.class);
        S2SessionFactoryImpl s2SessionFactory = (S2SessionFactoryImpl) SingletonS2ContainerFactory.getContainer()
                .getComponent(S2SessionFactoryImpl.class);

        Todo todo = todoDao.getTodoById(testId);

        todoDao.delete(todo);

        s2SessionFactory.getSession().flush();

        assertNull(todoDao.getTodoById(testId));

        SingletonS2ContainerFactory.destroy();

    }
}
