/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.todolist.util;

import jp.sf.pal.todolist.TodoListRuntimeException;
import jp.sf.pal.todolist.dao.TodoDao;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class TodoListDaoUtil
{
    public static TodoDao getTodoDao() throws TodoListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getTodoDao(container);
    }

    public static TodoDao getTodoDao(S2Container container) throws TodoListRuntimeException
    {
        TodoDao todoDao = (TodoDao) container.getComponent(TodoDao.class);
        if (todoDao == null)
        {
            throw new TodoListRuntimeException("TodoDao is null. Check the configuration for S2Container.");
        }
        return todoDao;
    }

}
