/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.todolist.bean;

import java.util.Calendar;
import java.util.Date;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.todolist.TodoListConstants;
import jp.sf.pal.todolist.model.Todo;
import jp.sf.pal.todolist.util.TodoListDaoUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;
import com.marevol.utils.util.DateUtil;

public class TodoListAddPageBean
{
    private String title;

    private String description;

    private String owner;

    private Date dueDate;

    private Integer dueHour;

    private Integer dueMin;

    private boolean publicView;

    public TodoListAddPageBean()
    {
        publicView = true;
    }

    public String save()
    {
        try
        {
            Todo todo = new Todo();
            todo.setTitle(getTitle());
            todo.setDescription(getDescription());
            todo.setOwner(getOwner());
            if (isPublicView())
            {
                todo.setViewmode(TodoListConstants.PUBLIC_VIEW_MODE);
            }
            else
            {
                todo.setViewmode(TodoListConstants.PRIVATE_VIEW_MODE);
            }
            todo.setStatus(TodoListConstants.STATUS_0);
            todo.setCreatedtime(Calendar.getInstance().getTime());
            todo.setDuedate(DateUtil.get(DateUtil.getYear(dueDate), DateUtil.getMonth(dueDate), DateUtil
                    .getDate(dueDate), getDueHour().intValue(), getDueMin().intValue(), 0, 0));
            TodoListDaoUtil.getTodoDao().save(todo);

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString("todolistaddpagebean.AddedToDoTask"));

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
        catch (RuntimeException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString("todolistaddpagebean.FailedToAddIt"),
                    e.toString());

            return TodoListConstants.TODOLISTVIEW_VIEW_ID;
        }
    }

    public String back()
    {
        return TodoListConstants.TODOLISTVIEW_VIEW_ID;
    }

    public SelectItem[] getDueHourItems()
    {
        return TodoListConstants.HOURS_FOR_MENU;
    }

    public SelectItem[] getDueMinItems()
    {
        return TodoListConstants.MINUTES_FOR_MENU;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description The description to set.
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return Returns the dueDate.
     */
    public Date getDueDate()
    {
        return dueDate;
    }

    /**
     * @param dueDate The dueDate to set.
     */
    public void setDueDate(Date dueDate)
    {
        this.dueDate = dueDate;
    }

    /**
     * @return Returns the dueHour.
     */
    public Integer getDueHour()
    {
        return dueHour;
    }

    /**
     * @param dueHour The dueHour to set.
     */
    public void setDueHour(Integer dueHour)
    {
        this.dueHour = dueHour;
    }

    /**
     * @return Returns the dueMin.
     */
    public Integer getDueMin()
    {
        return dueMin;
    }

    /**
     * @param dueMin The dueMin to set.
     */
    public void setDueMin(Integer dueMin)
    {
        this.dueMin = dueMin;
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * @return Returns the publicView.
     */
    public boolean isPublicView()
    {
        return publicView;
    }

    /**
     * @param publicView The publicView to set.
     */
    public void setPublicView(boolean publicView)
    {
        this.publicView = publicView;
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (owner == null)
        {
            return FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        }
        return owner;
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner)
    {
        this.owner = owner;
    }
}
