/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import org.hsqldb.DataFileCache;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.ScriptRunner;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ZipUnzipFile;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;

class Log {
    private static final int COPY_BLOCK_SIZE = 65536;
    private HsqlDatabaseProperties pProperties;
    private String sName;
    private Database dDatabase;
    private ScriptWriterText dbLogWriter;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private String sFileLog;
    private boolean bRestoring;
    private boolean filesReadOnly;
    int maxLogSize;
    int iLogCount;
    int scriptFormat;
    private Object timerTask;
    volatile int writeDelay = 60;
    private DataFileCache cCache;
    private static final HsqlTimer timer = DatabaseManager.getTimer();
    private HashMap textCacheList = new HashMap();

    Log(Database database, String string) throws HsqlException {
        this.dDatabase = database;
        this.sName = string;
        this.pProperties = database.getProperties();
        if (!database.isFilesReadOnly()) {
            LogSyncRunner logSyncRunner = new LogSyncRunner();
            this.timerTask = timer.schedulePeriodicallyAfter(0L, 1000L, logSyncRunner, false);
        }
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.dbLogWriter != null) {
            this.dbLogWriter.setWriteDelay(n);
        }
    }

    void readScript() throws HsqlException {
        this.bRestoring = true;
        try {
            if (this.dDatabase.isFilesInJar() || FileUtil.exists(this.sFileScript)) {
                ScriptReaderBase scriptReaderBase = ScriptReaderBase.newScriptReader(this.dDatabase, this.sFileScript, this.scriptFormat);
                scriptReaderBase.readAll(this.dDatabase.sessionManager.getSysSession());
                scriptReaderBase.close();
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException.getMessage());
        }
        if (!this.dDatabase.isFilesInJar() && FileUtil.exists(this.sFileLog)) {
            ScriptRunner.runScript(this.dDatabase, this.sFileLog, 0);
        }
        this.bRestoring = false;
    }

    void open() throws HsqlException {
        int n = this.pProperties.getIntegerProperty("hsqldb.log_size", 0);
        this.maxLogSize = n * 1024 * 1024;
        this.scriptFormat = this.pProperties.getIntegerProperty("hsqldb.script_format", 0);
        this.filesReadOnly = this.dDatabase.isFilesReadOnly();
        this.sFileScript = this.sName + ".script";
        this.sFileLog = this.sName + ".log";
        this.sFileCache = this.sName + ".data";
        this.sFileBackup = this.sName + ".backup";
        if (this.filesReadOnly) {
            if (this.cCache != null) {
                this.cCache.open(true);
            }
            this.reopenAllTextCaches();
            this.readScript();
            return;
        }
        boolean bl = false;
        int n2 = this.pProperties.getDBModified();
        try {
            if (n2 == 2) {
                FileUtil.renameOverwrite(this.sFileScript + ".new", this.sFileScript);
                FileUtil.renameOverwrite(this.sFileBackup + ".new", this.sFileBackup);
                FileUtil.delete(this.sFileLog);
            } else if (n2 == 1) {
                this.restoreBackup();
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pProperties.setDBModified(1);
        if (this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        if (!this.dDatabase.isNew) {
            this.readScript();
            if (bl) {
                this.close(false, true);
                this.pProperties.setDBModified(1);
                if (this.cCache != null) {
                    this.cCache.open(false);
                }
                this.reopenAllTextCaches();
            }
        }
        this.openLog();
    }

    DataFileCache getCache() throws HsqlException {
        if (this.dDatabase.isFilesInJar()) {
            return null;
        }
        if (this.cCache == null) {
            this.cCache = new DataFileCache(this.sFileCache, this.dDatabase);
            this.cCache.open(this.filesReadOnly);
        }
        return this.cCache;
    }

    void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    void close(boolean bl, boolean bl2) throws HsqlException {
        boolean bl3 = false;
        if (this.filesReadOnly) {
            return;
        }
        this.closeLog();
        this.writeScript(bl);
        if (bl2 && this.cCache != null) {
            bl3 = this.cCache.fileModified;
            this.cCache.close();
        }
        this.closeAllTextCaches(bl);
        if (bl2 && bl3 && !bl) {
            this.cCache.backup(this.sFileBackup + ".new");
        }
        this.pProperties.setDBModified(2);
        try {
            FileUtil.renameOverwrite(this.sFileScript + ".new", this.sFileScript);
            FileUtil.delete(this.sFileLog);
            if (bl2 && bl3 && !bl) {
                FileUtil.renameOverwrite(this.sFileBackup + ".new", this.sFileBackup);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pProperties.setProperty("version", "1.7.3");
        this.pProperties.setProperty("hsqldb.compatible_version", "1.7.2");
        this.pProperties.setDBModified(0);
        if (bl) {
            try {
                this.stop();
                if (FileUtil.exists(this.sFileCache)) {
                    DataFileCache.resetFreePos(this.sFileCache);
                }
                FileUtil.delete(this.sFileCache);
                FileUtil.delete(this.sFileBackup);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void checkpoint(boolean bl) throws HsqlException {
        if (this.filesReadOnly) {
            return;
        }
        if (bl && this.cCache != null) {
            this.cCache.defrag();
        }
        this.close(false, !bl);
        this.pProperties.setDBModified(1);
        if (!bl && this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        this.openLog();
    }

    void setLogSize(int n) {
        this.pProperties.setProperty("hsqldb.log_size", n);
        this.maxLogSize = n * 1024 * 1024;
    }

    void setScriptType(int n) throws HsqlException {
        boolean bl = this.scriptFormat != n;
        this.scriptFormat = n;
        this.pProperties.setProperty("hsqldb.script_format", this.scriptFormat);
        if (bl) {
            this.checkpoint(false);
        }
    }

    void writeStatement(Session session, String string) throws HsqlException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.filesReadOnly || this.bRestoring) {
            return;
        }
        int n = session == null ? 0 : session.getId();
        try {
            this.dbLogWriter.writeLogStatement(string, n);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileLog);
        }
        if (this.maxLogSize > 0 && this.dbLogWriter.size() > (long)this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeInsertStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.filesReadOnly || this.bRestoring) {
            return;
        }
        int n = session == null ? 0 : session.getId();
        try {
            this.dbLogWriter.writeRow(n, table, objectArray);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileLog);
        }
        if (this.maxLogSize > 0 && this.dbLogWriter.size() > (long)this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.filesReadOnly || this.bRestoring) {
            return;
        }
        int n = session == null ? 0 : session.getId();
        try {
            this.dbLogWriter.writeDeleteStatement(n, table, objectArray);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileLog);
        }
        if (this.maxLogSize > 0 && this.dbLogWriter.size() > (long)this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) throws HsqlException {
        if (this.filesReadOnly || this.bRestoring) {
            return;
        }
        int n = session == null ? 0 : session.getId();
        try {
            this.dbLogWriter.writeSequenceStatement(n, numberSequence);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileLog);
        }
        if (this.maxLogSize > 0 && this.dbLogWriter.size() > (long)this.maxLogSize) {
            this.checkpoint(false);
        }
    }

    void synchLog() {
        this.dbLogWriter.sync();
    }

    void writeCommit() throws HsqlException {
        this.dbLogWriter.sync();
    }

    void shutdown() throws HsqlException {
        this.stop();
        if (this.cCache != null) {
            this.cCache.closeFile();
            this.cCache = null;
        }
        this.shutdownAllTextCaches();
        this.closeLog();
    }

    private void restoreBackup() throws HsqlException {
        try {
            if (FileUtil.exists(this.sFileCache)) {
                DataFileCache.resetFreePos(this.sFileCache);
            }
            FileUtil.delete(this.sFileCache);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ZipUnzipFile.decompressFile(this.sFileBackup, this.sFileCache);
        }
        catch (Exception exception) {
            throw Trace.error(29, 115, new Object[]{this.sFileBackup, exception.getMessage()});
        }
    }

    private void openLog() throws HsqlException {
        try {
            this.dbLogWriter = new ScriptWriterText(this.dDatabase, this.sFileLog, false, false);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            Session[] sessionArray = this.dDatabase.sessionManager.getAllSessions();
            for (int i = 0; i < sessionArray.length; ++i) {
                Session session = sessionArray[i];
                if (session.isAutoCommit()) continue;
                this.dbLogWriter.writeLogStatement(session.getAutoCommitStatement(), session.getId());
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private synchronized void closeLog() throws HsqlException {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.close();
            this.dbLogWriter = null;
        }
    }

    private void writeScript(boolean bl) throws HsqlException {
        try {
            FileUtil.delete(this.sFileScript + ".new");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ScriptWriterBase scriptWriterBase = ScriptWriterBase.newScriptWriter(this.dDatabase, this.sFileScript + ".new", bl, true, this.scriptFormat);
        scriptWriterBase.writeAll();
        scriptWriterBase.close();
    }

    DataFileCache openTextCache(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        Object object;
        this.closeTextCache(table);
        if (!this.pProperties.isPropertyTrue("textdb.allow_full_path")) {
            if (string.indexOf("..") != -1) {
                throw Trace.error(33, string);
            }
            object = new File(new File(this.sName).getAbsolutePath()).getParent();
            if (object != null) {
                string = (String)object + File.separator + string;
            }
        }
        object = bl2 ? new TextCache(string, table) : new TextCache(string, table);
        ((TextCache)object).open(bl || this.filesReadOnly);
        this.textCacheList.put(table.tableName, object);
        return object;
    }

    void closeTextCache(Table table) throws HsqlException {
        TextCache textCache = (TextCache)this.textCacheList.remove(table.tableName);
        if (textCache != null) {
            textCache.close();
        }
    }

    void closeAllTextCaches(boolean bl) throws HsqlException {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                ((TextCache)iterator.next()).purge();
                continue;
            }
            ((TextCache)iterator.next()).close();
        }
    }

    void reopenAllTextCaches() throws HsqlException {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            ((TextCache)iterator.next()).reopen();
        }
    }

    void shutdownAllTextCaches() throws HsqlException {
        Iterator iterator = this.textCacheList.values().iterator();
        while (iterator.hasNext()) {
            ((TextCache)iterator.next()).closeFile();
        }
        this.textCacheList = new HashMap();
    }

    protected class LogSyncRunner
    implements Runnable {
        private int ticks = 0;

        protected LogSyncRunner() {
        }

        public void run() {
            block3: {
                try {
                    if (++this.ticks >= Log.this.writeDelay && Log.this.dbLogWriter != null) {
                        Log.this.dbLogWriter.sync();
                        this.ticks = 0;
                    }
                }
                catch (Exception exception) {
                    if (!Trace.TRACE) break block3;
                    Trace.printSystemOut(exception.toString());
                }
            }
        }
    }
}

