#! /bin/sh

main() {

##### 初期設定 #####
# Stack内のbinディレクトリパス
STACK_BIN=bin
# 外部実行タイムアウト時間(ms)
PROCESS_TIMEOUT=600000
# ダウンロードのみ
DOWNLOAD_ONLY=false
# Stack内のANT_HOMEのパス
ANT_DIR=apache-ant-1.7.0
STACK_ANT_HOME=lib/${ANT_DIR}


##### 初期処理 #####
chmod 755 "${STACK_ANT_HOME}/bin/ant" > /dev/nul


##### 実行ユーザー権限チェック #####
sh ${STACK_BIN}/CheckAuthority.sh
if [ $? -ne 0 ]; then
	echo 実行ユーザーがrootでないため処理を続行できません。
	exit 1
fi


##### javaインストールチェック #####
sh ${STACK_BIN}/CheckInstalledJava.sh
if [ $? -ne 0 ]; then
	echo javaがインストールされていないため処理を続行できません。
	exit 1
fi


##### 起動 #####
java -DprocessTimeout=${PROCESS_TIMEOUT} -DdownloadOnly=${DOWNLOAD_ONLY} -jar openstandiainstaller.jar &

}

main $*
