package jp.ossc.installer.gui.worker;

import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

import jp.ossc.installer.gui.Setup;
import jp.ossc.installer.gui.log.LogInputStream;
import jp.ossc.installer.gui.thread.ProcessThread;

import org.jdesktop.swingworker.SwingWorker;

/**
 * _E[h  CXg[ʃXbhŏSpringWorkerNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class InstallWorker extends SwingWorker<Object, Object> {

    /**
     * OSˑȉsR[h<br>
     */
    private static final String LINE_SEPARATOR = System
            .getProperty("line.separator");

    /**
     * ĨEBhẼ^Cg<br>
     */
    private static final String doneTitle = "OpenStandiaCXg[ []";

    /**
     * {^ : <br>
     */
    private static final String FINISH_BUTTON = "";

    /**
     * G[bZ[W<br>
     */
    private static final String ERROR_MSG_UNKNOWN = "̓rňُ킪܂...";

    /**
     * xbZ[W : 𒆒fꍇ<br>
     */
    private static final String WARN_FIRE_STOP = "𒆒f܂...";

    /**
     * OsXbh<br>
     */
    private ProcessThread procThread = null;

    /**
     * [h(CXg[AACXg[AAbvf[g)<br>
     */
    private int mode;

    /**
     * et[<br>
     */
    private JFrame parent;

    /**
     * Oo̓GA<br>
     */
    private JTextArea jTextArea2;

    /**
     * io[<br>
     */
    private JProgressBar jProgressBar1;

    /**
     * `FbN{bNX\pl<br>
     */
    private JPanel jPanelCheckBox;

    /**
     * {^\pl<br>
     */
    private JPanel jPanelButton;

    /**
     * ֣{^<br>
     */
    private JButton jButtonRight;

    /**
     * OSSI<br>
     */
    private int noNum;

    /**
     * CXg[ƂɂSƉߒ(OSSI ~ 2(downloadAinstall))<br>
     */
    private int procAllNum;

    /**
     * CXg[ƂɊƉߒ<br>
     */
    private int procNum;

    /**
     * RXgN^[<br>
     * @param mode [h
     * @param parent parent
     * @param jTextArea2 jTextArea2
     * @param jProgressBar1 jProgressBar1
     * @param jPanelCheckBox jPanelCheckBox
     * @param jPanelButton jPanelButton
     * @param jButtonRight jButtonRight
     */
    public InstallWorker (int mode, JFrame parent, JTextArea jTextArea2,
            JProgressBar jProgressBar1, JPanel jPanelCheckBox,
            JPanel jPanelButton, JButton jButtonRight) {
        super();
        this.mode = mode;
        this.parent = parent;
        this.jTextArea2 = jTextArea2;
        this.jProgressBar1 = jProgressBar1;
        this.jPanelCheckBox = jPanelCheckBox;
        this.jPanelButton = jPanelButton;
        this.jButtonRight = jButtonRight;
    }

    /**
     * 񓯊ɍs鏈<br>
     * @return null
     * @see org.jdesktop.swingworker.SwingWorker#doInBackground()
     */
    @Override
    public Object doInBackground() {
        // ϐ錾
        int exitValue = 1;

        // CXg[S̑Os
        exitValue = procInstallBefore();

        // IOSSԍ(no)AƐݒt@Cԍ(sub)擾
        Map<Integer, Integer> noMap = getCheckedCompontents();

        // vOXo[\̂ɕKvȊel
        noNum = noMap.size();
        procAllNum = noNum * 2;
        procNum = 0;

        // _E[hs
        if (exitValue == 0) {
            exitValue = procDownload(noMap);
        } else {
            // Ȃ
        }

        // CXg[s
        if (exitValue == 0) {
            exitValue = procInstall(noMap);
        } else {
            // Ȃ
        }

        // n
        jProgressBar1.setValue(jProgressBar1.getMaximum());

        // CXg[Š㏈s
        if (exitValue == 0) {
            exitValue = procInstallAfter();
        } else {
            // Ȃ
        }

        // Ԃl̐ݒ
        return exitValue;
    }

    /**
     * 񓯊Ɏs<br>
     * @see org.jdesktop.swingworker.SwingWorker#done()
     */
    @Override
    protected void done() {
        // I̎dɂ菈
        final int exitValue = getExitValue();
        if (isCancelled()) {
            // f{^ɂȈꍇAȂ
        } else if (exitValue != 0) {
            // ُȈꍇAOo
            jTextArea2.append(ERROR_MSG_UNKNOWN);
            jTextArea2.append(LINE_SEPARATOR);
        } else {
            // ȈꍇAȂ
        }

        // J[\ɂǂ
        Cursor defaultCursol = Cursor
                .getPredefinedCursor(Cursor.DEFAULT_CURSOR);
        parent.setCursor(defaultCursol);

        // {^gpɂ
        jButtonRight.setText(FINISH_BUTTON);
        jButtonRight.setEnabled(true);

        // ^Cgɂ
        parent.setTitle(doneTitle);
    }

    /**
     * IR[h擾<br>
     * @return IR[h
     */
    private int getExitValue() {
        int exitValue = 1;
        try {
            exitValue = (Integer) get();
        } catch (Exception e) {
            // Ȃ
        }
        return exitValue;
    }

    /**
     * OSSIʂŃ`FbNR|[lg̑gݍ킹擾<br>
     * key : OSSԍ(no)<br>
     * value : LOSS̐ݒt@Cԍ(sub)<br>
     *  ݒt@Cԍ́Aw肳ĂȂAIȂꍇ́A-1i[<br>
     * @return
     */
    private Map<Integer, Integer> getCheckedCompontents() {
        Component[] components2 = jPanelCheckBox.getComponents();
        Map<Integer, Integer> noMap = new TreeMap<Integer, Integer>(); // no, sub
        for (int i = 0; i < components2.length; i++) {
            if (components2[i] instanceof JCheckBox) {
                // OSSԍ(no)̎擾(`FbN{bNX)
                if (((JCheckBox) components2[i]).isSelected()) {
                    final String noStr = ((JCheckBox) components2[i])
                            .getName();
                    final int no = Integer.parseInt(noStr);
                    noMap.put(no, -1);
                } else {
                    // Ȃ
                }
            } else if (components2[i] instanceof JPanel) {
                // OSS̐ݒt@Cԍ(sub)̎擾(WI{^)
                final JPanel panel = (JPanel) components2[i];
                Component[] childComponents = panel.getComponents();
                for (int j = 0; j < childComponents.length; j++) {
                    if (childComponents[j] instanceof JRadioButton) {
                        if (((JRadioButton) childComponents[j]).isSelected()) {
                            final String noStr = panel.getName();
                            final String subStr = ((JRadioButton) childComponents[j])
                                    .getName();
                            final int no = Integer.parseInt(noStr);
                            final int sub = Integer.parseInt(subStr);
                            Integer value = noMap.get(no);
                            if (value != null) {
                                noMap.put(no, sub);
                            }
                        } else {
                            // Ȃ
                        }
                    } else {
                        // Ȃ
                    }
                }
            } else {
                // Ȃ
            }
        }
        return noMap;
    }

    /**
     * CXg[S̑O<br>
     * @param noMap OSSI
     * @return IR[h
     */
    private int procInstallBefore() {
        return procMain(Setup.TYPE_INSTALL_BEFORE, -1, -1, null);
    }

    /**
     * IꂽOSSƂOSS_E[h<br>
     * @param noMap OSSI
     * @return IR[h
     */
    private int procDownload(final Map<Integer, Integer> noMap) {
        return proc(noMap, Setup.TYPE_DOWNLOAD);
    }

    /**
     * IꂽOSSƂOSSCXg[<br>
     * @param noMap OSSI
     * @return IR[h
     */
    private int procInstall(final Map<Integer, Integer> noMap) {
        return proc(noMap, Setup.TYPE_INSTALL);
    }

    /**
     * CXg[Š㏈<br>
     * @param noMap OSSI
     * @return IR[h
     */
    private int procInstallAfter() {
        return procMain(Setup.TYPE_INSTALL_AFTER, -1, -1, null);
    }

    /**
     * IꂽOSSƂAntɎ߂<br>
     * @param noMap OSSI
     * @param type 
     * @return IR[h
     */
    private int proc(final Map<Integer, Integer> noMap, final int type) {
        int exitValue = 1;
        final String installedNo = getInstalledNo(noMap);
        for (Iterator it = noMap.entrySet().iterator(); it.hasNext();) {
            Map.Entry entry = (Map.Entry) it.next();
            final int no = (Integer) entry.getKey();
            final int sub = (Integer) entry.getValue();
            exitValue = procMain(type, no, sub, installedNo);
            if (exitValue == 0) {
                procNum++;
                jProgressBar1.setValue((100 / procAllNum) * procNum);
                jPanelButton.validate();
            } else {
                break;
            }
        }
        return exitValue;
    }

    /**
     * AntɎ߂<br>
     * @param type 
     * @param no OSSԍ
     * @param sub OSSݒt@Cԍ
     * @param installedNo ɃCXg[OSSԍ(J}؂)
     * @return IR[h
     */
    private int procMain(final int type, final int no, final int sub,
            final String installedNo) {
        LogInputStream logInputStream = null;
        LogInputStream errorInputStream = null;
        int exitValue = 1;
        try {
            // ʂɂ菈
            if (type == Setup.TYPE_INSTALL_BEFORE) {
                procThread = Setup.execInstallBefore(mode);
            } else if (type == Setup.TYPE_INSTALL) {
                procThread = Setup.execInstall(no, sub, mode, installedNo);
            } else if (type == Setup.TYPE_DOWNLOAD) {
                procThread = Setup.execDownload(no);
            } else if (type == Setup.TYPE_INSTALL_AFTER) {
                procThread = Setup.execInstallAfter(mode);
            } else {
                // Ȃ
            }
            if (procThread == null) {
                // Ȃ
            } else {
                logInputStream = procThread.getLogInputStream();
                String line = null;
                while ((line = logInputStream.readLine()) != null) {
                    jTextArea2.append(line);
                    jTextArea2.append(LINE_SEPARATOR);
                    final int length = jTextArea2.getText().length();
                    jTextArea2.setCaretPosition(length);
                    jTextArea2.validate();
                }
                exitValue = procThread.getExitValue();
                if (exitValue != 0) {
                    errorInputStream = procThread.getErrorInputStream();
                    while ((line = errorInputStream.readLine()) != null) {
                        jTextArea2.append(line);
                        jTextArea2.append(LINE_SEPARATOR);
                        final int length = jTextArea2.getText().length();
                        jTextArea2.setCaretPosition(length);
                        jTextArea2.validate();
                    }
                } else {
                    // Ȃ
                }
            }

            // Ԃl̐ݒ
            return exitValue;
        } catch (IOException ie) {
            throw new RuntimeException(ie);
        } catch (InterruptedException ine) {
            throw new RuntimeException(ine);
        } finally {
            try {
                logInputStream.close();
            } catch (Exception e) {
                // Ȃ
            }
            try {
                errorInputStream.close();
            } catch (Exception e) {
                // Ȃ
            }
        }
    }

    /**
     * ɃCXg[OSSԍJ}؂ƂĎ擾<br>
     * @param noMap OSSI
     * @return ɃCXg[OSSԍ
     */
    private String getInstalledNo(final Map<Integer, Integer> noMap) {
        String installedNo = null;
        for (Iterator it = noMap.entrySet().iterator(); it.hasNext();) {
            Map.Entry entry = (Map.Entry) it.next();
            final int no = (Integer) entry.getKey();
            if (installedNo == null) {
                installedNo = Integer.toString(no);
            } else {
                installedNo = installedNo + "," + no;
            }
        }
        return installedNo;
    }

    /**
     * ʃXbhɂ鏈O菈̒fɎ݂<br>
     */
    public void cancel() {
        LogInputStream logInputStream = procThread.getLogInputStream();
        if (logInputStream != null && !logInputStream.isClosed()) {
            logInputStream.append(WARN_FIRE_STOP);
        } else {
            // Ȃ
        }
        procThread.interrupt();
        super.cancel(true);
    }

}
