/*
 * OpenStandiaFrame.java
 *
 * Created on 2007/10/04, 14:24
 */

package jp.ossc.installer.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;

import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

import jp.ossc.installer.gui.file.InputFile;
import jp.ossc.installer.gui.worker.InstallWorker;
import jp.ossc.tools.ant.taskdefs.ExtendsXmlProperty;

import org.apache.tools.ant.Project;

/**
 * OpenStandia GUICXg[[SNXłB<br>
 * @author  h2-matsuno
 * @version 1.0
 * @since 1.0
 */
public class TopFrame extends javax.swing.JFrame {

    /**
     * {^ : ֣<br>
     */
    private static final String NEXT_BUTTON = " ";

    /**
     * {^ : ߂<br>
     */
    private static final String BACK_BUTTON = " ߂";

    /**
     * {^ : f<br>
     */
    private static final String CANCEL_BUTTON = "f";

    /**
     * VAID<br>
     */
    private static final long serialVersionUID = 1L;

    /** Creates new form OpenStandiaFrame */
    public TopFrame () {
        initComponents();
        setLocationRelativeTo(null);
        mediator = new WizardMediator(this);
        mediator.init();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanelSelectStack = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jPanelLicense = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextArea3 = new javax.swing.JTextArea();
        jRadioLicenseOk = new javax.swing.JRadioButton();
        jRadioLicenseNg = new javax.swing.JRadioButton();
        jPanelConfirm = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jPanelResult = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea2 = new javax.swing.JTextArea();
        jPanelCheckBox = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        jPanelInCheckBox = new javax.swing.JPanel();
        buttonGroupMode = new javax.swing.ButtonGroup();
        buttonGroupLicense = new javax.swing.ButtonGroup();
        jPanelDescription = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabelName = new javax.swing.JLabel();
        jLabelDesc = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabelVersion = new javax.swing.JLabel();
        jLabelLogo = new javax.swing.JLabel();
        jPanelMessage = new javax.swing.JPanel();
        jPanelButton = new javax.swing.JPanel();
        jButtonLeft = new javax.swing.JButton();
        jButtonRight = new javax.swing.JButton();
        jProgressBar1 = new javax.swing.JProgressBar();
        jRadioInstall = new javax.swing.JRadioButton();
        jRadioUninstall = new javax.swing.JRadioButton();
        jRadioUpdate = new javax.swing.JRadioButton();
        jMenuBar2 = new javax.swing.JMenuBar();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();

        jLabel3
                .setText("\u30e1\u30cb\u30e5\u30fc\u306e\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u3088\u308a\u30b9\u30bf\u30c3\u30af\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");

        org.jdesktop.layout.GroupLayout jPanelSelectStackLayout = new org.jdesktop.layout.GroupLayout(
            jPanelSelectStack);
        jPanelSelectStack.setLayout(jPanelSelectStackLayout);
        jPanelSelectStackLayout.setHorizontalGroup(jPanelSelectStackLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelSelectStackLayout.createSequentialGroup()
                            .addContainerGap().add(
                                jLabel3,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                374, Short.MAX_VALUE).addContainerGap()));
        jPanelSelectStackLayout.setVerticalGroup(jPanelSelectStackLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelSelectStackLayout.createSequentialGroup()
                            .addContainerGap().add(jLabel3).addContainerGap(
                                281, Short.MAX_VALUE)));
        jPanelLicense.setBorder(javax.swing.BorderFactory.createTitledBorder(
            null, "\u30e9\u30a4\u30bb\u30f3\u30b9",
            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
            javax.swing.border.TitledBorder.DEFAULT_POSITION,
            new java.awt.Font("MS UI Gothic", 1, 12)));
        jTextArea3.setColumns(20);
        jTextArea3.setEditable(false);
        jTextArea3.setRows(5);
        jScrollPane3.setViewportView(jTextArea3);

        buttonGroupLicense.add(jRadioLicenseOk);
        jRadioLicenseOk.setText("\u540c\u610f\u3059\u308b");
        jRadioLicenseOk.setBorder(javax.swing.BorderFactory
                .createEmptyBorder(0, 0, 0, 0));
        jRadioLicenseOk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioLicenseOk
                .addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        jRadioLicenseOkActionPerformed(evt);
                    }
                });

        buttonGroupLicense.add(jRadioLicenseNg);
        jRadioLicenseNg.setSelected(true);
        jRadioLicenseNg.setText("\u540c\u610f\u3057\u306a\u3044");
        jRadioLicenseNg.setBorder(javax.swing.BorderFactory
                .createEmptyBorder(0, 0, 0, 0));
        jRadioLicenseNg.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioLicenseNg
                .addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        jRadioLicenseNgActionPerformed(evt);
                    }
                });

        org.jdesktop.layout.GroupLayout jPanelLicenseLayout = new org.jdesktop.layout.GroupLayout(
            jPanelLicense);
        jPanelLicense.setLayout(jPanelLicenseLayout);
        jPanelLicenseLayout
                .setHorizontalGroup(jPanelLicenseLayout
                        .createParallelGroup(
                            org.jdesktop.layout.GroupLayout.LEADING)
                        .add(
                            org.jdesktop.layout.GroupLayout.TRAILING,
                            jPanelLicenseLayout
                                    .createSequentialGroup()
                                    .addContainerGap()
                                    .add(
                                        jPanelLicenseLayout
                                                .createParallelGroup(
                                                    org.jdesktop.layout.GroupLayout.TRAILING)
                                                .add(
                                                    jScrollPane3,
                                                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                    344, Short.MAX_VALUE)
                                                .add(
                                                    jPanelLicenseLayout
                                                            .createSequentialGroup()
                                                            .add(
                                                                jRadioLicenseOk)
                                                            .addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED)
                                                            .add(
                                                                jRadioLicenseNg)
                                                            .addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED)))
                                    .addContainerGap()));
        jPanelLicenseLayout.setVerticalGroup(jPanelLicenseLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    org.jdesktop.layout.GroupLayout.TRAILING,
                    jPanelLicenseLayout.createSequentialGroup().add(
                        jScrollPane3,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 270,
                        Short.MAX_VALUE).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        jPanelLicenseLayout.createParallelGroup(
                            org.jdesktop.layout.GroupLayout.BASELINE).add(
                            jRadioLicenseOk).add(jRadioLicenseNg))));
        jPanelConfirm.setBorder(javax.swing.BorderFactory.createTitledBorder(
            null, "\u30d7\u30ed\u30c0\u30af\u30c8\u306e\u78ba\u8a8d",
            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
            javax.swing.border.TitledBorder.DEFAULT_POSITION,
            new java.awt.Font("MS UI Gothic", 1, 12)));
        jPanelConfirm.getAccessibleContext().setAccessibleDescription("");
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        org.jdesktop.layout.GroupLayout jPanelConfirmLayout = new org.jdesktop.layout.GroupLayout(
            jPanelConfirm);
        jPanelConfirm.setLayout(jPanelConfirmLayout);
        jPanelConfirmLayout.setHorizontalGroup(jPanelConfirmLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelConfirmLayout.createSequentialGroup()
                            .addContainerGap().add(
                                jScrollPane1,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                340, Short.MAX_VALUE).addContainerGap()));
        jPanelConfirmLayout.setVerticalGroup(jPanelConfirmLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelConfirmLayout.createSequentialGroup().add(
                        jScrollPane1,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 224,
                        Short.MAX_VALUE).addContainerGap()));
        jPanelResult.setBorder(javax.swing.BorderFactory.createTitledBorder(
            null, "\u5b9f\u884c\u30ed\u30b0",
            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
            javax.swing.border.TitledBorder.DEFAULT_POSITION,
            new java.awt.Font("MS UI Gothic", 1, 12)));
        jTextArea2.setColumns(20);
        jTextArea2.setEditable(false);
        jTextArea2.setRows(5);
        jScrollPane2.setViewportView(jTextArea2);

        org.jdesktop.layout.GroupLayout jPanelResultLayout = new org.jdesktop.layout.GroupLayout(
            jPanelResult);
        jPanelResult.setLayout(jPanelResultLayout);
        jPanelResultLayout.setHorizontalGroup(jPanelResultLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelResultLayout.createSequentialGroup()
                            .addContainerGap().add(
                                jScrollPane2,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                344, Short.MAX_VALUE).addContainerGap()));
        jPanelResultLayout.setVerticalGroup(jPanelResultLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jPanelResultLayout.createSequentialGroup().add(
                        jScrollPane2,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 226,
                        Short.MAX_VALUE).addContainerGap()));
        jScrollPane4
                .setBorder(javax.swing.BorderFactory
                        .createTitledBorder("\u30d7\u30ed\u30c0\u30af\u30c8\u306e\u9078\u629e"));
        org.jdesktop.layout.GroupLayout jPanelInCheckBoxLayout = new org.jdesktop.layout.GroupLayout(
            jPanelInCheckBox);
        jPanelInCheckBox.setLayout(jPanelInCheckBoxLayout);
        jPanelInCheckBoxLayout.setHorizontalGroup(jPanelInCheckBoxLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 208, Short.MAX_VALUE));
        jPanelInCheckBoxLayout.setVerticalGroup(jPanelInCheckBoxLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 127, Short.MAX_VALUE));
        jScrollPane4.setViewportView(jPanelInCheckBox);

        org.jdesktop.layout.GroupLayout jPanelCheckBoxLayout = new org.jdesktop.layout.GroupLayout(
            jPanelCheckBox);
        jPanelCheckBox.setLayout(jPanelCheckBoxLayout);
        jPanelCheckBoxLayout.setHorizontalGroup(jPanelCheckBoxLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    jScrollPane4,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 220,
                    Short.MAX_VALUE));
        jPanelCheckBoxLayout.setVerticalGroup(jPanelCheckBoxLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(
                    org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane4,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 152,
                    Short.MAX_VALUE));

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("OpenStandia\u30a4\u30f3\u30b9\u30c8\u30fc\u30e9 [\u30d7\u30ed\u30c0\u30af\u30c8\u9078\u629e]");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        jPanelDescription.setBorder(javax.swing.BorderFactory
                .createTitledBorder(
                    null, "\u30b9\u30bf\u30c3\u30af\u6982\u8981",
                    javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                    javax.swing.border.TitledBorder.DEFAULT_POSITION,
                    new java.awt.Font("MS UI Gothic", 1, 12)));
        jLabel1.setText("\u540d\u524d:");

        jLabel2.setText("\u8aac\u660e:");

        jLabel5.setText("\u30d0\u30fc\u30b8\u30e7\u30f3");

        org.jdesktop.layout.GroupLayout jPanelDescriptionLayout = new org.jdesktop.layout.GroupLayout(
            jPanelDescription);
        jPanelDescription.setLayout(jPanelDescriptionLayout);
        jPanelDescriptionLayout
                .setHorizontalGroup(jPanelDescriptionLayout
                        .createParallelGroup(
                            org.jdesktop.layout.GroupLayout.LEADING)
                        .add(
                            jPanelDescriptionLayout
                                    .createSequentialGroup()
                                    .addContainerGap()
                                    .add(
                                        jPanelDescriptionLayout
                                                .createParallelGroup(
                                                    org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(
                                                    org.jdesktop.layout.GroupLayout.TRAILING,
                                                    jLabel1)
                                                .add(
                                                    org.jdesktop.layout.GroupLayout.TRAILING,
                                                    jLabel5)
                                                .add(
                                                    org.jdesktop.layout.GroupLayout.TRAILING,
                                                    jLabel2))
                                    .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(
                                        jPanelDescriptionLayout
                                                .createParallelGroup(
                                                    org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(jLabelName).add(
                                                    jLabelDesc).add(
                                                    jLabelVersion))
                                    .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED,
                                        204, Short.MAX_VALUE)
                                    .add(
                                        jLabelLogo,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                        153,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .addContainerGap()));
        jPanelDescriptionLayout
                .setVerticalGroup(jPanelDescriptionLayout
                        .createParallelGroup(
                            org.jdesktop.layout.GroupLayout.LEADING)
                        .add(
                            jPanelDescriptionLayout
                                    .createSequentialGroup()
                                    .add(
                                        jPanelDescriptionLayout
                                                .createParallelGroup(
                                                    org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(
                                                    jPanelDescriptionLayout
                                                            .createSequentialGroup()
                                                            .addContainerGap()
                                                            .add(
                                                                jPanelDescriptionLayout
                                                                        .createParallelGroup(
                                                                            org.jdesktop.layout.GroupLayout.BASELINE)
                                                                        .add(
                                                                            jLabel1)
                                                                        .add(
                                                                            jLabelName))
                                                            .addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED)
                                                            .add(
                                                                jPanelDescriptionLayout
                                                                        .createParallelGroup(
                                                                            org.jdesktop.layout.GroupLayout.BASELINE)
                                                                        .add(
                                                                            jLabel5)
                                                                        .add(
                                                                            jLabelVersion))
                                                            .addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED)
                                                            .add(
                                                                jPanelDescriptionLayout
                                                                        .createParallelGroup(
                                                                            org.jdesktop.layout.GroupLayout.BASELINE)
                                                                        .add(
                                                                            jLabel2)
                                                                        .add(
                                                                            jLabelDesc)))
                                                .add(
                                                    jLabelLogo,
                                                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                    64, Short.MAX_VALUE))
                                    .addContainerGap()));

        org.jdesktop.layout.GroupLayout jPanelMessageLayout = new org.jdesktop.layout.GroupLayout(
            jPanelMessage);
        jPanelMessage.setLayout(jPanelMessageLayout);
        jPanelMessageLayout.setHorizontalGroup(jPanelMessageLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 444, Short.MAX_VALUE));
        jPanelMessageLayout.setVerticalGroup(jPanelMessageLayout
                .createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(0, 362, Short.MAX_VALUE));

        jButtonLeft.setText("\uff1c \u623b\u308b");
        jButtonLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLeftActionPerformed(evt);
            }
        });

        jButtonRight.setText("\u6b21\u3078 \uff1e");
        jButtonRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRightActionPerformed(evt);
            }
        });

        jProgressBar1.setForeground(new java.awt.Color(0, 0, 102));

        org.jdesktop.layout.GroupLayout jPanelButtonLayout = new org.jdesktop.layout.GroupLayout(
            jPanelButton);
        jPanelButton.setLayout(jPanelButtonLayout);
        jPanelButtonLayout
                .setHorizontalGroup(jPanelButtonLayout
                        .createParallelGroup(
                            org.jdesktop.layout.GroupLayout.LEADING)
                        .add(
                            org.jdesktop.layout.GroupLayout.TRAILING,
                            jPanelButtonLayout
                                    .createSequentialGroup()
                                    .addContainerGap()
                                    .add(
                                        jProgressBar1,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                        252,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED,
                                        15, Short.MAX_VALUE)
                                    .add(jButtonLeft)
                                    .addPreferredGap(
                                        org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(jButtonRight).addContainerGap()));

        jPanelButtonLayout.linkSize(
            new java.awt.Component[] {jButtonLeft, jButtonRight },
            org.jdesktop.layout.GroupLayout.HORIZONTAL);

        jPanelButtonLayout
                .setVerticalGroup(jPanelButtonLayout
                        .createParallelGroup(
                            org.jdesktop.layout.GroupLayout.LEADING)
                        .add(
                            jPanelButtonLayout
                                    .createSequentialGroup()
                                    .addContainerGap()
                                    .add(
                                        jPanelButtonLayout
                                                .createParallelGroup(
                                                    org.jdesktop.layout.GroupLayout.LEADING)
                                                .add(
                                                    jProgressBar1,
                                                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                    org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                .add(
                                                    jPanelButtonLayout
                                                            .createParallelGroup(
                                                                org.jdesktop.layout.GroupLayout.BASELINE)
                                                            .add(jButtonRight)
                                                            .add(jButtonLeft)))
                                    .addContainerGap(
                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                        Short.MAX_VALUE)));

        buttonGroupMode.add(jRadioInstall);
        jRadioInstall.setSelected(true);
        jRadioInstall.setText("\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb");
        jRadioInstall.setBorder(javax.swing.BorderFactory.createEmptyBorder(
            0, 0, 0, 0));
        jRadioInstall.setMargin(new java.awt.Insets(0, 0, 0, 0));

        buttonGroupMode.add(jRadioUninstall);
        jRadioUninstall
                .setText("\u30a2\u30f3\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb");
        jRadioUninstall.setBorder(javax.swing.BorderFactory
                .createEmptyBorder(0, 0, 0, 0));
        jRadioUninstall.setMargin(new java.awt.Insets(0, 0, 0, 0));

        buttonGroupMode.add(jRadioUpdate);
        jRadioUpdate.setText("\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8");
        jRadioUpdate.setBorder(javax.swing.BorderFactory.createEmptyBorder(
            0, 0, 0, 0));
        jRadioUpdate.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jMenu2.setText("\u30d5\u30a1\u30a4\u30eb");
        jMenuItem1.setText("\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });

        jMenu2.add(jMenuItem1);

        jMenuItem2.setText("\u7d42\u4e86");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });

        jMenu2.add(jMenuItem2);

        jMenuBar2.add(jMenu2);

        setJMenuBar(jMenuBar2);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
            getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(
            org.jdesktop.layout.GroupLayout.LEADING).add(
            layout.createSequentialGroup().addContainerGap().add(
                layout.createParallelGroup(
                    org.jdesktop.layout.GroupLayout.LEADING).add(
                    layout.createSequentialGroup().add(10, 10, 10).add(
                        jRadioInstall).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        jRadioUninstall).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        jRadioUpdate)).add(
                    org.jdesktop.layout.GroupLayout.TRAILING, jPanelMessage,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    Short.MAX_VALUE).add(
                    jPanelButton,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    Short.MAX_VALUE).add(
                    jPanelDescription,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(
            org.jdesktop.layout.GroupLayout.LEADING).add(
            layout.createSequentialGroup().addContainerGap().add(
                jPanelDescription,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(
                        layout.createParallelGroup(
                            org.jdesktop.layout.GroupLayout.BASELINE).add(
                            jRadioInstall).add(jRadioUninstall).add(
                            jRadioUpdate)).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        jPanelMessage,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        Short.MAX_VALUE).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        jPanelButton,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap()));
        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * ӂ{^ANVCxg<br>
     * @param evt ActionEvent
     */
    private void jRadioLicenseNgActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioLicenseNgActionPerformed
        mediator.updateButtonPanel();
    }//GEN-LAST:event_jRadioLicenseNgActionPerformed

    /**
     * ӂȂ{^ANVCxg<br>
     * @param evt ActionEvent
     */
    private void jRadioLicenseOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioLicenseOkActionPerformed
        mediator.updateButtonPanel();
    }//GEN-LAST:event_jRadioLicenseOkActionPerformed

    /**
     *  E(ɐi)̃{^NbNꂽƂ̃CxgB
     *  JڏNX(WizardMediator)ɏϏ
     **/
    private void jButtonRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRightActionPerformed
        if (jButtonRight.getText().equals(CANCEL_BUTTON)) {
            mediator.stop();
        } else {
            mediator.next();
        }
    }//GEN-LAST:event_jButtonRightActionPerformed

    /**
     *  (ɖ߂)̃{^NbNꂽƂ̃CxgB
     *  JڏNX(WizardMediator)ɏϏ
     **/
    private void jButtonLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLeftActionPerformed
        mediator.back();
    }//GEN-LAST:event_jButtonLeftActionPerformed

    /**
     *  j[́uIvNbNꂽƂ̃CxgB
     **/
    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
        mediator.cancel();
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    /**
     *  j[́uǂݍ݁vNbNꂽƂ̃CxgB
     *  IꂽXMLt@C(X^bNݒt@C)ǂݍŁA
     *  \؂ւB
     **/
    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        // t@C_CAO̕\
        final String startupDir = System.getProperty("user.dir");
        JFileChooser fileChooser = new JFileChooser(startupDir);
        FileFilter filters[] = {new FileFilter() {
            public boolean accept(File f) {
                return f.getName().endsWith(".xml") || f.isDirectory();
            }

            public String getDescription() {
                return "XMLt@C (*.xml)";
            }
        } };
        for (int i = 0; i < filters.length; i++) {
            fileChooser.addChoosableFileFilter(filters[i]);
        }

        // LZ{^ꂽꍇ͏I
        final int returnValue = fileChooser.showOpenDialog(this);
        if (returnValue == JFileChooser.CANCEL_OPTION) {
            return;
        }
        // t@C̓ǂݍ
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        final String stackBaseDir = selectedFile.getParentFile()
                .getAbsolutePath();
        final String stackXmlFileName = selectedFile.getName();
        System.setProperty("user.dir", stackBaseDir);
        System.setProperty("user.stackxmlfile.name", stackXmlFileName);

        try {

            // X^bNݒt@C(stack.xml)Antgpēǂݍ
            Map<String, String> stackXmlProperties = getStackXmlProperties(selectedFile);

            final String stackName = stackXmlProperties
                    .get("stack.application.name");
            final String stackVersion = stackXmlProperties
                    .get("stack.application.ver");
            final String stackDescription = stackXmlProperties
                    .get("stack.application.description");
            final String stackLogo = stackXmlProperties
                    .get("stack.application.logo");
            final String stackLicense = stackXmlProperties
                    .get("stack.license.file");
            jLabelName.setText(stackName);
            jLabelVersion.setText(stackVersion);
            jLabelDesc.setText(stackDescription);
            if (stackLogo != null) {
                Icon icon = new ImageIcon(stackBaseDir + "/" + stackLogo);
                jLabelLogo.setIcon(icon);
                jLabelLogo.validate();
            } else {
                // Ȃ
            }
            jTextArea3.setText("");
            if (stackLicense != null) {
                InputFile license = new InputFile(stackBaseDir + "/"
                                                  + stackLicense);
                final StringBuilder licenseBuf = license.get();
                jTextArea3.setVisible(true);
                jTextArea3.append(licenseBuf.toString());
                jTextArea3.setCaretPosition(0);
                jTextArea3.validate();
                jRadioLicenseNg.setSelected(true);
            } else {
                jTextArea3.setVisible(false);
                jRadioLicenseOk.setSelected(true);
            }

            // v_Ng擾
            final int productsNum = Integer.parseInt(stackXmlProperties
                    .get("stack.products.product.num"));
            jPanelInCheckBox.removeAll();
            jPanelInCheckBox.setLayout(new BoxLayout(
                jPanelInCheckBox, BoxLayout.Y_AXIS));

            // v_Ngݒ萔JԂ
            for (int i = 0; i < productsNum; i++) {
                final String product = "stack.products.product." + (i + 1);
                final String productDef = stackXmlProperties.get(product
                                                                 + ".def");
                // v_Ngݒt@C(product.xml)Antgpēǂݍ
                File productXml = new File(stackBaseDir + "/" + productDef);
                if (!productXml.exists()) {
                    System.out.println(productXml.getAbsolutePath()
                                       + "́A݂܂B");
                    continue;
                } else {
                    // Ȃ
                }
                Map<String, String> productXmlProperties = getProductXmlProperties(productXml);

                final String os = productXmlProperties.get("product.os")
                        .toLowerCase();
                final String systemOsName = System.getProperty("os.name")
                        .toLowerCase();
                if (isViewProduct(systemOsName, os)) {
                    final String productName = productXmlProperties
                            .get("product.name");
                    final String productVer = " Ver."
                                              + productXmlProperties
                                                      .get("product.ver");
                    final String productDescription = productXmlProperties
                            .get("product.description");
                    final String productLabel = createProductLabel(
                        os, productName, productVer);
                    JCheckBox checkBoxProduct = new JCheckBox();
                    checkBoxProduct.setName(Integer.toString(i + 1));
                    checkBoxProduct.setText(productLabel);
                    checkBoxProduct.setToolTipText(productDescription);
                    checkBoxProduct.setAlignmentX(JComponent.LEFT_ALIGNMENT);
                    jPanelInCheckBox.add(checkBoxProduct);

                    // ݒt@CIWI{^𐶐
                    final String configNumStr = productXmlProperties
                            .get("product.config.pattern.num");
                    if (configNumStr != null) {
                        final int configNum = Integer.parseInt(configNumStr);
                        ButtonGroup confGroup = new ButtonGroup();
                        for (int j = 0; j < configNum; j++) {
                            final String configPattern = "product.config.pattern."
                                                         + (j + 1);
                            final String pattern = productXmlProperties
                                    .get(configPattern);
                            final String sub = productXmlProperties
                                    .get(configPattern + ".sub");
                            JRadioButton radioConf = new JRadioButton();
                            radioConf.setName(sub);
                            radioConf.setText(pattern);
                            radioConf
                                    .setAlignmentX(JComponent.LEFT_ALIGNMENT);
                            confGroup.add(radioConf);

                            JPanel panel = new JPanel();
                            panel.setName(Integer.toString(i + 1));
                            panel.setLayout(new BoxLayout(
                                panel, BoxLayout.X_AXIS));
                            panel.setAlignmentX(JComponent.LEFT_ALIGNMENT);
                            panel.add(Box
                                    .createRigidArea(new Dimension(20, 0)));
                            panel.add(radioConf);
                            jPanelInCheckBox.add(panel);

                            // 1ڂ̏ꍇ́AIƂ
                            if (confGroup.getButtonCount() == 1) {
                                confGroup.setSelected(
                                    radioConf.getModel(), true);
                            } else {
                                // Ȃ
                            }
                        }
                    } else {
                        // Ȃ
                    }
                } else {
                    // Ȃ
                }
            }
            jButtonRight.doClick();
            mediator.updateButtonPanel();
            jPanelInCheckBox.validate();
        } catch (Exception ex) {
            throw new RuntimeException(
                "XMLt@C̓ǂݍ݂Ɏs܂B[" + selectedFile.getAbsolutePath()
                        + "]", ex);
        }
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    /**
     * v_NgIʂɃv_Ng\邩ǂ<br>
     * @param systemOsName OS
     * @param productOsName v_Ng̑ΏOS
     * @return true : \ / false : \
     */
    private boolean isViewProduct(final String systemOsName,
            final String productOsName) {
        boolean viewProduct = false;
        final boolean downloadOnly = Boolean.valueOf(System
                .getProperty("downloadOnly"));
        if (downloadOnly) {
            viewProduct = true;
        } else if (systemOsName.startsWith(productOsName)) {
            viewProduct = true;
        } else {
            viewProduct = false;
        }
        return viewProduct;
    }

    /**
     * v_NgIʂɕ\p̃v_Ng(x)𐶐<br>
     * @param osName v_Ng삷OS
     * @param productName v_Ng
     * @param productVer v_Ng̃o[W
     * @return \p̃v_Ng(x)
     */
    private String createProductLabel(final String osName,
            final String productName, final String productVer) {
        String productLabel = productName + productVer;
        final boolean downloadOnly = Boolean.valueOf(System
                .getProperty("downloadOnly"));
        if (downloadOnly) {
            productLabel = productLabel + " (" + osName + ")";
        } else {
            // Ȃ
        }
        return productLabel;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TopFrame().setVisible(true);
            }
        });
    }

    /**
     *  ϏꂽsNXB
     *  ʂ̐؂ւAʑJڂł̏sB
     *  z肵ĂʑJڂ́A
     *    0. X^bN`t@CI
     *    1. CZX
     *    2. v_NgI
     *    3. v_NgImF
     *    4. xxx ( CXg[)
     *  łB
     */
    public class WizardMediator {

        /**
         * EBhẼ^Cgz
         */
        private final String titles[] = {"OpenStandiaCXg[ [X^bN`t@CI]",
                                         "OpenStandiaCXg[ [CZX]",
                                         "OpenStandiaCXg[ [v_NgI]",
                                         "OpenStandiaCXg[ [v_NgmF]",
                                         "OpenStandiaCXg[ [%s]" };

        /**
         * y[WID : X^bN`t@CI<br>
         */
        private static final int PAGE_SELECT_STACK = 0;

        /**
         * y[WID : CZX<br>
         */
        private static final int PAGE_LICENSE = 1;

        /**
         * y[WID : v_NgI<br>
         */
        private static final int PAGE_SELECT_PRODUCT = 2;

        /**
         * y[WID : v_NgmF<br>
         */
        private static final int PAGE_CONFIRM_PRODUCT = 3;

        /**
         * y[WID : xxx<br>
         */
        private static final int PAGE_EXECUTE = 4;

        /**
         * 񃁃bZ[W{bNX̃^Cg<br>
         */
        private static final String MSG_INFO_TITLE = "mF";

        /**
         * 񃁃bZ[W : v_Ng1IĂȂꍇ<br>
         */
        private static final String MSG_INFO_NOT_SELECTED_ANY_PRODUCTS = "%sv_Ng1ȏIĂB";

        /**
         * EBU[h̊Jny[Wԍ
         */
        private final int startPageId = PAGE_SELECT_STACK;

        /**
         * EBU[h̏Iy[Wԍ
         */
        private final int endPageId = PAGE_EXECUTE;

        /**
         * EBU[hŌݕ\Ăy[Wԍ
         */
        private int currentPageId;

        /**
         * ʒ̃plɐݒ肷郌CAEg
         */
        private CardLayout cardLayout = new CardLayout();

        /**
         * t[<br>
         */
        private JFrame parent;

        /**
         * ʃXbhŃ_E[hCXg[܂ŏCX^X<br>
         */
        private InstallWorker installWorker;

        /**
         * RXgN^[<br>
         * @param parent JFrame
         */
        public WizardMediator (JFrame parent) {
            this.parent = parent;
        }

        /**
         *  ʑJڏNX̏B
         *  - ݂̃y[Wԍ̐ݒ
         *  - ʒ̃pl̐ݒ
         *  - {^pl̏\
         *  sB
         */
        public void init() {
            currentPageId = 0;
            jPanelMessage.setLayout(cardLayout);
            jPanelMessage.add("0", jPanelSelectStack);
            jPanelMessage.add("1", jPanelLicense);
            jPanelMessage.add("2", jPanelCheckBox);
            jPanelMessage.add("3", jPanelConfirm);
            jPanelMessage.add("4", jPanelResult);
            updateButtonPanel();
        }

        /**
         * ݂̃y[Wŕ\ׂ^Cgԋp
         */
        private String getTitle() {
            // [h擾
            final String modeText = getModeText();
            final String title = String.format(
                titles[currentPageId], modeText);
            return title;
        }

        /**
         * ꂩ̃v_NgIĂ邩ǂ<br>
         * @return true :  / false : Ȃ
         */
        private boolean isSelectedAnyProducts() {
            boolean selected = false;
            final Component[] components = jPanelInCheckBox.getComponents();
            for (int i = 0; i < components.length; i++) {
                if (components[i] instanceof JCheckBox) {
                    // OSSԍ(no)(`FbN{bNX)IĂ邩ǂ
                    if (((JCheckBox) components[i]).isSelected()) {
                        selected = true;
                        break;
                    } else {
                        // Ȃ
                    }
                } else {
                    // Ȃ
                }
            }
            return selected;
        }

        /**
         * f<br>
         */
        public void stop() {
            if (installWorker == null) {
                // Ȃ
            } else if (installWorker.isCancelled()) {
                // Ȃ
            } else {
                jButtonRight.setEnabled(false);
                installWorker.cancel();
            }
        }

        /**
         * I
         */
        public void cancel() {
            System.exit(0);
        }

        /**
         * uցv{^ꂽƂ̏
         */
        public void next() {
            if (currentPageId == PAGE_SELECT_PRODUCT
                && !isSelectedAnyProducts()) {
                final String msg = String.format(
                    MSG_INFO_NOT_SELECTED_ANY_PRODUCTS, getModeText());
                JOptionPane.showMessageDialog(
                    parent, msg, MSG_INFO_TITLE,
                    JOptionPane.INFORMATION_MESSAGE);
            } else if (currentPageId >= endPageId) {
                currentPageId = endPageId + 1;
            } else {
                currentPageId++;
                cardLayout.next(jPanelMessage);
            }

            // [h擾
            final int mode = getMode();
            final String modeText = getModeText();

            // TODO: y[WɂāAJڒ̏ɋLq
            // Ant̎sƂA`FbN{bNXȊÓ؂Ƃ
            switch (currentPageId) {
                case PAGE_CONFIRM_PRODUCT:
                    JProgressBar bar1 = null;
                    Component[] components1 = jPanelButton.getComponents();
                    for (int i = 0; i < components1.length; i++) {
                        if (components1[i] instanceof JProgressBar) {
                            bar1 = (JProgressBar) components1[i];
                        }
                    }
                    bar1.setValue(0);

                    Component[] components = jPanelInCheckBox.getComponents();
                    StringBuffer buf = new StringBuffer();
                    buf.append("ȉ̃v_Ng");
                    buf.append(modeText);
                    buf.append("܂B\n");
                    buf.append("낵΁Au");
                    buf.append(NEXT_BUTTON);
                    buf.append("vĂB\n");
                    buf.append("Cꍇ́Au");
                    buf.append(BACK_BUTTON);
                    buf.append("vĂB\n\n");
                    for (int i = 0; i < components.length; i++) {
                        if (components[i] instanceof JCheckBox) {
                            if (((JCheckBox) components[i]).isSelected()) {
                                String selectedProduct = ((JCheckBox) components[i])
                                        .getText();
                                buf.append(selectedProduct + "\n");
                            }
                        }
                    }
                    jTextArea1.setText(buf.toString());
                    break;
                case PAGE_EXECUTE:

                    // vOXo[
                    jProgressBar1.setValue(0);

                    // J[\vɐݒ
                    Cursor waitCursol = Cursor
                            .getPredefinedCursor(Cursor.WAIT_CURSOR);
                    parent.setCursor(waitCursol);

                    // ʃXbhŃ_E[h  CXg[
                    installWorker = new InstallWorker(
                        mode, parent, jTextArea2, jProgressBar1,
                        jPanelInCheckBox, jPanelButton, jButtonRight);
                    installWorker.execute();

                    break;
                case (endPageId + 1):
                    cancel();
                    break;
                default:
                    break;
            }
            updateButtonPanel();
        }

        /**
         * u߂v{^ꂽƂ̏
         */
        public void back() {
            if (currentPageId <= startPageId) {
                // Ȃ
            } else {
                currentPageId--;
                cardLayout.previous(jPanelMessage);
            }
            updateButtonPanel();
        }

        /**
         *  {^pl̏B
         *  ݂̃y[WԍɂāA\{^قȂB
         *  TODO: Ԃɂă{^Ȃ鏈Kv
         */
        public void updateButtonPanel() {
            switch (currentPageId) {
                case PAGE_SELECT_STACK:
                    setDefaultCloseOperation(EXIT_ON_CLOSE);
                    jMenu2.setEnabled(true);
                    jPanelDescription.setVisible(false);
                    setButtonGroupModeVisible(false);
                    jProgressBar1.setVisible(false);
                    jButtonLeft.setVisible(false);
                    jButtonRight.setVisible(false);
                    jButtonRight.setEnabled(true);
                    break;
                case PAGE_LICENSE:
                    final String stackXml = System
                            .getProperty("user.stackxmlfile.name");
                    setDefaultCloseOperation(EXIT_ON_CLOSE);
                    jMenu2.setEnabled(false);
                    jPanelDescription.setVisible(true);
                    setButtonGroupModeVisible(true);
                    setButtonGroupModeEnabled(false);
                    if (stackXml == null) {
                        setButtonGroupLicenseEnabled(false);
                    } else {
                        setButtonGroupLicenseEnabled(true);
                    }
                    jProgressBar1.setVisible(false);
                    jButtonLeft.setVisible(true);
                    jButtonRight.setVisible(true);
                    if (jRadioLicenseOk.isSelected()) {
                        jButtonRight.setEnabled(true);
                    } else {
                        jButtonRight.setEnabled(false);
                    }
                    jButtonRight.setText(NEXT_BUTTON);
                    break;
                case PAGE_SELECT_PRODUCT:
                    setDefaultCloseOperation(EXIT_ON_CLOSE);
                    jMenu2.setEnabled(true);
                    jPanelDescription.setVisible(true);
                    setButtonGroupModeVisible(true);
                    setButtonGroupModeEnabled(true);
                    setButtonGroupLicenseEnabled(true);
                    jProgressBar1.setVisible(false);
                    jButtonLeft.setVisible(true);
                    jButtonLeft.setText(BACK_BUTTON);
                    jButtonRight.setVisible(true);
                    jButtonRight.setText(NEXT_BUTTON);
                    break;
                case PAGE_CONFIRM_PRODUCT:
                    setDefaultCloseOperation(EXIT_ON_CLOSE);
                    jMenu2.setEnabled(false);
                    jPanelDescription.setVisible(true);
                    setButtonGroupModeVisible(true);
                    setButtonGroupModeEnabled(false);
                    jProgressBar1.setVisible(false);
                    jButtonLeft.setVisible(true);
                    jButtonLeft.setText(BACK_BUTTON);
                    jButtonRight.setVisible(true);
                    jButtonRight.setText(NEXT_BUTTON);
                    break;
                case PAGE_EXECUTE:
                    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
                    jMenu2.setEnabled(false);
                    jPanelDescription.setVisible(true);
                    setButtonGroupModeVisible(true);
                    setButtonGroupModeEnabled(false);
                    jProgressBar1.setVisible(true);
                    jButtonLeft.setVisible(false);
                    jButtonRight.setVisible(true);
                    jButtonRight.setText(CANCEL_BUTTON);
                    break;
                default:
                    break;
            }

            // ^Cgo[Ƀ^Cgݒ肷
            final String title = getTitle();
            parent.setTitle(title);
        }

        /**
         * IꂽWI{^胂[h(CXg[AACXg[AAbvf[g)l擾<br>
         * @return [hl
         */
        private int getMode() {
            int mode = -1;
            if (jRadioInstall.isSelected()) {
                mode = Setup.MODE_INSTALL;
            } else if (jRadioUninstall.isSelected()) {
                mode = Setup.MODE_UNINSTALL;
            } else if (jRadioUpdate.isSelected()) {
                mode = Setup.MODE_UPDATE;
            } else {
                mode = Setup.MODE_INSTALL;
            }
            return mode;
        }

        /**
         * IꂽWI{^胂[h(CXg[AACXg[AAbvf[g)̉ʕ\p̕擾<br>
         * @return [hl
         */
        private String getModeText() {
            String mode = "UnKnown";
            Enumeration<AbstractButton> buttonEnum = buttonGroupMode
                    .getElements();
            while (buttonEnum.hasMoreElements()) {
                AbstractButton button = buttonEnum.nextElement();
                if (button.isSelected()) {
                    mode = button.getText();
                    break;
                } else {
                    // Ȃ
                }
            }
            return mode;
        }

    }

    /**
     * AntgpăX^bNݒt@Cǂݍ<br>
     *  QƉ̂<br>
     * @param stackXml X^bNݒt@C
     * @return {ϐɐݒ肳KeyAValuȇgݍ킹i[Map
     */
    private Map<String, String> getStackXmlProperties(final File stackXml) {
        final String moreTypes = "install-before, product, install-after, depend";
        return getXmlProperties(stackXml, moreTypes);
    }

    /**
     * Antgpăv_Ngݒt@Cǂݍ<br>
     *  QƉ̂<br>
     * @param productXml v_Ngݒt@C
     * @return {ϐɐݒ肳KeyAValuȇgݍ킹i[Map
     */
    private Map<String, String> getProductXmlProperties(final File productXml) {
        final String moreTypes = "pattern, file, exec, arg";
        return getXmlProperties(productXml, moreTypes);
    }

    /**
     * AntgpXMLǂݍ<br>
     *  QƉ̂<br>
     * @param xml ǂݍXMLt@C
     * @param moreTypes `ƂēǂݍރvpeB(J}؂)
     * @return {ϐɐݒ肳KeyAValuȇgݍ킹i[Map
     */
    @SuppressWarnings("unchecked")
    private Map<String, String> getXmlProperties(final File xml,
            final String moreTypes) {
        Project project = new Project();
        project.setName("OpenStandia");
        project.setBasedir("..");

        // ʐݒǂݍ
        File commonXml = new File(System.getProperty("user.dir")
                                  + "/common.xml");
        ExtendsXmlProperty commonXmlProperty = new ExtendsXmlProperty();
        commonXmlProperty.setProject(project);
        commonXmlProperty.setFile(commonXml);
        commonXmlProperty.setSemanticAttributes(true);
        commonXmlProperty.setKeeproot(true);
        commonXmlProperty.setMoreTypes(moreTypes);
        commonXmlProperty.execute();

        // w肳ꂽXMLt@Cǂݍ
        ExtendsXmlProperty xmlProperty = new ExtendsXmlProperty();
        xmlProperty.setProject(project);
        xmlProperty.setFile(xml);
        xmlProperty.setSemanticAttributes(true);
        xmlProperty.setKeeproot(true);
        xmlProperty.setMoreTypes(moreTypes);
        xmlProperty.execute();
        Map<String, String> properties = project.getProperties();

        return properties;
    }

    /**
     * [h(ButtonGroupMode)ĨWI{^ꊇŎgp/sݒ肷<br>
     * @param enabled true : gp / false : gps
     */
    private void setButtonGroupModeEnabled(final boolean enabled) {
        Enumeration<AbstractButton> buttonEnum = buttonGroupMode
                .getElements();
        while (buttonEnum.hasMoreElements()) {
            AbstractButton button = buttonEnum.nextElement();
            button.setEnabled(enabled);
        }
    }

    /**
     * [h(ButtonGroupMode)ĨWI{^ꊇŕ\/\ݒ肷<br>
     * @param enabled true : \ / false : \
     */
    private void setButtonGroupModeVisible(final boolean visible) {
        Enumeration<AbstractButton> buttonEnum = buttonGroupMode
                .getElements();
        while (buttonEnum.hasMoreElements()) {
            AbstractButton button = buttonEnum.nextElement();
            button.setVisible(visible);
        }
    }

    /**
     * CZX(ButtonGroupLicense)ĨWI{^ꊇŎgp/sݒ肷<br>
     * @param enabled true : gp / false : gps
     */
    private void setButtonGroupLicenseEnabled(final boolean enabled) {
        Enumeration<AbstractButton> buttonEnum = buttonGroupLicense
                .getElements();
        while (buttonEnum.hasMoreElements()) {
            AbstractButton button = buttonEnum.nextElement();
            button.setEnabled(enabled);
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupLicense;

    private javax.swing.ButtonGroup buttonGroupMode;

    private javax.swing.JButton jButtonLeft;

    private javax.swing.JButton jButtonRight;

    private javax.swing.JLabel jLabel1;

    private javax.swing.JLabel jLabel2;

    private javax.swing.JLabel jLabel3;

    private javax.swing.JLabel jLabel5;

    private javax.swing.JLabel jLabelDesc;

    private javax.swing.JLabel jLabelLogo;

    private javax.swing.JLabel jLabelName;

    private javax.swing.JLabel jLabelVersion;

    private javax.swing.JMenu jMenu2;

    private javax.swing.JMenuBar jMenuBar2;

    private javax.swing.JMenuItem jMenuItem1;

    private javax.swing.JMenuItem jMenuItem2;

    private javax.swing.JPanel jPanelButton;

    private javax.swing.JPanel jPanelCheckBox;

    private javax.swing.JPanel jPanelConfirm;

    private javax.swing.JPanel jPanelDescription;

    private javax.swing.JPanel jPanelInCheckBox;

    private javax.swing.JPanel jPanelLicense;

    private javax.swing.JPanel jPanelMessage;

    private javax.swing.JPanel jPanelResult;

    private javax.swing.JPanel jPanelSelectStack;

    private javax.swing.JProgressBar jProgressBar1;

    private javax.swing.JRadioButton jRadioInstall;

    private javax.swing.JRadioButton jRadioLicenseNg;

    private javax.swing.JRadioButton jRadioLicenseOk;

    private javax.swing.JRadioButton jRadioUninstall;

    private javax.swing.JRadioButton jRadioUpdate;

    private javax.swing.JScrollPane jScrollPane1;

    private javax.swing.JScrollPane jScrollPane2;

    private javax.swing.JScrollPane jScrollPane3;

    private javax.swing.JScrollPane jScrollPane4;

    private javax.swing.JTextArea jTextArea1;

    private javax.swing.JTextArea jTextArea2;

    private javax.swing.JTextArea jTextArea3;

    // End of variables declaration//GEN-END:variables

    private WizardMediator mediator;

}
