package jp.ossc.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * 񕪊̌߂Ant^XNNXłB<br>
 * @author S.Fujii
 * @version 1.0
 * @since 1.0
 */
public class SplitLength extends Task {

    /**
     * 񕪊Ώە<br>
     */
    protected String target;

    /**
     * 镶(f~^[)<br>
     *  Kl : ,<br>
     */
    protected String delim;

    /**
     * propertyƂĕۑۂnamel<br>
     */
    protected String name;

    /**
     * property㏑邩ǂ<br>
     * true : ㏑ / false : Ȃ<br>
     */
    protected Boolean override;

    /**
     * RXgN^[<br>
     */
    public SplitLength () {
        super();
        this.target = null;
        this.delim = ",";
        this.name = null;
        this.override = false;
    }

    /**
     * 镶(f~^[)擾<br>
     * @return 镶(f~^[)
     */
    public String getDelim() {
        return delim;
    }

    /**
     * 镶(f~^[)ݒ肷<br>
     * @param lDelim 镶(f~^[)
     */
    public void setDelim(String lDelim) {
        this.delim = lDelim;
    }

    /**
     * propertyƂĕۑۂnamel擾<br>
     * @return propertyƂĕۑۂnamel
     */
    public String getName() {
        return name;
    }

    /**
     * propertyƂĕۑۂnamelݒ肷<br>
     * @param lName propertyƂĕۑۂnamel
     */
    public void setName(String lName) {
        this.name = lName;
    }

    /**
     * 񕪊Ώە擾<br>
     * @return 񕪊Ώە
     */
    public String getTarget() {
        return target;
    }

    /**
     * 񕪊Ώەݒ肷<br>
     * @param lTarget 񕪊Ώە
     */
    public void setTarget(String lTarget) {
        this.target = lTarget;
    }

    /**
     * property㏑邩ǂ擾<br>
     * @return true : ㏑ / false : Ȃ
     */
    public Boolean isOverride() {
        return override;
    }

    /**
     * property㏑邩ǂݒ肷<br>
     * @param override true : ㏑ / false : Ȃ
     */
    public void setOverride(boolean override) {
        this.override = Boolean.valueOf(override);
    }

    /**
     * Ant^XNs<br>
     * @throws BuildException
     * @see org.apache.tools.ant.Task#execute()
     */
    public void execute() throws BuildException {

        // `FbN
        checkAttribute();

        // 񕪊
        final String delimEsc = delim.replaceAll("\\\\", "\\\\\\\\");
        final String[] values = target.split(delimEsc);

        // propertyɕۑ
        final String len = Integer.toString(values.length);
        if (override) {
            final String value = getProject().getProperty(name);
            if (value == null) {
                getProject().setNewProperty(name, len);
            } else {
                getProject().setProperty(name, len);
            }
        } else {
            getProject().setNewProperty(name, len);
        }

    }

    /**
     * `FbN<br>
     * (1) targetAname͕K{<br>
     */
    protected void checkAttribute() {
        if (getProject() == null) {
            throw new IllegalStateException("project has not been set");
        } else if (target == null || name == null) {
            throw new BuildException(
                "You must specify target, name", getLocation());
        } else {
            // Ȃ
        }
    }

}
