/*
 * $Id: IndexTermBrowserPanel.java,v 1.4 2006/01/26 16:38:10 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.tools.itb;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.itb.search.Query;
import org.logical_paradox.koike.rss.tools.itb.search.QueryRecord;
import org.logical_paradox.koike.rss.tools.itb.search.Select;

/**
 * uEUpl
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class IndexTermBrowserPanel extends WindowPanel implements ActionListener {
	/** VAo[WUID */
	private static final long serialVersionUID = -7596674902738418508L;

	/** K[ */
	private static final Log log = LogFactory.getLog(IndexTermBrowserPanel.class);

	/*
	 * GUIvpeB
	 * ̃tB[hɂ́CindexTermBrowserPanel.termInputField
	 * ̂悤ɃANZXD
	 */
	/** ʃe[u */
	public JTable wordListTable;
	/** ʃXg */
	public IndexTermWordListTableModel wordListTableModel;
	/** ̓tB[h */
	public JTextField termInputField;
	/** rownumJnʒu̓tB[h */
	public JTextField rownumFromInputField;
	/** rownumIʒu̓tB[h */
	public JTextField rownumToInputField;
	/** {^ */
	public JButton btnSearch;

	/** y[W{^ */
	public JButton btnNextPage;
	/** Oy[W{^ */
	public JButton btnPrevPage;

	/** ʐ */
	public JLabel labelTotalRecords;

	/** R[hIWbN */
	private Select select;

	/**
	 * RXgN^D
	 */
	public IndexTermBrowserPanel() {
		init();
	}
	/**
	 * ̃plD
	 */
	protected void init() {
		setLayout(new BorderLayout());

		// pl
		JPanel searchConditionPanel = new JPanel();
		searchConditionPanel.setBorder(BorderFactory.createTitledBorder("search condition"));
		searchConditionPanel.setLayout(new BorderLayout());
		JPanel conditionMainPanel = new JPanel();
		conditionMainPanel.setLayout(new BoxLayout(conditionMainPanel, BoxLayout.X_AXIS));
		conditionMainPanel.add(new JLabel("  term  "));
		termInputField = new JTextField();
		conditionMainPanel.add(termInputField);
		conditionMainPanel.add(new JLabel("  rownum from  "));
		rownumFromInputField = new JTextField();
		conditionMainPanel.add(rownumFromInputField);
		conditionMainPanel.add(new JLabel("  to  "));
		rownumToInputField = new JTextField();
		conditionMainPanel.add(rownumToInputField);

		searchConditionPanel.add(conditionMainPanel, BorderLayout.CENTER);

		btnSearch = new JButton("search");
		btnSearch.addActionListener(this);
		searchConditionPanel.add(btnSearch, BorderLayout.EAST);

		add(searchConditionPanel, BorderLayout.NORTH);

		// ʈꗗ
		JScrollPane wordListPane = new JScrollPane();
		wordListTableModel = new IndexTermWordListTableModel();
		wordListTable = new JTable(wordListTableModel);
		wordListPane.getViewport().setView(wordListTable);

		add(wordListPane, BorderLayout.CENTER);

		// Oy[Wy[Wpl
		JPanel pageSelectionPanel = new JPanel();
		pageSelectionPanel.setLayout(new BorderLayout());
		JPanel pageSelBtnPanel = new JPanel();
		pageSelBtnPanel.setLayout(new GridLayout(1, 2));

		btnNextPage = new JButton("next");
		btnPrevPage = new JButton("prev");
		btnNextPage.setEnabled(false);
		btnPrevPage.setEnabled(false);

		pageSelBtnPanel.add(btnPrevPage);
		pageSelBtnPanel.add(btnNextPage);
		pageSelectionPanel.add(pageSelBtnPanel, BorderLayout.WEST);
		labelTotalRecords = new JLabel(""); 
		pageSelectionPanel.add(labelTotalRecords, BorderLayout.EAST);
		add(pageSelectionPanel, BorderLayout.SOUTH);
	}
	/**
	 * {^̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == btnSearch) {
			executeSearch();
		}
	}

	/**
	 * sD
	 */
	protected void executeSearch() {
		log.trace("Jn܂");
		// {^
		try {
			// R[hWbN[h㏉D
			select = (Select)Class.forName(BrowserProperties.getProperty("select.class")).newInstance();
			select.open(BrowserProperties.getProperty("select.param.init"));
		} catch(Exception ex) {
			log.error("R[hIWbÑCX^XɎs܂:", ex);
		}

		// 𐶐
		Query query = new Query();
		String term = termInputField.getText().trim();
		String rownumFrom = rownumFromInputField.getText().trim();
		String rownumTo = rownumToInputField.getText().trim();

		// 
		query.setTerm(term);
		// Jnʒu
		query.setFrom(rownumFrom.length() == 0 ? Query.NaN : Integer.parseInt(rownumFrom));
		// Iʒu
		query.setTo(rownumTo.length() == 0 ? Query.NaN : Integer.parseInt(rownumTo));

		// s
		int resultCount = 0;
		QueryRecord[] results = null;
		try {
			resultCount = select.countQuery(query);
			results = select.executeQuery(query);

			log.trace("ʐ: " + resultCount);

			// \n̍XV
			labelTotalRecords.setText(resultCount + " ");
			rownumFromInputField.setText("" + query.getFrom());
			rownumToInputField.setText("" + query.getTo());

			// {^̗Lݒ
			boolean enablePreviousBtn = query.getFrom() > 0;
			boolean enableNextBtn = resultCount >= query.getTo();
			btnPrevPage.setEnabled(enablePreviousBtn);
			btnNextPage.setEnabled(enableNextBtn);

			btnPrevPage.validate();
			btnNextPage.validate();

			// ʕ\̐ݒ
			wordListTableModel.setResults(results == null ? new QueryRecord[0] : results);
			wordListTable.revalidate();
		} catch(DataSourceException e) {
			log.error("Ɏs܂F", e);
		}
	}
	/**
	 * ID
	 * AvP[VŎgpĂSẴ\[XSɉD
	 */
	public void close() {
		log.trace("IJn");
		if(select != null) {
			try {
				select.close();
			} catch(DataSourceException dse) {
				log.warn("f[^\[Xڑ̉Ɏs܂Cď͑s܂F", dse);
			}
		}
		log.trace("I");
	}
}
