/*
 * $Id: DocumentBrowserPanel.java,v 1.5 2006/01/26 16:38:10 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.tools.docb;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.koike.rss.tools.DataSourceException;

/**
 * hLguEUpl
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class DocumentBrowserPanel extends WindowPanel implements ActionListener {
	/** VAo[WUID */
	private static final long serialVersionUID = -2498385689102308503L;

	/** K[ */
	private static final Log log = LogFactory.getLog(DocumentBrowserPanel.class);

	/** URL͈ */
	public JTextField url;
	/** ԍ͈ */
	public JTextField docno;
	/** Rec\̈ */
	public JTextArea document;
	/** {^ */
	public JButton btnSearch;
	/** {^ */
	public JButton btnClear;

	/** hLgIWbN */
	private Select select;

	/**
	 * RXgN^D
	 */
	public DocumentBrowserPanel() {
		init();
	}
	/**
	 * ̃plD
	 */
	protected void init() {
		setLayout(new BorderLayout());
		JPanel searchControlPanel = new JPanel();
		searchControlPanel.setBorder(BorderFactory.createTitledBorder("search condition"));
		searchControlPanel.setLayout(new BoxLayout(searchControlPanel, BoxLayout.X_AXIS));

		url = new JTextField();
		url.setColumns(30);
		docno = new JTextField();
		docno.setColumns(10);

		// 
		searchControlPanel.add(new JLabel("  URL : "));
		searchControlPanel.add(url);
		searchControlPanel.add(new JLabel("  docno : "));
		searchControlPanel.add(docno);
		btnSearch = new JButton("retrieve");
		btnSearch.addActionListener(this);
		searchControlPanel.add(btnSearch);

		// Ɖʉ
		document = new JTextArea();
		document.setEditable(false);
		document.setLineWrap(true);
		JScrollPane documentPane = new JScrollPane(document);

		// {^
		JPanel controlPanel = new JPanel();
		controlPanel.setLayout(new BorderLayout());
		btnClear = new JButton("clear");
		btnClear.addActionListener(this);
		controlPanel.add(btnClear, BorderLayout.EAST);

		add(searchControlPanel, BorderLayout.NORTH);
		add(documentPane, BorderLayout.CENTER);
		add(controlPanel, BorderLayout.SOUTH);
		validate();
		setVisible(true);
	}
	/**
	 * {^̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == btnClear) {
			// 
			document.setText("");
		} else if(e.getSource() == btnSearch) {
			// Jn
			log.trace("Jn܂");
			if(select == null) {
				try {
					select = (Select)Class.forName(BrowserProperties.getProperty("select.class")).newInstance();
					select.open(BrowserProperties.getProperty("select.param.init"));
				} catch(Exception ex) {
					log.error("hLgZN^̃CX^XɎs:", ex);
				}
			}

			// ̍쐬
			Query q = new Query();
			String digest = url.getText();
			int cid = -1;
			try {
				if(docno.getText() != null && docno.getText().trim().length() > 0) {
					// ԍw肳Ăꍇ͐ɕϊ
					cid = Integer.parseInt(docno.getText());
				}
			} catch(NumberFormatException ne) {
			}

			q.setUrl(digest);
			q.setDocno(cid);

			// Ɖs
			try {
				String contents = select.executeQuery(q);
				if(contents == null) {
					// łȂ̂Ń_CAO\
					JOptionPane.showMessageDialog(this, "contents not found", "inquiry error", JOptionPane.ERROR_MESSAGE);
				} else {
					// łfR[hĕ\
					log.trace(contents);
					document.setText(contents);
				}
			} catch(DataSourceException dse) {
				log.error("炩̗RŏƉɎs܂:", dse);
			}
		}
	}
	/**
	 * ̃plŎgpĂSẴ\[XāCID
	 */
	public void close() {
		log.trace("IJn܂");
		if(select != null) {
			try {
				select.close();
			} catch(DataSourceException e) {
				log.warn("f[^\[XƂ̐ڑIɗO:", e);
			}
		}
		log.trace("I܂");
	}
}
