/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MySQLFTSPerformanceTest.java,v 1.2 2006/01/26 16:38:09 rampil Exp $
 */
package org.logical_paradox.koike.rss;

import java.io.FileInputStream;
import java.util.Properties;

import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchEngine;
import org.logical_paradox.koike.rss.search.RSSSearchEngine;

/**
 * MySQLp̃C^[tF[XgpCvt@COp̃c[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class MySQLFTSPerformanceTest {
	/**  */
	public static final String SEARCH_CONDITION = "ghIł܂B Ǝ}ڑ\ɂ̓Lbg";

	/**
	 * C\bh
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		Properties p = new Properties();
		p.load(new FileInputStream("conf/koike.conf"));
		KoikeConfig config = new KoikeConfig(p);

		SearchEngine core = new RSSSearchEngine(config);

		String[] searchWords = SEARCH_CONDITION.split(" ");		// pXy[X؂Ō𕪊

		// 𐶐
		SearchCondition condition = new SearchCondition();
		for(int i = 0; i < searchWords.length; i++) {
			condition.addChildNode(new Element(Element.TYPE_TERM, searchWords[i]));
		}
		// 1y[W̕\
		condition.setDispnum(10);
		// \Jnʒu
		condition.setStartp(0);
		double begin = System.currentTimeMillis();
		core.search(condition);
		double fin = System.currentTimeMillis();


		System.out.println((fin-begin) / 1000.0);
	}
}
