/*
 * $Id$
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.rcm.accessor.mysql.validator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * f[^x[XڑmFc[D
 * @author satoshi akabane@logical-paradox.org
 * @versiop $Revision$
 */
public class ConnectionValidator extends Thread {
	/** ؑΏېڑZbg̃Xg */
	private final List<ConnectionValidation> validations = new ArrayList<ConnectionValidation>();
	/** pingԊu */
	private final long interval;

	/**
	 * RXgN^D
	 * ̌؃c[daemonXbhƂē삷D
	 * @param msec pingԊu(P:msec.)
	 */
	public ConnectionValidator(long msec) {
		interval = msec;
		setDaemon(true);
	}
	/**
	 * ڑ؃IuWFNgǉD
	 * @param validation ڑ؃IuWFNg
	 */
	public void add(ConnectionValidation validation) {
		validations.add(validation);
	}
	/**
	 * ڑ؃IuWFNgSăN[YD
	 * ʂ̃\bh͎gpȂĂǂ͂D
	 */
	public void closeAll() {
		for(ConnectionValidation validation : validations) {
			try {
				validation.close();
			} catch(SQLException e) {
				// قƂȂ̂Ŗ
			}
		}

		// ؃IuWFNgS폜
		validations.clear();
	}
	/**
	 * XbhCD
	 */
	@Override
	public void run() {
		try {
			while(true) {
				Thread.sleep(interval);
				// pingł
				List<ConnectionValidation> closedConnections = new ArrayList<ConnectionValidation>();
				for(ConnectionValidation validation : validations) {
					try {
						validation.ping();
					} catch (SQLException e) {
						// pingŝŁC̐ڑ͋炭płȂ
						closedConnections.add(validation);
					}
				}

				// ɖɂȂĂ܂Ǝvڑ؃IuWFNgj
				// Ƃ肠CN[Yw͂炢Ă݂
				for(ConnectionValidation validation : closedConnections) {
					try {
						validation.close();
					} catch(SQLException e) {
						// 
					}
				}
				// ڑS폜
				validations.removeAll(closedConnections);
			}
		} catch(InterruptedException e) {
			// of[^~D
			close();
		}
	}
	/**
	 * Xbh~D
	 */
	public void shutdown() {
		interrupt();
	}
	/**
	 * ̃of[^[ID
	 */
	protected void close() {
		closeAll();
	}
}
