/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DbmysqlContentsAccessor.java,v 1.14 2006/02/22 15:47:01 akabane Exp $
 */
package org.logical_paradox.rss.rcm.accessor.mysql;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.charset.CharsetUtils;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;
import org.logical_paradox.rss.rcm.accessor.simple.VirtualQueueServer;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

/**
 * DbmysqlContentsAccessor
 * mysqlf[^x[XRecXg[WƂĎgpANZXC^[tF[X
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.14 $
 */
public class DbmysqlContentsAccessor implements ContentsAccessor {
	/** K[ */
	private static final Log log = LogFactory.getLog(DbmysqlContentsAccessor.class);

	/** ڑDSR */
	private String dsruri;
	/** RecGR[fBO */
	private String contentsEncoding;
	/** Reci[ہCGR[fBOϊKvƂ邩ǂ(true: / false:Ȃ) */
	private boolean needToEncode = false;
	/** ̃C^[tF[XڑԂǂ(true:ڑ / false:ڑ) */
	private boolean activeFlag = false;
	/** zL[T[o[ */
	private VirtualQueueServer queue = null;
	/** f[^tB^ */
	private static DataFilter dataFilter = null;

	/** f[^x[Xڑ */
	private Connection con;
	/** Xe[gg */
	private PreparedStatement pstmt;
	/** f[^x[Xڑ؃vZX */
	private ConnectionValidator validator;

	/** JDBChCoNX */
	public static final String JDBC_DRIVER_CLASSNAME = "com.mysql.jdbc.Driver";
	/** f[^x[XڑĎԊu(msec) */
	public static final long CONNECTION_WATCH_INTERVAL = 120 * 1000;

	/*
	 * f[^tB^Ȃǂ̏
	 */
	static {
		dataFilter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);
	}

	/**
	 * RXgN^D
	 */
	public DbmysqlContentsAccessor() {
		activeFlag = false;
	}
	/**
	 * ɌĂ΂D
	 * @param initparam p[^
	 */
	public void init(String initparam) {
		open(initparam);
	}
	/**
	 * RecXg[WƐڑ
	 * @param openstr ڑ
	 */
	public synchronized void open(String openstr) {
		if(isActive()) {
			// ɃI[vĂ
			return;
		}

		if(openstr == null || openstr.trim().length() == 0) {
			throw new IllegalArgumentException();
		}

		// JDBChCõ[hƐڑ
		try {
			activeFlag = true;
			// zL[T[o[֐ڑ
			queue = new VirtualQueueServer(dsruri);
			// f[^x[Xڑ쐬
			Class.forName(JDBC_DRIVER_CLASSNAME);
			con = DriverManager.getConnection(openstr);
			// Xe[gg̍쐬
			String sql = "select * from contents where mkey=?";
			pstmt = con.prepareStatement(sql);

			// ڑĎXbhN
			validator = new ConnectionValidator(CONNECTION_WATCH_INTERVAL);
			ConnectionValidation cv = new ConnectionValidation(con, "select count(*) from contents");
			validator.add(cv);
			validator.start();
		} catch(Exception e) {
			// 炩̃G[ꍇC\[X̉sȂ
			if(con != null) {
				DbUtils.closeConnection(con);
				con = null;
			}
			if(pstmt != null) {
				DbUtils.closeStatement(pstmt);
				pstmt = null;
			}
			log.error("C^[tF[X̏Ɏs܂:" + ExceptionUtils.stackTraceToString(e));
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * Reco^
	 * @param contents o^Rec
	 */
	public synchronized void regist(WebContents contents) {
		String sql = "insert into contents values(null,?,?,?,?,?)";
		String url = contents.getLocation();
		String document = contents.getDocument();

		byte[] barray = new byte[0];
		try {
			// GR[fBOϊKvłΕϊD
			if(needToEncode) {
				log.info("Rec̃GR[fBOϊĂ܂[" + contentsEncoding + "]");
				document = CharsetUtils.encode(contentsEncoding, document);
				barray = dataFilter.compressContents(document.getBytes("ISO-8859-1"));
			} else {
				barray = dataFilter.compressContents(document.getBytes());
			}
		} catch (Exception e1) {
			// Rec̈kɎsꍇCo^łȂ̂Ń[jOoĖ
			log.warn("Rec̃tB^OɎs܂:" + ExceptionUtils.stackTraceToString(e1), e1);
			return;
		}
		ByteArrayInputStream bi = new ByteArrayInputStream(barray);
		String sitename = contents.getSitename();
		String title = contents.getTitle();
		PreparedStatement updateStmt = null;
		Statement st = null;
		ResultSet rs = null;
		try {
			// wURLMD5_CWFXg擾āCRecƊ֘AtL[Ƃ
			String digest = dataFilter.filterURL(url);
			updateStmt = con.prepareStatement(sql);
			updateStmt.setString(1, digest);						// mkey
			updateStmt.setString(2, sitename);					// sitename
			updateStmt.setString(3, title);						// title
			updateStmt.setString(4, url);						// URL
			updateStmt.setBinaryStream(5, bi, barray.length);	// contents
			updateStmt.executeUpdate();
			updateStmt.close();

			// ꂽR[hID擾
			sql = "select last_insert_id() as did from contents";
			st = con.createStatement();
			rs = st.executeQuery(sql);
			if(rs.next()) {
				long did = rs.getLong("did");
				// L[URL𓊓
				String documentId = DocumentIdGenerator.getDocumentId(did, digest);
				queue.enqueue(documentId);
			} else {
				log.warn("炩̌ŃhLgԍ𔭔Ԃł܂ł");
			}
		} catch(Exception e) {
			// o^łȂ
			log.warn("Rec̓o^Ɏs܂:" + ExceptionUtils.stackTraceToString(e), e);
		} finally {
			// gp\[X̉
			if(updateStmt != null) {
				DbUtils.closeStatement(updateStmt);
			}
			if(rs != null) {
				DbUtils.closeResultSet(rs);
			}
			if(st != null) {
				DbUtils.closeStatement(st);
			}
		}
	}

	/**
	 * Rec폜D
	 * @param url 폜Ώۂ̃Rec
	 */
	public void unregist(String url) {
		if(isActive() == false || url == null || url.trim().length() == 0) {
			throw new IllegalStateException();
		}

		String sql = "delete from contents where mkey=?";
		PreparedStatement deleteStmt = null;
		Connection con = null;
		try {
			deleteStmt = con.prepareStatement(sql);
			deleteStmt.setString(1, url);
			deleteStmt.executeUpdate(sql);
		} catch(SQLException se) {
			// 폜łȂ
			log.warn("Rec̍폜Ɏs܂[" + url + "]: " + ExceptionUtils.stackTraceToString(se), se);
		} finally {
			// \[X̉
			if(deleteStmt != null) {
				DbUtils.closeStatement(deleteStmt);
				deleteStmt = null;
			}
		}
	}

	/**
	 * SẴRec폜
	 */
	public void unregistAll() {
		if(isActive() == false) {
			throw new IllegalStateException();
		}

		String sql = "delete from contents";
		Statement st = null;
		Connection con = null;
		try {
			st = con.createStatement();
			st.executeUpdate(sql);
		} catch(SQLException se) {
			// 폜łȂ
			log.warn("Rec̍폜Ɏs܂:" + ExceptionUtils.stackTraceToString(se), se);
		} finally {
			// \[X̉
			if(st != null) {
				DbUtils.closeStatement(st);
				st = null;
			}
		}
	}

	/**
	 * wURLɑΉRecԂ
	 */
	public String find(String url) {
		if(isActive() == false || url == null || url.trim().length() == 0) {
			throw new IllegalStateException();
		}

		String contents = null;
		ResultSet rs = null;
		try {
			pstmt.setString(1, url);
			rs = pstmt.executeQuery();
			if(rs.next()) {
				contents = rs.getString(1);
			}
		} catch(SQLException se) {
			// G[̏ꍇ͉Ȃ
			log.warn("Rec̎擾Ɏs܂[" + url + "]:" + ExceptionUtils.stackTraceToString(se), se);
		} finally {
			// \[X̉
			if(rs != null) {
				DbUtils.closeResultSet(rs);
				rs = null;
			}
		}
		return contents;
	}

	/**
	 * Xg[WƂ̐ڑD
	 * łN[YD
	 */
	public synchronized void close() {
		if(isActive() == false) {
			throw new IllegalStateException("connector has already been closed");
		}
		// DBڑ̃N[Y
		try {
			if(pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
		} catch(SQLException e) {
			// ǂ悤Ȃ̂ŖĂ
			log.warn("Xe[ggN[YɗO܂:" + ExceptionUtils.stackTraceToString(e), e);
		} finally {
			// ǂłDBڑ̓N[YĂ
			if(con != null) {
				try {
					con.close();
				} catch(SQLException e) {
					// ǂł
					log.warn("f[^x[XڑIɗO܂:" + ExceptionUtils.stackTraceToString(e), e);
				}
				con = null;
			}
		}
		activeFlag = false;
	}

	/**
	 * ̃C^[tF[Xgp\ǂԂ
	 */
	protected boolean isActive() {
		return activeFlag;
	}

	/**
	 * t@CiCU
	 */
	public void finalize() {
		try {
			close();
		} catch(Exception e) {
			// ȂDłȂ
		}
	}
	/**
	 * ڑDSRݒ肷D
	 * @param uri ڑDSR uri
	 */
	public void setDSRURI(String uri) {
		dsruri = uri;
	}
	/**
	 * Rec̃GR[fBOݒ肷D
	 * @param encoding GR[fBOD
	 */
	public void setContentsEncoding(String encoding) {
		contentsEncoding = encoding;
		try {
			needToEncode = CharsetUtils.testNeedToEncode(encoding);
		} catch(Exception e) {
			needToEncode = false;
		}
	}
}
