/*
 * $Id: MySQLIndexAccessor.java,v 1.19 2006/02/24 15:55:55 akabane Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.charset.CharsetUtils;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;

/**
 * mysql serverXg[WƂ^CṽCfbNXANZT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.19 $
 */
public class MySQLIndexAccessor implements IndexAccessor, MySQLInterfaceConstant {
	/** K[ */
	private static final Log log = LogFactory.getLog(MySQLIndexAccessor.class);
	/** CfbNX폜SQL */
	private PreparedStatement removeStatement;
	/** CfbNXSQL */
	private PreparedStatement searchStatement;
	/** f[^x[Xڑ */
	private Connection con;
	/** f[^x[XڑĎXbh */
	private ConnectionValidator validator;
	/** ]uCfbNXWXg */
	private MySQLInvertedIndexRegistrar registrar;
	/** ̃GR[fBO */
	private String indexTermEncoding;
	/** ꌟCGR[fBOϊKvƂ邩(true: / false:Ȃ) */
	private boolean needToEncode = false;

	/** base64 encoder/decoder */
	private final Base64 base64 = new Base64();

	/**
	 * RXgN^D
	 * @param cv f[^x[XڑĎXbh
	 */
	public MySQLIndexAccessor(ConnectionValidator cv) throws Exception {
		validator = cv;
		init();
	}
	/**
	 * ̃C^[tF[XD
	 * @throws Exception Ɏs(hCo[hłȂȂ)
	 */
	protected void init() throws Exception {
		ResourceBundle rb = ResourceBundle.getBundle("mysql");
		String jdbcDriverClass = rb.getString(PKEY_JDBC_DRIVER_CLASS);
		String connstr = rb.getString(PKEY_INDEX_CONNECT_STR);

		// f[^x[Xڑv[O쐬
		try {
			Class.forName(jdbcDriverClass);
			con = DriverManager.getConnection(connstr);

			String removeSql = rb.getString(PKEY_INDEX_REMOVE_SQL);
			String searchSql = rb.getString(PKEY_INDEX_SEARCH_SQL);

			removeStatement = con.prepareStatement(removeSql);
			searchStatement = con.prepareStatement(searchSql);
			
			// f[^x[XڑĎ̊Jn
			ConnectionValidation validation = new ConnectionValidation(con, "select count(*) from inverted_index");
			validator.add(validation);

			// ]uCfbNXWXg̍쐬
			registrar = new MySQLInvertedIndexRegistrar(con);
			registrar.start();

			// ̃GR[fBOϊKvǂeXg
			indexTermEncoding = rb.getString(PKEY_ENCODING_INDEX_TERM);
			if(StringUtils.isEmpty(indexTermEncoding) == false) {
				needToEncode = CharsetUtils.testNeedToEncode(indexTermEncoding);
			}
		} catch(Exception e) {
			// 炩̌ɂCɎsꍇ̓\[X̉sȂ
			DbUtils.closeStatement(removeStatement);
			DbUtils.closeStatement(searchStatement);
			DbUtils.closeConnection(con);
			log.error("CfbNXANZXC^[tF[X̏Ɏs:" + ExceptionUtils.stackTraceToString(e), e);
		}
	}
	/**
	 * ̃C^[tF[XɃN[YĂ邩ǂԂD
	 * @return true:N[Yς / false:܂JĂ
	 */
	public boolean isClosed() {
		return con == null;
	}
	/**
	 * ̃C^[tF[XD
	 * O\[XƂ̐ڑSmɃN[YD
	 * @throws IndexAccessException 炩̗RŃN[YɎs
	 */
	public void close() throws IndexAccessException {
		if(registrar != null) {
			registrar.shutdown();
			try {
				// Xbh̒~҂킹
				registrar.join();
			} catch(InterruptedException e) {
				// ~fꂽɂ͉eȂ̂Ŗ
			} finally {
				registrar = null;
			}
		}
	}

	/**
	 * ǉD
	 * @param digest 肷_CWFXgL[
	 * @param term o^
	 * @throws IndexAccessException 炩̗Rœo^Ɏs
	 */
	public void addTerm(String digest, Term[] term) throws IndexAccessException {
		registrar.add(digest, term);
	}

	/**
	 * ẅʒuSč폜D
	 * @param key 
	 * @return 폜ꂽ
	 */
	public Object removeTerm(String key) throws IndexAccessException {
		try {
			removeStatement.setString(1, key);
			removeStatement.executeUpdate();

			return null;
		} catch(SQLException se) {
			// SQLɎsĂĈ܂ܖ(v[OĂ邽)
			log.warn("̍폜Ɏs:" + ExceptionUtils.stackTraceToString(se), se);
			throw new IndexAccessException(se);
		}
	}
	/**
	 * ẅʒuD
	 * @param key 
	 * @return (ʒu)
	 */
	public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
		KoikeIndexResultSet kirs = new KoikeIndexResultSet();
		if(needToEncode) {
			try {
				key = CharsetUtils.encode(indexTermEncoding, key);
			} catch (Exception e) {
				// GR[fBOϊɂȂs
				log.warn("[" + key + "]̃GR[fBOϊɎs܂:" + ExceptionUtils.stackTraceToString(e));
				throw new IndexAccessException(e);
			}
		}
		double begin = System.currentTimeMillis();
		ResultSet rs = null;
		try {
			byte[] b64encoded = null;
			if(needToEncode) {
				b64encoded = base64.encode(key.getBytes("ISO-8859-1"));
			} else {
				b64encoded = base64.encode(key.getBytes());
			}
			String term = new String(b64encoded, "ISO-8859-1");		// base64encodingUS-ASCIIł͂
			searchStatement.setString(1, term);
			rs = searchStatement.executeQuery();

			int cnt = 0;
			while(rs.next()) {
				cnt++;
				long docno = rs.getLong("docno");
				String location = rs.getString("location");
				if(StringUtils.isEmpty(location)) {
					continue;
				}
				// ]uCfbNX𐶐ĕԂD
				kirs = createInvertedIndex(kirs, (int)docno, location); 
			}

			log.trace("term [" + key + "] is found in [" + cnt + "] rows.");
		} catch (Exception e) {
			log.warn("̌Ɏs:" + ExceptionUtils.stackTraceToString(e), e);
			throw new IndexAccessException(e);
		} finally {
			// \[X̉(DBڑƃXe[ggLbV͍ėp̂߂قƂ)
			DbUtils.closeResultSet(rs);
		}

		double fin = System.currentTimeMillis();
		log.trace(": " + ((fin-begin) / 1000.0) + "sec.");
		return kirs;
	}

	/**
	 * 񉻂ꂽ]uCfbNXIuWFNgɕĕԂD
	 * @param rs r܂ł̌(null:VK)
	 * @param docno ԍ
	 * @param value 񉻂ꂽʒu
	 * @return ꂽIuWFNg
	 */
	protected KoikeIndexResultSet createInvertedIndex(KoikeIndexResultSet rs, int docno, String value) {
		if(rs == null) {
			rs = new KoikeIndexResultSet();
		}
		String nodeId = "";

		// ̈ʒu̓J}؂ł
		String[] values = value.split(",");
		for(int i = 0; i < values.length; i++) {
			int pos = Integer.parseInt(values[i]);												// ʒu
			int blkno = (int)(docno / KoikeConstant.INVERTED_INDEX_BLK_SIZE);					// ubNԍ
			long documents = 1L << (long)(docno - (blkno * KoikeConstant.INVERTED_INDEX_BLK_SIZE));
			InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
			if(iidx != null) {
				documents = documents | iidx.getDocumentAvailability();
			} else {
				iidx = new InvertedIndex(nodeId, blkno, 0);
			}
			// document availabilityĐݒ肷(ʒutB^OȂ)
			iidx.setDocumentAvailability(documents, false);
			// ]uCfbNXɑ΂Ĉʒuǉ
			iidx.addLocation(new Location(nodeId, docno, pos));

			rs.addInvertedIndex(iidx);
		}

		// ʂԂ
		return rs;
	}
}
