/*
 * $Id: MySQLDocumentAccessor.java,v 1.8 2006/02/21 15:57:09 akabane Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ResourceBundle;

import org.logical_paradox.common.charset.CharsetUtils;
import org.logical_paradox.common.sql.DbUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

/**
 * mysql serverXg[WƂ^CṽhLgANZT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class MySQLDocumentAccessor implements DocumentAccessor, MySQLInterfaceConstant {
	/** vpeBt@C */
	private final ResourceBundle resource;
	/** f[^tB^ */
	private DataFilter filter;
	/** f[^x[Xڑ */
	private Connection con;
	/** f[^x[XڑĎXbh */
	private ConnectionValidator validator;
	/** Xe[gg */
	private PreparedStatement pstmt;
	/** Rec̃GR[fBO */
	private String encoding;
	/** Rec擾CGR[fBOϊKvƂ邩 */
	private boolean needToEncode = false;
	/**
	 * RXgN^D
	 * @param cv ڑ؃Xbh
	 */
	public MySQLDocumentAccessor(ConnectionValidator vc) {
		validator = vc;
		// \[Xt@Cǂݍł
		resource = ResourceBundle.getBundle("mysql");

		try {
			String jdbcDriverClass = resource.getString(PKEY_JDBC_DRIVER_CLASS);
			String connstr = resource.getString(PKEY_DOCUMENT_CONNECT_STR);
			String sql = resource.getString(PKEY_DOCUMENT_SEARCH_SQL);
			encoding = resource.getString(PKEY_ENCODING_CONTENTS);

			Class.forName(jdbcDriverClass);
			con = DriverManager.getConnection(connstr);
			pstmt = con.prepareStatement(sql);

			// f[^tB^̐
			filter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);

			// f[^x[Xڑ؃XbhɐڑĎ˗
			ConnectionValidation validation = new ConnectionValidation(con, "select count(*) from contents");
			validator.add(validation);

			// GR[fBOϊKvǂ̔
			needToEncode = StringUtils.isEmpty(encoding) ? false : CharsetUtils.testNeedToEncode(encoding);
		} catch(Exception e) {
			tearDown();
			throw new IllegalArgumentException(e.getMessage());
		}
	}
	/**
	 * wL[ɑΉhLg擾
	 * @param key L[
	 * @return 擾łhLg(null: YȂ)
	 * @throws Exception ANZXɔO
	 */
	public Document getDocument(String key) throws Exception {
		long docid = DocumentIdGenerator.getDocumentNo(key);
		Document document = null;

		synchronized(this) {
			ResultSet rs = null;
			try {
				pstmt.setLong(1, docid);

				rs = pstmt.executeQuery();
				if(rs.next()) {
					// 擾
					String sitename = rs.getString("sitename");
					String title = rs.getString("title");
					String url = rs.getString("url");
					Blob blob = rs.getBlob("contents");
					long length = blob.length();
					byte[] decompressedContents = filter.decompressContents(blob.getBytes(1L, (int)length));
					document = new Document();
					document.setDocument(
								needToEncode ?
								new String(decompressedContents, encoding) :
								new String(decompressedContents)
							);

					// Rec̑ݒ肷
					ContentsAttribute attr = new ContentsAttribute();
					attr.setSitename(sitename);
					attr.setTitle(title);
					attr.setUrl(url);
					document.setAttribute(attr);
				}
			} finally {
				// \[X̉
				DbUtils.closeResultSet(rs);
			}
		}
		return document;
	}
	/**
	 * hLg\[XƂ̐ڑ
	 * @throws Exception N[YɎsۂɔO
	 */
	public void close() throws Exception {
		tearDown();
	}
	/**
	 * ڑɃN[YĂ邩ǂԂ
	 * @return true:N[YĂ / false:N[YĂȂ
	 */
	public boolean isClosed() {
		return con != null;
	}
	/**
	 * ̃C^[tF[X̏IsȂD
	 */
	protected synchronized void tearDown() {
		DbUtils.closeStatement(pstmt);
		DbUtils.closeConnection(con);
	}
}
