/*
 * $Id: MySQLConcreteInterfaceFactory.java,v 1.4 2006/02/12 15:31:42 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss;

import java.rmi.RemoteException;
import java.util.Iterator;
import org.logical_paradox.koike.core.ConcreteInterfaceFactory;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.search.SearchConditionOptimizer;
import org.logical_paradox.koike.rss.index.MySQLDocumentAccessor;
import org.logical_paradox.koike.rss.index.MySQLIndexAccessor;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.oqs4r.OQSConnection;
import org.logical_paradox.rss.oqs4r.ObjectQueueServer;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidator;

/**
 * MySQLXg[WƂėpkoikepC^[tF[Xt@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class MySQLConcreteInterfaceFactory extends ConcreteInterfaceFactory {
	/** f[^x[XڑĎԊu */
	public static final long CONNECTION_WATCH_INTERVAL = 120 * 1000;
	/** f[^x[XڑĎXbh */
	private ConnectionValidator validator;
	/** hLgANZT */
	private DocumentAccessor documentAccessor;

	/**
	 * RXgN^D
	 * @param param p[^
	 * @throws Exception Ɏs
	 */
	public MySQLConcreteInterfaceFactory(String param) throws Exception {
		super(param);
	}
	/**
	 * t@Ng܂
	 * @throws Exception 
	 */
	public void setup() throws Exception {
		if(validator == null) {
			validator = new ConnectionValidator(CONNECTION_WATCH_INTERVAL);
			validator.start();
		}
		documentAccessor = new MySQLDocumentAccessor(validator);
	}
	/**
	 * ꂽhLgANZT𐶐ĕԂ
	 * @return ꂽhLgANZT
	 * @throws Exception ܂͏ɎsꍇɔO
	 */
	public DocumentAccessor getDocumentAccessor() throws Exception {
		return documentAccessor;
	}
	/**
	 * ꂽCfbNXANZT𐶐ĕԂ
	 * @return ꂽCfbNXANZT
	 * @throws Exception ܂͏ɎsꍇɔO
	 */
	public IndexAccessor getIndexAccessor() throws Exception {
		return new MySQLIndexAccessor(validator);
	}
	/**
	 * [gL[ɃV[PVɃANZX@𐶐ĕԂ
	 * @return Ce[^
	 */
	public Iterator getRemoteQueueIterator() throws Exception {
		// [gQƂsKvɍ쐬Ȃ悤ɂ邽߂
		// SĂ̏̃\bhŊ
		ObjectQueueServer oqs4r = (ObjectQueueServer)LookupFactory.getLookup(getInitparam()).lookup(RSSDistributedServiceRegistry.RSS_SERVID_OQS4R);
		OQSConnection con = oqs4r.getConnection();

		// [gL[QƂĂCe[^쐬ĕԂD
		Iterator it = new OQSConnectionIterator(con);
		oqs4r = null;
		return it;
	}
	/**
	 * IveB}CU[𐶐ĕԂ
	 * @return IveB}CU[
	 * @throws Exception ɔO
	 */
	public SearchConditionOptimizer getOptimizer() throws Exception {
		return null;
	}

	/**
	 * [gL[ɐڑ^CṽCe[^D
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.4 $
	 */
	class OQSConnectionIterator implements Iterator {
		/** ڑIuWFNg */
		private final OQSConnection connection;

		/**
		 * RXgN^D
		 * @param con ڑIuWFNg
		 */
		protected OQSConnectionIterator(OQSConnection con) {
			connection = con;
		}
		/**
		 * vf폜D
		 * ̑̓T|[gĂȂ̂ŗO𓊂D
		 */
		public void remove() {
			throw new UnsupportedOperationException("class OQSConnectionIterator doesn't support remove item.");
		}
		/**
		 * ̗vf邩ǂԂD
		 * @return true: / false:Ȃ
		 */
		public boolean hasNext() {
			try {
				return connection.hasNext();
			} catch (RemoteException e) {
				return false;
			}
		}
		/**
		 * ̗vfԂD
		 * @return ̗vf
		 */
		public Object next() {
			try {
				return connection.next();
			} catch (RemoteException e) {
				return null;
			}
		}
	}
}
