/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.charset;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class CharsetUtils {
    private CharsetUtils() {
    }

    public static final String encode(String encoding, String str) throws CharacterCodingException, UnsupportedEncodingException {
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer cb = CharBuffer.allocate(str.length());
        cb.put(str);
        cb.rewind();
        ByteBuffer bb = encoder.encode(cb);
        int limit = bb.limit();
        return new String(bb.array(), 0, limit, "ISO-8859-1");
    }

    public static final String decode(String encoding, String str) throws UnsupportedEncodingException {
        return new String(str.getBytes("ISO-8859-1"), encoding);
    }

    public static final boolean testNeedToEncode(String encoding) {
        if (!Charset.isSupported(encoding)) {
            return false;
        }
        Charset cs = Charset.forName(encoding);
        String systemEncoding = System.getProperty("file.encoding");
        for (String alias : cs.aliases()) {
            if (!systemEncoding.equals(alias)) continue;
            return false;
        }
        return true;
    }
}

