/*
 * $Id: MySQLSelect.java,v 1.2 2005/11/26 17:08:42 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.tools.docb.impl;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.docb.Query;
import org.logical_paradox.koike.rss.tools.docb.Select;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;

/**
 * mysqlɓf[^\[XANZXC^[tF[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class MySQLSelect implements Select {
	/** JDBChCoNX */
	public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
	/** URL_CWFXgɂNG[ */
	public static final String QUERY_BY_URL = "SELECT contents FROM contents WHERE mkey=?";
	/** hLgԍɂNG[ */
	public static final String QUERY_BY_DOCNO = "SELECT contents FROM contents WHERE cid=?";

	/** K[ */
	private static final Log log = LogFactory.getLog(MySQLSelect.class);
	/** f[^x[XڑIuWFNg */
	private Connection con;
	/** f[^tB^ */
	private DataFilter filter = null;

	/**
	 * f[^\[XɐڑD
	 * @param connstr ڑ
	 * @throws DataSourceException f[^\[XƂ̐ڑɎs
	 */
	public void open(String connstr) throws DataSourceException {
		try {
			Class.forName(JDBC_DRIVER);
			con = DriverManager.getConnection(connstr);

			// f[^tB^̍쐬
			filter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);
		} catch(Exception e) {
			log.error("JDBChCõ[hɎs܂:", e);
			throw new DataSourceException(e);
		}
	}

	/**
	 * f[^\[XƂ̐ڑ؂D
	 * @throws DataSourceException f[^\[XƂ̐ؒfɎs
	 */
	public void close() throws DataSourceException {
		if(con != null) {
			try {
				con.close();
			} catch(SQLException e) {
				// Ȃ
			} finally {
				con = null;
			}
		}
	}

	/**
	 * ₢킹sD
	 * @param q ₢킹IuWFNg
	 * @return IꂽRec
	 * @throws DataSourceException f[^\[XƂ̐ڑɎs
	 */
	public String executeQuery(Query q) throws DataSourceException {
		log.trace("RecƉĂ܂");

		String url = q.getUrl();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String contents = null;

		try {
			if(url != null && url.trim().length() > 0) {
				pstmt = con.prepareStatement(QUERY_BY_URL);
				pstmt.setString(1, filter.filterURL(url));
				log.debug(QUERY_BY_URL);
			} else {
				pstmt = con.prepareStatement(QUERY_BY_DOCNO);
				pstmt.setInt(1, q.getDocno());
				log.debug(QUERY_BY_DOCNO);
			}

			// ₢킹
			rs = pstmt.executeQuery();
			if(rs.next()) {
				log.trace("Rec̏ƉDRecfR[hĂ܂");
				Blob blob = rs.getBlob("contents");
				byte[] bstream = blob.getBytes(1L, (int)blob.length());
				// 擾łRecfR[h(gzipňkĂ邽)
				contents = new String(filter.decompressContents(bstream));
			}

			log.trace("D");
			return contents;
		} catch(Exception e) {
			throw new DataSourceException(e);
		} finally {
			// \[X̉
			try {
				if(rs != null) {
					rs.close();
				}
				if(pstmt != null) {
					pstmt.close();
				}
			} catch(SQLException e) {
				// Ȃ
			}
		}
	}

}
