/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DbmysqlContentsAccessor.java,v 1.4 2005/11/28 15:20:00 rampil Exp $
 */
package org.logical_paradox.rss.rcm.accessor.mysql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.rcm.RSSContentsMngrServiceImpl;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.simple.VirtualQueueServer;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * DbmysqlContentsAccessor
 * mysqlf[^x[XRecXg[WƂĎgpANZXC^[tF[X
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class DbmysqlContentsAccessor implements ContentsAccessor {
	/** K[ */
	private static final Log log = LogFactory.getLog(DbmysqlContentsAccessor.class);

	/** ̃C^[tF[XڑԂǂ(true:ڑ / false:ڑ) */
	private boolean activeFlag = false;
	/** DBڑIuWFNg */
	private Connection con = null;
	/** zL[T[o[ */
	private VirtualQueueServer queue = null;
	/** f[^tB^ */
	private static DataFilter dataFilter = null;

	static {
		dataFilter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);
	}

	/**
	 * RXgN^D
	 */
	public DbmysqlContentsAccessor() {
		activeFlag = false;
	}
	/**
	 * ɌĂ΂D
	 * @param initparam p[^
	 */
	public void init(String initparam) {
		open(initparam);
	}
	/**
	 * RecXg[WƐڑ
	 * @param openstr ڑ
	 */
	public synchronized void open(String openstr) {
		if(isActive()) {
			// ɃI[vĂ
			return;
		}

		if(openstr == null || openstr.trim().length() == 0) {
			throw new IllegalArgumentException();
		}

		// JDBChCõ[hƐڑ
		try {
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			con = DriverManager.getConnection(openstr);
			activeFlag = true;

			// zL[T[o[֐ڑ
			queue = new VirtualQueueServer(new RSSRCMConfig(RSSContentsMngrServiceImpl.RCM_CONF_FILENAME).getRSSDistributedServiceRegistry());
		} catch(Exception e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * Reco^
	 * @param url URL
	 * @param contents o^Rec
	 */
	public void regist(String url, String contents) {
		if(isActive() == false || url == null || url.trim().length() == 0) {
			throw new IllegalStateException();
		}
		String sql = "insert into contents values(null,?,?,?,?,?)";
		byte[] barray = new byte[0];
		try {
			barray = dataFilter.compressContents(contents.getBytes());
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		ByteArrayInputStream bi = new ByteArrayInputStream(barray);
		String sitename = "site site";
		String title = "document title";
		try {
			// wURLMD5_CWFXg擾āCRecƊ֘AtL[Ƃ
			String digest = dataFilter.filterURL(url);
			PreparedStatement pstmt = con.prepareStatement(sql);
			pstmt.setString(1, digest);						// mkey
			pstmt.setString(2, sitename);					// sitename
			pstmt.setString(3, title);						// title
			pstmt.setString(4, url);						// URL
			pstmt.setBinaryStream(5, bi, barray.length);	// contents
			pstmt.executeUpdate();
			pstmt.close();

			// ꂽR[hID擾
			sql = "select last_insert_id() as did from contents";
			Statement st = con.createStatement();
			ResultSet rs = st.executeQuery(sql);
			if(rs.next()) {
				long did = rs.getLong("did");
				// L[URL𓊓
				String documentId = DocumentIdGenerator.getDocumentId(did, digest);
				queue.enqueue(documentId);
			} else {
				log.warn("炩̌ŃhLgԍ𔭔Ԃł܂ł");
			}
		} catch(Exception e) {
			// o^łȂ
			e.printStackTrace();
		}
	}

	/**
	 * Rec폜
	 */
	public void unregist(String url) {
		if(isActive() == false || url == null || url.trim().length() == 0) {
			throw new IllegalStateException();
		}

		String sql = "delete from contents where mkey=?";
		PreparedStatement pstmt = null;
		try {
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, url);
			pstmt.executeUpdate(sql);
		} catch(SQLException se) {
			// 폜łȂ
		} finally {
			if(pstmt != null) {
				try {
					pstmt.close();
				} catch(SQLException e) {
					// Ȃ
				}
			}
		}
	}

	/**
	 * SẴRec폜
	 */
	public void unregistAll() {
		if(isActive() == false) {
			throw new IllegalStateException();
		}

		String sql = "delete from contents";
		Statement st = null;
		try {
			st = con.createStatement();
			st.executeUpdate(sql);
		} catch(SQLException se) {
			// 폜łȂ
		} finally {
			if(st != null) {
				try {
					st.close();
				} catch (SQLException e) {
					// Ȃ
				}
			}
		}
	}

	/**
	 * wURLɑΉRecԂ
	 */
	public String find(String url) {
		if(isActive() == false || url == null || url.trim().length() == 0) {
			throw new IllegalStateException();
		}

		String sql = "select * from contents where mkey=?";
		String contents = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, url);
			rs = pstmt.executeQuery(sql);
			if(rs.next()) {
				contents = rs.getString(1);
			}
		} catch(SQLException se) {
			// G[̏ꍇ͉Ȃ
		} finally {
			if(rs != null) {
				try {
					rs.close();
				} catch(SQLException e) {
					// Ȃ
				}
			}
			if(pstmt != null) {
				try {
					pstmt.close();
				} catch(SQLException e) {
					// Ȃ
				}
			}
		}
		return contents;
	}

	/**
	 * Xg[WƂ̐ڑ
	 */
	public synchronized void close() {
		if(isActive() == false) {
			throw new IllegalStateException("connector has already been closed");
		}

		try {
			// DBڑ̃N[Y
			if(con != null) {
				con.close();
				con = null;
			}

			activeFlag = false;
		} catch(SQLException se) {
			throw new IllegalStateException(se.getMessage());
		}
	}

	/**
	 * ̃C^[tF[Xgp\ǂԂ
	 */
	protected boolean isActive() {
		return activeFlag;
	}

	/**
	 * t@CiCU
	 */
	public void finalize() {
		try {
			close();
		} catch(Exception e) {
			// ȂDłȂ
		}
	}
}

// end of DbmysqlContentsAccessor.java
