/*
 * $Id: MySQLIndexAccessor.java,v 1.13 2005/12/04 06:09:07 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;

/**
 * mysql serverXg[WƂ^CṽCfbNXANZT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.13 $
 */
public class MySQLIndexAccessor implements IndexAccessor, MySQLInterfaceConstant {
	/** K[ */
	private static final Log log = LogFactory.getLog(MySQLIndexAccessor.class);

	/** MySQLf[^x[Xڑ */
	private Connection con;
	/** 폜p */
	private PreparedStatement pstmtRemove;
	/** ꌟp */
	private PreparedStatement pstmtQuery;

	/** f[^tB^ */
	private DataFilter filter;

	/** ]uCfbNXWXg */
	private MySQLInvertedIndexRegistrar registrar;

	/** base64 encoder/decoder */
	private final Base64 base64 = new Base64();

	/**
	 * RXgN^D
	 */
	public MySQLIndexAccessor() throws Exception {
		init();
	}
	/**
	 * ̃C^[tF[XD
	 * @throws Exception Ɏs(hCo[hłȂȂ)
	 */
	protected void init() throws Exception {
		ResourceBundle rb = ResourceBundle.getBundle("mysql");

		// mysqlhCo[h
		Class.forName(rb.getString(PKEY_JDBC_DRIVER_CLASS));
		con = DriverManager.getConnection(rb.getString(PKEY_INDEX_CONNECT_STR));
		con.setAutoCommit(true);

		try {
			pstmtRemove = con.prepareStatement(rb.getString(PKEY_INDEX_REMOVE_SQL));
			pstmtQuery = con.prepareStatement(rb.getString(PKEY_INDEX_SEARCH_SQL));
		} catch(SQLException se) {
			if(pstmtRemove != null) {
				pstmtRemove.close();
				pstmtRemove = null;
			}
			if(pstmtQuery != null) {
				pstmtQuery.close();
				pstmtQuery = null;
			}
			if(con != null) {
				con.close();
			}
			// \[X͍̉sȂCǗO̓X[
			throw se;
		}

		filter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);

		// ]uCfbNXWXg̍쐬
		registrar = new MySQLInvertedIndexRegistrar(con);
		registrar.start();
	}
	/**
	 * ̃C^[tF[XɃN[YĂ邩ǂԂD
	 * @return true:N[Yς / false:܂JĂ
	 */
	public boolean isClosed() {
		return con == null;
	}
	/**
	 * ̃C^[tF[XD
	 * O\[XƂ̐ڑSmɃN[YD
	 * @throws IndexAccessException 炩̗RŃN[YɎs
	 */
	public void close() throws IndexAccessException {
		if(registrar != null) {
			registrar.shutdown();
			try {
				// Xbh̒~҂킹
				registrar.join();
			} catch(InterruptedException e) {
				// ~fꂽɂ͉eȂ̂Ŗ
			} finally {
				registrar = null;
			}
		}

		// \[XƂ̐ڑN[Y
		if(con != null) {
			try {
				if(pstmtRemove != null) {
					pstmtRemove.close();
					pstmtRemove = null;
				}
				if(pstmtQuery != null) {
					pstmtQuery.close();
					pstmtQuery = null;
				}
				con.close();
				con = null;
			} catch(SQLException se) {
				throw new IndexAccessException(se);
			}
		}
	}

	/**
	 * ǉD
	 * @param digest 肷_CWFXgL[
	 * @param term o^
	 * @throws IndexAccessException 炩̗Rœo^Ɏs
	 */
	public void addTerm(String digest, Term[] term) throws IndexAccessException {
		registrar.add(digest, term);
	}

	/**
	 * ẅʒuSč폜D
	 * @param key 
	 * @return 폜ꂽ
	 */
	public Object removeTerm(String key) throws IndexAccessException {
		try {
			pstmtRemove.setString(1, key);
			pstmtRemove.executeUpdate();

			return null;
		} catch(SQLException se) {
			throw new IndexAccessException(se);
		}
	}
	/**
	 * ẅʒuD
	 * @param key 
	 * @return (ʒu)
	 */
	public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
		KoikeIndexResultSet kirs = new KoikeIndexResultSet();

		double begin = System.currentTimeMillis();
		ResultSet rs = null;
		try {
			String term = new String(base64.encode(key.getBytes()));
			pstmtQuery.setString(1, term);
			rs = pstmtQuery.executeQuery();

			int cnt = 0;
			while(rs.next()) {
				cnt++;
				long docno = rs.getLong("docno");
				String location = rs.getString("location");
				if(StringUtils.isEmpty(location)) {
					continue;
				}
				// ]uCfbNX𐶐ĕԂD
				kirs = createInvertedIndex(kirs, (int)docno, location); 
			}

			log.trace("term [" + key + "] is found in [" + cnt + "] rows.");
		} catch(SQLException se) {
			throw new IndexAccessException(se);
		} catch (Exception e) {
			throw new IndexAccessException(e);
		} finally {
			try {
				if(rs != null) {
					rs.close();
				}
			} catch(SQLException se) {
				throw new IndexAccessException(se);
			}
		}

		double fin = System.currentTimeMillis();
		log.trace(": " + ((fin-begin) / 1000.0) + "sec.");
		return kirs;
	}

	/**
	 * 񉻂ꂽ]uCfbNXIuWFNgɕĕԂD
	 * @param rs r܂ł̌(null:VK)
	 * @param docno ԍ
	 * @param value 񉻂ꂽʒu
	 * @return ꂽIuWFNg
	 */
	protected KoikeIndexResultSet createInvertedIndex(KoikeIndexResultSet rs, int docno, String value) {
		if(rs == null) {
			rs = new KoikeIndexResultSet();
		}
		String nodeId = "";

		// ̈ʒu̓J}؂ł
		String[] values = value.split(",");
		for(int i = 0; i < values.length; i++) {
			int pos = Integer.parseInt(values[i]);												// ʒu
			int blkno = (int)(docno / KoikeConstant.INVERTED_INDEX_BLK_SIZE);					// ubNԍ
			long documents = 1L << (long)(docno - (blkno * KoikeConstant.INVERTED_INDEX_BLK_SIZE));
			InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
			if(iidx != null) {
				documents = documents | iidx.getDocumentAvailability();
			} else {
				iidx = new InvertedIndex(nodeId, blkno, 0);
			}
			// document availabilityĐݒ肷(ʒutB^OȂ)
			iidx.setDocumentAvailability(documents, false);
			// ]uCfbNXɑ΂Ĉʒuǉ
			iidx.addLocation(new Location(nodeId, docno, pos));

			rs.addInvertedIndex(iidx);
		}

		// ʂԂ
		return rs;
	}
}
