/*
 * $Id: MySQLDocumentAccessor.java,v 1.5 2005/11/28 15:20:00 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ResourceBundle;

import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;
import org.logical_paradox.rss.util.DocumentIdGenerator;

/**
 * mysql serverXg[WƂ^CṽhLgANZT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class MySQLDocumentAccessor implements DocumentAccessor, MySQLInterfaceConstant {
	/** vpeBt@C */
	private final ResourceBundle resource;
	/** f[^x[Xڑ */
	private Connection con;
	/** Xe[gg */
	private PreparedStatement pstmt;
	/** f[^tB^ */
	private DataFilter filter;

	/**
	 * RXgN^D
	 */
	public MySQLDocumentAccessor() {
		// \[Xt@Cǂݍł
		resource = ResourceBundle.getBundle("mysql");

		try {
			Class.forName(resource.getString(PKEY_JDBC_DRIVER_CLASS));
			con = DriverManager.getConnection(resource.getString(PKEY_DOCUMENT_CONNECT_STR));
			pstmt = con.prepareStatement(resource.getString(PKEY_DOCUMENT_SEARCH_SQL));

			// f[^tB^̐
			filter = DataFilterFactory.getFilter(DataFilterFactory.GZIP);
		} catch(Exception e) {
			tearDown();
			throw new IllegalArgumentException(e.getMessage());
		}
	}
	/**
	 * wL[ɑΉhLg擾
	 * @param key L[
	 * @return 擾łhLg(null: YȂ)
	 * @throws Exception ANZXɔO
	 */
	public Document getDocument(String key) throws Exception {
		long docid = DocumentIdGenerator.getDocumentNo(key);
		Document document = null;

		synchronized(this) {
			pstmt.setLong(1, docid);
			ResultSet rs = null;
			try {
				rs = pstmt.executeQuery();
				if(rs.next()) {
					// 擾
					String sitename = rs.getString("sitename");
					String title = rs.getString("title");
					String url = rs.getString("url");
					Blob blob = rs.getBlob("contents");
					long length = blob.length();
					byte[] decompressedContents = filter.decompressContents(blob.getBytes(1L, (int)length));
					document = new Document();
					document.setDocument(new String(decompressedContents));

					// Rec̑ݒ肷
					ContentsAttribute attr = new ContentsAttribute();
					attr.setSitename(sitename);
					attr.setTitle(title);
					attr.setUrl(url);
					document.setAttribute(attr);
				}
			} finally {
				if(rs != null) {
					rs.close();
					rs = null;
				}
			}
		}
		return document;
	}
	/**
	 * hLg\[XƂ̐ڑ
	 * @throws Exception N[YɎsۂɔO
	 */
	public void close() throws Exception {
		tearDown();
	}
	/**
	 * ڑɃN[YĂ邩ǂԂ
	 * @return true:N[YĂ / false:N[YĂȂ
	 */
	public boolean isClosed() {
		return con == null;
	}
	/**
	 * ̃C^[tF[X̏IsȂD
	 */
	protected synchronized void tearDown() {
		if(pstmt != null) {
			try {
				pstmt.close();
			} catch(Exception e) {}
			pstmt = null;
		}
		if(con != null) {
			try {
				con.close();
			} catch(Exception e) {}
			con = null;
		}
	}
}
