/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.fsm;

import java.util.ArrayList;
import org.logical_paradox.common.fsm.ChangeStateListener;
import org.logical_paradox.common.fsm.State;
import org.logical_paradox.common.fsm.StateEvent;
import org.logical_paradox.common.fsm.Symbol;

public abstract class FiniteStateMachine {
    private final String name;
    private ArrayList finiteStates = new ArrayList();
    private ChangeStateListener changeStateListener = null;
    private State state;

    private FiniteStateMachine() {
        this.name = "no-name";
    }

    public FiniteStateMachine(String name) throws Exception {
        this.name = name;
        this.init();
    }

    public void init() throws Exception {
    }

    public void finish() throws Exception {
    }

    public void addFiniteState(State state) {
        this.finiteStates.add(state);
    }

    public boolean stepExec(Symbol symbol) {
        StateEvent e;
        if (this.changeStateListener != null) {
            e = new StateEvent(this, this.state);
            this.changeStateListener.onPreChanged(e);
        }
        this.input(symbol);
        if (this.changeStateListener != null) {
            e = new StateEvent(this, this.state);
            this.changeStateListener.onPostChanged(e);
        }
        return !this.isFiniteState();
    }

    public void execute(Symbol[] symbols) throws Exception {
        int cnt = 0;
        while (cnt < symbols.length && this.stepExec(symbols[cnt++])) {
        }
        this.finish();
    }

    public void setStateChangedListener(ChangeStateListener listener) {
        this.removeStateChangedLister();
        this.changeStateListener = listener;
    }

    public void removeStateChangedLister() {
        this.changeStateListener = null;
    }

    protected abstract void input(Symbol var1);

    protected abstract boolean isFiniteState();

    public abstract Object getResult();
}

