/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SessionManagerTest.java,v 1.1 2005/02/28 13:26:25 rampil Exp $
 */
package org.logical_paradox.common.session;

import java.util.ArrayList;
import java.util.Iterator;

import junit.framework.TestCase;

/**
 * ZbV}l[W[̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SessionManagerTest extends TestCase {

	/**
	 * Constructor for SessionManagerTest.
	 * @param arg0
	 */
	public SessionManagerTest(String arg0) {
		super(arg0);
	}
	/**
	 * ZbV̐VK쐬eXg
	 */
	public void testCreateNewSession() throws IllegalSessionStateException {
		SessionManager manager = new SessionManager();
		ArrayList sessions = new ArrayList();
		for(int i = 0; i < 100; i++) {
			sessions.add(manager.getSession());
		}

		// {ɃZbV݂Ă邩ǂmF
		for(Iterator it = sessions.iterator(); it.hasNext();) {
			Session session = (Session)it.next();
			assertEquals(true, manager.isExists(session.getSessionId()));
			// 폜
			manager.removeSession(session.getSessionId());
		}
		// 폜ꂽǂmF
		for(Iterator it = sessions.iterator(); it.hasNext();) {
			Session session = (Session)it.next();
			assertEquals(false, manager.isExists(session.getSessionId()));
		}
	}
	/**
	 * ZbV̌peXg
	 * x쐬ꂽZbVZbVIDōēx擾ł邱ƂmF
	 */
	public void testContinueSession() throws IllegalSessionStateException {
		SessionManager manager = new SessionManager();
		Session session = manager.getSession("abcdefg");

		assertFalse("abcdefg".equals(session.getSessionId()));

		Session newSession = manager.getSession(session.getSessionId());
		// CX^XԂ͂
		assertNotNull(newSession);
		assertTrue(newSession == session);
	}
	/**
	 * ZbVpeXg
	 * wZbVŖ₢킹ő݂ȂꍇAZbV͐V쐬
	 */
	public void testContinueSessionWithCreate() throws IllegalSessionStateException {
		SessionManager manager = new SessionManager();
		Session session = manager.getSession("abcdefg", true);

		assertNotNull(session);
	}
	/**
	 * ZbVpeXg
	 * wZbVŖ₢킹ő݂ȂꍇAZbV͍쐬Ȃ
	 */
	public void testContinueSessionWithoutCreate() throws IllegalSessionStateException {
		SessionManager manager = new SessionManager();
		Session session = manager.getSession("abcdefg", false);

		assertNull(session);
	}
}
