/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ByteStreamConverter.java,v 1.1 2005/09/17 17:33:44 rampil Exp $
 */
package org.logical_paradox.common.util;

/**
 * oCgXg[Ro[^
 * 낢Ȍ^̃f[^AoCgɕϊ߂肵܂
 * ͑Sbig-endianŋL^
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ByteStreamConverter {
	/**
	 * oCgɕϊ
	 * @param b ϊΏ
	 * @return ϊꂽz
	 */
	public static final byte[] convert(byte b) {
		return new byte[]{b};
	}
	/**
	 * oCgɕϊ
	 * @param s ϊΏ
	 * @return ϊꂽz
	 */
	public static final byte[] convert(short s) {
		byte a = (byte)(s & 0xff);
		byte b = (byte)((s >> 8) & 0xff);

		return new byte[]{b, a};
	}
	/**
	 * oCgɕϊ
	 * @param i ϊΏ
	 * @return ϊꂽz
	 */
	public static final byte[] convert(int i) {
		byte a = (byte)(i & 0xff);
		byte b = (byte)((i >> 8) & 0xff);
		byte c = (byte)((i >> 16) & 0xff);
		byte d = (byte)((i >> 24) & 0xff);

		return new byte[]{d,c,b,a};
	}
	/**
	 * oCgɕϊ
	 * @param l ϊΏ
	 * @return ϊꂽz
	 */
	public static final byte[] convert(long l) {
		byte a = (byte)(l & 0xff);
		byte b = (byte)((l >> 8) & 0xff);
		byte c = (byte)((l >> 16) & 0xff);
		byte d = (byte)((l >> 24) & 0xff);
		byte e = (byte)((l >> 32) & 0xff);
		byte f = (byte)((l >> 40) & 0xff);
		byte g = (byte)((l >> 48) & 0xff);
		byte h = (byte)((l >> 56) & 0xff);

		return new byte[]{h,g,f,e,d,c,b,a};
	}
	/**
	 * pCg񂩂int𕜌
	 * @param b oCg
	 * @return ꂽ
	 */
	public static int getInt(byte[] b) {
		return ((int)b[0] & 0xff) << 24 | ((int)b[1] & 0xff) << 16 | ((int)b[2] & 0xff) << 8 | ((int)b[3] & 0xff);
	}
	/**
	 * oCg񂩂long𕜌D
	 * @param b oCg
	 * @return ꂽ
	 */
	public static long getLong(byte[] b) {
		return
			((long)b[0] & 0xff) << 56 | ((long)b[1] & 0xff) << 48 | ((long)b[2] & 0xff) << 40 | ((long)b[3] & 0xff) << 32 |
			((long)b[4] & 0xff) << 24 | ((long)b[5] & 0xff) << 16 | ((long)b[6] & 0xff) << 8 | ((long)b[7] & 0xff);
	}
}
