/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: InputOutputStreamPipe.java,v 1.1 2005/05/07 02:38:41 rampil Exp $
 */
package org.logical_paradox.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * InputStreamǂݍOutputStream֏o͂pCvʂNX
 * ̓\[XInputStreamƏo͐OutputStream͓K؂Ƀobt@OĂƂ
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class InputOutputStreamPipe {
	/** ftHg̓o̓obt@TCY */
	public static int DEFAULT_BUFFER_SIZE = 16384;

	/** ̓Xg[ */
	private final InputStream in_;
	/** o̓Xg[ */
	private final OutputStream out_;
	/** obt@TCY */
	private int bufferSize_ = DEFAULT_BUFFER_SIZE;

	/**
	 * RXgN^
	 * @param in ̓Xg[
	 * @param out o̓Xg[
	 */
	public InputOutputStreamPipe(InputStream in, OutputStream out) {
		in_ = in;
		out_ = out;
	}
	/**
	 * ̓Xg[̃f[^Sďo̓Xg[֏o͂ÃXg[close
	 * @throws o͗O
	 */
	public void throughAll() throws IOException, EOFException {
		byte[] buffer = new byte[getBufferSize()];
		int readByte = -1;
		while((readByte = in_.read(buffer)) >= 0) {
			if(readByte > 0) {
				out_.write(buffer, 0, readByte);
			}
		}

		close();
	}
	/**
	 * o̓obt@TCYݒ肷
	 * @param bufsiz obt@TCY
	 */
	public void setBufferSize(int bufsiz) {
		bufferSize_ = bufsiz;
	}
	/**
	 * o̓obt@TCYԂ
	 * @return ݂̓o̓obt@TCY
	 */
	public int getBufferSize() {
		return bufferSize_;
	}
	/**
	 * o̓Xg[𗼕N[Y
	 * @throws IOException N[YɎs
	 */
	public void close() throws IOException {
		in_.close();
		out_.close();
	}
}
