/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * t@C[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class FileUtils {
	/**
	 * wlŎwoCg̃f[^o͂
	 * @param filename t@C
	 * @param length 
	 * @param data ߍރf[^
	 * @throws IOException o̓G[
	 */
	public static final void fill(String filename, int length, int data) throws IOException {
		BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(filename));

		for(int i = 0; i < length; i++) {
			bw.write(data);
		}
		bw.flush();
		bw.close();
	}
	/**
	 * w肳ꂽt@C𖖒[܂œǂݍ݁CŕԂ
	 * @param file t@C
	 * @param encoding t@C̃GR[fBO
	 * @return ǂݍ񂾃t@C̓e
	 * @throws IOException t@CANZXɎsꍇɔO
	 */
	public static final String readFully(File file, String encoding) throws IOException {
		BufferedReader br = null;
		if(encoding == null) {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
		} else {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(file), encoding));
		}

		StringBuffer sb = new StringBuffer();
		String line = null;
		
		while((line = br.readLine()) != null) {
			sb.append(line);
		}

		br.close();
		
		return sb.toString();
	}
	/**
	 * w肳ꂽt@C𖖒[܂œǂݍ݁CoCgŕԂD
	 * @param file t@C
	 * @return ǂݍ񂾃t@C̓e
	 * @throws IOException t@CANZXɎsꍇɔO
	 */
	public static final byte[] binaryReadFully(File file) throws IOException {
		byte[] buffer = new byte[(int)file.length()];
		FileInputStream fi = new FileInputStream(file);
		int len = fi.read(buffer);
		if(len < buffer.length) {
			throw new IOException();
		}
		fi.close();

		return buffer;
	}
	/**
	 * w肳ꂽt@C𖖒[܂œǂݍ݁CŕԂ
	 * @param filename t@C
	 * @param encoding t@C̃GR[fBO
	 * @return ǂݍ񂾃t@C̓e
	 * @throws IOException t@CANZXɎsꍇɔO
	 */
	public static final String readFully(String filename, String encoding) throws IOException {
		return readFully(new File(filename), encoding);
	}
	/**
	 * pXA
	 * @param pathElements AΏۂ̃pXGg
	 * @return K؂ɘAꂽ
	 */
	public static final String concat(String[] pathElements) {
		if(pathElements == null || pathElements.length == 0) {
			return "";
		}
		StringBuffer sb = new StringBuffer();

		for(int i = 0; i < pathElements.length; i++) {		
			if(i > 0 && File.separator.equals("" + sb.charAt(sb.length()-1)) == false) { 
				sb.append(File.separator);
			}
			sb.append(pathElements[i]);
		}

		return sb.toString().trim();
	}
}
