/*
 * $Id: CharsetUtils.java,v 1.1 2005/11/24 15:20:14 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.charset;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

/**
 * LN^Zbgϊ[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class CharsetUtils {
	/**
	 * w̃GR[fBOɕϊԂD
	 * @param encoding ϊ̃GR[fBO
	 * @param str ̕
	 * @return ϊꂽ
	 * @throws UnsupportedEncodingException T|[g̃LN^Zbgw肳ꂽ
	 */
	public static final String encode(String encoding, String str) throws CharacterCodingException, UnsupportedEncodingException {
		Charset charset = Charset.forName(encoding);
		CharsetEncoder encoder = charset.newEncoder();
		CharBuffer cb = CharBuffer.allocate(str.length());
		cb.put(str);
		cb.rewind();
		ByteBuffer bb = encoder.encode(cb);
		int limit = bb.limit();
		return new String(bb.array(), 0, limit, "ISO-8859-1");
	}
	/**
	 * w̃GR[fBOŃGR[hĂ镶ftHgGR[fBOɕϊD
	 * @param encoding ϊ̃GR[fBO
	 * @param str ϊꂽ
	 * @return ꂽ
	 * @throws UnsupportedEncodingException T|[g̃LN^Zbgw肳ꂽ
	 */
	public static final String decode(String encoding, String str) throws UnsupportedEncodingException {
		return new String(str.getBytes("ISO-8859-1"), encoding);
	}
}
