/**
 * $Id: ReadWriteBufferTest.java,v 1.1 2005/04/30 14:40:24 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.net;

import junit.framework.TestCase;

/**
 * ReadWriteBufferNX̃eXgR[h
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ReadWriteBufferTest extends TestCase {
	/**
	 * ̈gȂԂ̓ǂݏeXg
	 */
	public void testReadWriteWithoutExpand() {
		ReadWriteBuffer rwb = new ReadWriteBuffer();
		rwb.write("ABCDEFG");
		byte[] buf = new byte["ABCDEFG".length()];

		// 7oCg̓ǂݍ݂ɐ邩ǂ
		assertEquals(7, rwb.read(buf));
		// 擾oCg𕶎ɕϊĈv邩ǂ
		assertEquals("ABCDEFG", new String(buf));
	}
	/**
	 * obt@̍Ō܂œǂݍłɓǂݍ񂾏ꍇ̃G[̃eXg
	 * (1) obt@ɉȂ̂ɂȂread()
	 * (2) obt@ɂςłԂread()
	 */
	public void testReadError() {
		ReadWriteBuffer rwb = new ReadWriteBuffer(10);
		// ȂԂłȂread()
		assertEquals(-1, rwb.read());

		rwb.write(new byte[]{1,2,3,4,5});
		// 5܂ł͐ǂ߂
		for(int i = 0; i < 5; i++) {
			assertTrue(-1 != rwb.read());
		}
		// 6ڂ͓ǂݍ݂Ɏs
		assertEquals(-1, rwb.read());

		byte[] buf = new byte[4];
		rwb.write(new byte[]{11,12});
		// 2oCgǉ̂2oCgǂ߂
		assertEquals(2, rwb.read(buf));
		assertEquals(11, buf[0]);
		assertEquals(12, buf[1]);
		assertEquals(0, buf[2]);				// i[Ȃ
		assertEquals(0, buf[3]);				// i[Ȃ

		// ɓǂƂƃ[hG[
		assertEquals(-1, rwb.read());
	}
	/**
	 * ̈g̃eXg
	 */
	public void testWriteWithExpand() {
		ReadWriteBuffer rwb = new ReadWriteBuffer(4);
		// ̈g鏑(2blockǉ)
		rwb.write("123456789");
		byte[] buf = new byte["123456789".length()];
		assertEquals(9, rwb.read(buf));
		assertEquals("123456789", new String(buf));
	}
	/**
	 * ̈k̃eXg
	 */
	public void testReadWithReduce() {
		ReadWriteBuffer rwb = new ReadWriteBuffer(4);
		// 5قǃeXgJԂ
		for(int i = 0; i < 5; i++) {
			// ̈g𔭐
			rwb.write("12345678901234567890");
			// Kɓǂݍ(̈kx)
			byte[] buf = new byte[13];
			assertEquals(13, rwb.read(buf));
			assertEquals("1234567890123", new String(buf));
			// 
			rwb.write("abcdefg");
			// Sǂݍ
			buf = new byte[14];
			assertEquals(14, rwb.read(buf));
			assertEquals("4567890abcdefg", new String(buf));
		}
	}
}
