/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.thread;

import java.util.*;

/**
 * [hCgbNIuWFNg
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class ReadWriteLock {
	private Set _readerThreads = Collections.synchronizedSet(new HashSet());
	private Set _writerThreads = Collections.synchronizedSet(new HashSet());

	public ReadWriteLock() {
	}
	/**
	 * ǂݍ݃bN擾<br>
	 * w肳ꂽԂ҂C𒴂ꍇInterruptedException
	 * 
	 * @param msec ҂(0:SubN)
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void beginRead(int msec) throws InterruptedException {
		while(_writerThreads.size() > 0) {
			wait(msec);
		}
		_readerThreads.add(Thread.currentThread());
	}
	/**
	 * ݃bN擾<br>
	 * w肳ꂽԂ҂C𒴂ꍇInterruptedException
	 * 
	 * @param msec ҂(0:SubN)
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void beginWrite(int msec) throws InterruptedException {
		// ĂXbhɑ݂邩CNǂłꍇ͒~
		while(_writerThreads.size() > 0 || _readerThreads.size() > 0) {
			wait(msec);
		}
		_writerThreads.add(Thread.currentThread());
	}
	/**
	 * ǂݍ݃bN
	 * 
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void endRead() throws InterruptedException {
		// ݂̃XbhbN擾҂̈ꗗɑ݂ꍇCbN̉{
		if(_readerThreads.contains(Thread.currentThread())) {
			_readerThreads.remove(Thread.currentThread());
			notifyAll();
		}
	}
	/**
	 * ݃bN
	 * 
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void endWrite() throws InterruptedException {
		// ݂̃XbhbN擾҂̈ꗗɑ݂ꍇCbN̉{
		if(_writerThreads.contains(Thread.currentThread())) {
			_writerThreads.remove(Thread.currentThread());
		}
		notifyAll();
	}
	/**
	 * ǂݍ݃bN擾<br>
	 * bN擾ł܂łƑ҂
	 * 
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void beginRead() throws InterruptedException {
		beginRead(0);
	}
	/**
	 * ݃bN擾<br>
	 * bN擾ł܂łƑ҂
	 * 
	 * @throws InterruptedException ̌Ŏsꍇ
	 */
	public synchronized void beginWrite() throws InterruptedException {
		beginWrite(0);
	}
	/**
	 * ݂̃XbhLĂ郍bNSĉ
	 * 
	 * @throws InterruptedException
	 */
	public synchronized void release() throws InterruptedException {
		endWrite();
		endRead();
	}
}
