/**
 * $Id: ReadWriteBuffer.java,v 1.1 2005/04/30 14:40:08 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.net;

/**
 * ǂݏobt@
 * ǂݍ݂Ə݂ɂłobt@
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ReadWriteBuffer {
	/** ftHg̃ubNTCY(4K) */
	public static final int DEFAULT_BLOCK_SIZE = 4096;
	/** obt@ */
	private byte[] buffer;
	/** ubNTCY(̈gɒǉobt@̃oCg) */
	private int blocksize;

	/** ǂݍݎ̃|C^ */
	private int readp = 0;
	/** ݎ̃|C^ */
	private int writep = 0;

	/**
	 * RXgN^
	 */
	public ReadWriteBuffer() {
		blocksize = DEFAULT_BLOCK_SIZE;
		buffer = new byte[blocksize];
	}
	/**
	 * RXgN^
	 * @param bs
	 */
	public ReadWriteBuffer(int bs) {
		blocksize = bs;
		buffer = new byte[blocksize];
	}
	/**
	 * obt@1oCg
	 * @param b ރf[^
	 */
	public void write(byte b) {
		write((int)b & 0xff);
	}
	/**
	 * obt@1oCg
	 * @param i ރf[^
	 */
	public void write(int i) {
		expand();
		buffer[writep++] = (byte)(i & 0xff);
	}
	/**
	 * obt@ɔz̃f[^
	 * @param b ރf[^
	 */
	public void write(byte[] b) {
		for(int i = 0; i < b.length; i++) {
			write(b[i]);
		}
	}
	/**
	 * obt@ɕ
	 * @param str ޕ
	 */
	public void write(String str) {
		write(str.getBytes());
	}
	/**
	 * obt@1oCgǂݍŕԂ
	 * ǂݍނ̂ȂꍇC-1ԂD
	 * ǂݍ݊ƓɁCǂݍݗp̃|C^1oCgi߂
	 * @return obt@ǂݍ܂ꂽf[^(-1: Ȃ)
	 */
	public int read() {
		reduce();
		if(readp == writep) {
			return -1;
		} else {
			return (int)buffer[readp++] & 0xff;
		}
	}
	/**
	 * obt@f[^ǂݍŔzɊi[
	 * őŔz̃TCYǂݍŕԂ
	 * @param bf obt@
	 * @return ۂɊi[ꂽf[^(P:oCg)
	 */
	public int read(byte[] bf) {
		int p = 0;
		for(int i = 0; i < bf.length; i++) {
			int d = read();
			if(d < 0) {
				// ȏǂݍނ̂Ȃꍇ
				return i;
			} else {
				bf[i] = (byte)(d & 0xff);
			}
		}
		// z̃TCY̓ǂݍ݂ɐꍇ
		return bf.length;
	}
	/**
	 * ̈g
	 */
	protected void expand() {
		if(writep == buffer.length) {
			// ރXy[XȂꍇC̈gs
			byte[] newBuffer = new byte[buffer.length + blocksize];
			System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
			buffer = newBuffer;
		}
	}
	/**
	 * gp̈kăobt@č\
	 */
	protected void reduce() {
		// 3ubNȏ̋󂫗̈悪łĂꍇC̈k
		if(readp >= blocksize * 3) {
			// ̈k
			byte[] newBuffer = new byte[buffer.length - blocksize * 3];
			System.arraycopy(buffer, blocksize * 3, newBuffer, 0, buffer.length - blocksize * 3);
			buffer = newBuffer;
			// read/write|C^␳
			readp -= blocksize * 3;
			writep -= blocksize * 3;
		}
	}
}

