/*-
 * Copyright (C) 2008 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the Speecys Corporation.
 * 4. Neither the name of The Speecys Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE SPEECYS CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE CORPORATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __LIBLED_H__
#define __LIBLED_H__
#include <stdbool.h>
#include <sys/types.h>
#include "rs485devs.h"

#define GET_e_LedBoardID(offset)	(offset + BREST_LED)
#define GET_e_LedBoardID_OFFSET(id)	(id - BREST_LED)

#define	LED_DATA_LEN	(int)(LED_ROW * LED_COLUMN / (8 / LED_PIXEL_DEPTH_BIT))
#define LED_PIX_IN_BYTE	(int)(CHAR_BIT / LED_PIXEL_DEPTH_BIT)
#define LED_ROW					5
#define LED_COLUMN				12

/**
 * variables, structur declaration
 */
enum e_LedBoardID	{BREST_LED = rs485ID_LED_BREST, LEFT_LED, RIGHT_LED
			, HEAD_LED, LED_BROADCAST = 254, NUM_e_LedBoardID = 3};
enum e_LedSwFunc	{GET_SW_INF, CLR_AND_GET_SW_INF};
enum e_LedSwAlign	{LedSwAlign_BRight, LedSwAlign_BCent, LedSwAlign_BLeft,
			    LedSwAlign_RThumb = 0, LedSwAlign_RLittle,
			    LedSwAlign_LLittle= 0, LedSwAlign_LThumb,
			    NUM_PUSH_SWITCH_ON_LED = 3};
enum e_LedColorCode {LED_BLANK, LED_RED, LED_GREEN
					, LED_PIXEL_DEPTH_BIT = 2};
enum e_ledPattern {
	BLANK
	, SL_STRIPE_MIX1, SL_STRIPE_MIX2, 	DUAL_DIA_MIX, CENT_CIRCLE_MIX
	, CHECKER_MIX1, CHECKER_MIX2
	, RIPPLE_MIX1st, RIPPLE_MIX2nd, RIPPLE_MIX3rd, RIPPLE_MIX4th
	, INVASION_MIX1st, INVASION_MIX2nd, INVASION_MIX3rd
	, INVASION_MIX4th, INVASION_MIX5th, INVASION_MIX6th
	, INVASION_MIX7th, INVASION_MIX8th, INVASION_MIX9th
	, INVASION_MIX10th
	, MESURINGWORM1st, MESURINGWORM2nd, MESURINGWORM3rd
	, MESURINGWORM4th, MESURINGWORM5th, MESURINGWORM6th
	, MESURINGWORM7th, MESURINGWORM8th, MESURINGWORM9th
	, MESURINGWORM10th
	, OK_MARK, NG_MARK, OK__NG_MARK

	, NUM_e_ledPattern
};


struct ledSwitchInf {
    uint16_t contTimes;
    uint16_t pushCnt;
};

/**
 * prototype declaration
 */
void initLedPtn(void);
bool ledPixelCheck(int row, int column);
size_t editLedDispReq(enum e_LedBoardID ledId, const u_char *pat, u_char *buf
    , size_t bLen);
size_t editLedDispFixpat(enum e_LedBoardID ledId, enum e_ledPattern pat
    , /*@out@*/u_char *buf, size_t bLen);
/**
 * set LED data, should call editLedDispReq() after this func
 */
void ledPset(int row, int clm, enum e_LedColorCode col, u_char *pat);
void ledVertLineDisp(int clm, enum e_LedColorCode col, u_char *pat);
/**
 * display speaker volume level
 * @param lvl
 */
void led_VolLevel(enum e_LedBoardID id, int lvl);
void notifyLedDisp(enum e_LedBoardID id);

#endif	//__LIBLED_H__
