/*-
 * Copyright (C) 2008 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the Speecys Corporation.
 * 4. Neither the name of The Speecys Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE SPEECYS CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE CORPORATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "libaccelSensor.h"

static const u_int ThSht = 9;

/**
 * set acceleration sensor thresh-hold value for 'ReqEventHndl'
 *
 * return encode value of x, y, z axis thresh-hold
 */
uint32_t
setAccelTH(
    u_short th[NUM_accElem]	/** thresh-hold by axis	*/
)
{
    uint32_t ret = 0;
    enum accElem elm ;

    for (elm = ElmX; elm < NUM_accElem; elm++) {
	ret |= (uint32_t)th[elm] << (ThSht * elm);
    }

    return ret;
}

/**
 * get acceleration sensor thresh-hold value in 'ReqEventHndl'
 *
 * return decode value
 */
void
getAccelTH(
    uint32_t thDec,	/** encoded thresh-hold value	*/
    u_short th[NUM_accElem]	/** decode value store buffer	*/
)
{
    const u_short mask = (u_short)(1 << ThSht) - 1;
    enum accElem elm;

    for (elm = ElmX; elm < NUM_accElem; elm++) {
	th[elm] = (u_short)((thDec >> (ThSht * elm)) & mask);
    }
}
