#ifndef __myu_dynamic_string_H__
#define __myu_dynamic_string_H__

#include <stdio.h>



//	NX錾
template <typename T> class myu_dynamic_ary
{
protected:
	typename T* m_p;
	int m_size;
public:
	myu_dynamic_ary(){ m_p=NULL; m_size=0; }
	myu_dynamic_ary( int size ) : myu_dynamic_ary(){ alloc(size); }
	virtual ~myu_dynamic_ary(){ release(); }

	//	J
	void release(){ SAFE_DELETE_ARY(m_p); m_size=0; }
	void free(){ release(); }

	bool alloc(int size){
		release();

		m_p = new typename T[size];
		if ( m_p == NULL )
			return false;
		m_size = size;
		MslZeroMemory( m_p, m_size );
		return true;
	}
	bool realloc(int size){
		typename T* p_old = m_p;
		if ( alloc(size) == false )
			return false;
		memcpy(m_p, p_old);
		SAFE_DELETE_ARY(p_old);
		return true;
		/*typename T* pNew = new typename T[size];
		if ( pNew == NULL )
			return false;
		m_size = size;
		MslZeroMemory( m_p, m_size );
		return true;*/
	}

	typename T* get(){ return m_p; };
	int size(){ return size; }
};



//	NX錾
class myu_dynamic_string : public myu_dynamic_ary<char>
{
public:
	
};

NSMSL_START
typedef ::myu_dynamic_string dynamic_string;
NSMSL_END

#endif//__myu_dynamic_string_H__