#ifndef __MYU_WINDOWS_LIBRARY__mwlfile_H__
#define __MYU_WINDOWS_LIBRARY__mwlfile_H__

#include "mwlcommon.h"
#include <shellapi.h>
/*#include <string>
#include <vector>
#include <windows.h>*/
#include "mwlmsg.h"	// GetFormatMessage
#include "MwlFileUtil.h"

#define MWL_DIRFILES_TOPFILEONLY	(0x00)
#define MWL_DIRFILES_INCDIR			(0x01)
#define MWL_DIRFILES_INC_SUBDIR		(0x02)
#define MWL_DIRFILES_ALLFILES		(0x02)

namespace mwl{

//	t@CXg擾
BOOL GetFileList( vector<string> &filelist, const char* szTargetDir, BOOL bIncludeDir=FALSE, BOOL bRecursive=TRUE );
BOOL GetFindDatas( vector<WIN32_FIND_DATA> &fdlist, const char* szTargetDir, BOOL bIncludeDir=FALSE );

//	pX擾n
const char* GetThisModuleDir( LPTSTR lpFilename, DWORD nSize );	//	Ō\͖ŕԂ܂
inline const char* GetThisModuleDir()	//	Ō\͖ŕԂ܂
{
	static char work[MAX_PATH+1];
	return GetThisModuleDir( work, sizeof(work) );
}
inline const char* GetFullPath( const char* szFile, char* szFullPathOut, int nBufSize )
{
	//	ɃtpX̏ꍇ
	if ( strchr( szFile, ':' ) != NULL )
	{
		safe_strcpy( szFullPathOut, szFile, nBufSize );
		return szFullPathOut;
	}

	GetThisModuleDir( szFullPathOut, nBufSize );
	if ( get_last_char(szFullPathOut) != '\\' )
		safe_strcat( szFullPathOut, "\\", nBufSize );
	safe_strcat( szFullPathOut, szFile, nBufSize );
	return szFullPathOut;

/*	safe_strcpy( szFullPathOut, szFile, nBufSize );
	return GetThisModuleDir( szFullPathOut + strlen(szFullPathOut), nBufSize - strlen(szFullPathOut) ); */
}
inline const char* GetFullPath( const char* szFile ){
	static char work[MAX_PATH+1];
	return GetFullPath( szFile, work, sizeof(work) );
}
#define _FULLPATH(FILE)	GetFullPath(FILE)

inline void SetCurrentDirectoryThis(){
	char work[MAX_PATH+1];
	GetThisModuleDir( work, sizeof(work) );
	SetCurrentDirectory(work);
}

/*	MSLֈړ
//	gq
inline const char* GetExt( const char* szFromFile )
{
	const char* pWork = strrchr( szFromFile, '\\' );
	if ( pWork == NULL )
		pWork = szFromFile;
	//const char* pExt = strrchr( szFromFile, '.' );
	const char* pExt = strrchr( pWork, '.' );
	if ( pExt == NULL )
		return NULL;
	return pExt+1;
}
inline const char* GetExt2( const char* szFromFile )
{
	const char* pWork = strrchr( szFromFile, '\\' );
	if ( pWork == NULL )
		pWork = szFromFile;
	//const char* pExt = strrchr( szFromFile, '.' );
	const char* pExt = strrchr( pWork, '.' );
	if ( pExt == NULL )
		return "";
	return pExt+1;
}
char* GetNoExt( const char* szFile, char* szOutNotExt, int nBufSize );
inline const char* GetNoExt( const char* szFile ){
	static char work[MAX_PATH+1];
	return GetNoExt( szFile, work, sizeof(work) );}

//	gq
const char* RpcExt( const char* szFromFile, char* szToFile, int nBufSize, const char* szNewExt );
inline char* EraseExt( char* szFile ){
	char* pExt = strrchr( szFile, '.' );
	if ( pExt != NULL )
		*pExt = '\0';
	return szFile;
}
*/

//	IsDirectoryn
inline BOOL IsAttrDir( DWORD dwAttrCode ){
	if ( dwAttrCode & FILE_ATTRIBUTE_DIRECTORY )
		return TRUE;
	else
		return FALSE;
}
inline BOOL IsDirectory( const char* szFile ){
	DWORD ret = GetFileAttributes( szFile );
	if ( IsAttrDir(ret) )
		return TRUE;
	else
		return FALSE;
}
inline BOOL IsFile( const char* szFile ){ return BOOL_REVERSE( IsDirectory(szFile) ); }
inline BOOL IsDirectory( const char* szFile, BOOL *pbRetIs ){
	DWORD dwRetCode = GetFileAttributes( szFile );
	GetFormatMessage(GetLastError());
	if ( dwRetCode == -1 )
		return FALSE;

	if ( IsAttrDir(dwRetCode) )
		*pbRetIs = TRUE;
	else
		*pbRetIs = FALSE;
	return TRUE;
}
inline BOOL IsFile( const char* szFile, BOOL *pbRetIs ){
	BOOL ret = IsDirectory( szFile, pbRetIs );
	*pbRetIs = BOOL_REVERSE( *pbRetIs );
	return ret;
}

inline BOOL IsExistFile( const char* szPath ){
	if ( exist_file(szPath) )
		return TRUE;
	else
		return FALSE;
}

inline BOOL IsExistDir( const char* szPath ){ return IsExistFile(szPath); }
inline BOOL IsExistDirectory( const char* szPath ){ return IsExistFile(szPath); }

/*
char* CutDirPath( const char* szFileFullPath, char* szOutDirPath, int nBufSize );
inline const char* CutDirPath( const char* szFileFullPath ){
	static char work[MAX_PATH+1];
	return CutDirPath( szFileFullPath, work, sizeof(work) );}
*/

/*	MSLֈړ
char* CutDirName( const char* szFilePath, char* szOutDir, int nBufSize );
inline char* CutDirName( const char* szFilePath ){
	static char work[MAX_PATH+1];
	return CutDirName( szFilePath, work, sizeof(work) );
}

char* CutFileName( const char* szFilePath, char* szOutFileName, int nBufSize );
inline char* CutFileName( const char* szFilePath ){
	static char work[MAX_PATH];
	return CutFileName( szFilePath, work, sizeof(work) );
}
*/

//BOOL DeleteDirectory(LPCTSTR lpPathName);

inline void CallXcopy( const char* szFrom, const char* szTo ){
	system_ex( "xcopy \"%s\" \"%s\" /e /y /i", szFrom, szTo );}


//	fBNg폜
BOOL CleanBlankDirectory( const char* szTargetDir, BOOL bIsDeleteThis=FALSE );









int GetDragQueryFiles( HDROP hDrop, vector<string> &filesOut );
inline int HdropToVctArray( HDROP hDrop, vector<string> &filesOut ){
	return GetDragQueryFiles( hDrop, filesOut ); }

BOOL GetFileList( vector<string> &filelist, const char* szTargetDir, DWORD dwOption=0 );
inline BOOL GetDirFiles( vector<string> &filelist, const char* szTargetDir, DWORD dwOption=0 ){
	return GetFileList( filelist, szTargetDir, dwOption ); }
inline BOOL GetDirAllFiles( vector<string> &filelist, const char* szTargetDir ){
	return GetFileList( filelist, szTargetDir, MWL_DIRFILES_INC_SUBDIR ); }

BOOL CopyDirectory( const char* szFrom, const char* szTo );

string& PathLastYenedString( string &str );
char* DeleteRedundancyYen( char *szStr, int nStrBufSize );

//	ċAIȃfBNg̐
#include <imagehlp.h>
#pragma comment(lib, "imagehlp.lib")
inline BOOL CreateDirectoryR( const char* szDirectory )
{
	//	Ō\tĂKv邻B
	char work[MAX_PATH+1];
	SAFE_STRCPY_AS( work, szDirectory );
	if ( get_last_char(work) != '\\' )
		SAFE_STRCAT_AS( work, "\\" );

	//	֐Ŏghc
	return MakeSureDirectoryPathExists( work );
}



//	JgfBNgLNX
//	Restor()ĂяoAfXgN^ɂăJgfBNgB
//	fXgN^ɂăJgfBNĝLZɂCancel()ĂяoB
class CCurDirRestorer
{
private:
	char m_szBkupPath[MAX_PATH+1];
public:
	CCurDirRestorer(){
		ZeroMemory(m_szBkupPath,sizeof(m_szBkupPath));
		GetCurrentDirectory( sizeof(m_szBkupPath), m_szBkupPath );
	}
	virtual ~CCurDirRestorer(){ Restore(); }
	//void Restore(){ if ( *m_szBkupPath != 0 ){ SetCurrentDirectory( m_szBkupPath ); } } <- ʂɃ`FbNȂˁH
	void Restore(){ SetCurrentDirectory( m_szBkupPath ); }
	void Cancel(){ ZeroMemory(m_szBkupPath,sizeof(m_szBkupPath)); }
};


}//namespace mwl

#endif//__MYU_WINDOWS_LIBRARY__mwlfile_H__
