/*
	ŋ̗ : Mersenne Twister

  -----------------------------------------------------------------

   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.                          

   Any feedback is very welcome.
   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
*/

#ifndef __MglMtRand_H__
#define __MglMtRand_H__

#include <windows.h>				//	timeGetTime()p
#include <mmsystem.h>				//	timeGetTime()p
#pragma comment(lib,"winmm.lib")	//	timeGetTime()p

//	Mersenne Twister ̊֐ vg^Cv錾 -> Jn
void init_genrand(unsigned long s);
void init_by_array(unsigned long init_key[], int key_length);
unsigned long genrand_int32(void);
long genrand_int31(void);
double genrand_real1(void);
double genrand_real2(void);
double genrand_real3(void);
double genrand_res53(void);
//	Mersenne Twister ̊֐ vg^Cv錾 -> I


//	srand()ƂقړlɁB
inline void mtsrand( unsigned long nSeed ){ init_genrand( nSeed ); }
inline void MtSRand( unsigned long nSeed ){ init_genrand( nSeed ); }
inline void MyuSRand( unsigned long nSeed ){ init_genrand( nSeed ); }

//	srand()ƂقړlɁBȗŁBtimeGetTime()gď܂B
inline void mtsrand(){ MtSRand(timeGetTime()); }
inline void MtSRand(){ MtSRand(timeGetTime()); }
inline void MyuSRand(){ MtSRand(timeGetTime()); }

//	rand()ƂقړlɁB
extern bool bMslInitRand;
inline unsigned long mtrand(){
	if ( bMslInitRand == false )
		mtsrand();
	bMslInitRand = true;
	return genrand_int32();
}
inline unsigned long MtRand(){ return mtrand(); }
inline unsigned long MyuRand(){ return mtrand(); }



/*
	* XMT̊֐gꍇ͈ȉB

  -----------------------------------------------------------------

	{ Fhttp://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/MT2002/readme-mt-jp.html


	̃R[hMersenne Twister[@łB
	2^19937-1ŁA623ϓzۏႳ܂B
	2002N1ɉǂ܂B 

	1.	F
		̏[`Iׂ܂B
		ǂ炩́AgpOɂȂ炸ĂяoȂƂȂ܂B 

	Einit_genrand(seed)ł́ACӂ̕Ȃꃏ[h
	@V[hƂė^邱Ƃł܂i0ł܂܂jB 
	Einit_by_array(init_key, key_length)ł́A Ȃ[h
	@zinit_keyɊi[ꂽ V[hƂė^邱Ƃł܂B
	@key_length́A z̓牽[hڂ܂łV[hƂ邩w肵܂B
	@z̒́A1ȏCӂłB 

	2.	F
		L̓֐̂ꂩpďÃ^Cv
		[gpł܂B 

	Egenrand_int32() Ȃ32rbg 
	Egenrand_int31() Ȃ31rbg 
	Egenrand_real1() l[0,1] (32rbgx). 
	Egenrand_real2() l[0,1) (32rbgx). 
	Egenrand_real3() l(0,1) (32rbgx). 
	Egenrand_res53() l[0,1) (53rbgx). 

	ŁA[0,1]0,1܂ށA[0,1)0͊܂ނ1͊܂܂ȂAȂǂ\܂B
*/

#endif//__MglMtRand_H__