#ifndef __MYU_STANDARD_LIBRARY__mslfile2_H__
#define __MYU_STANDARD_LIBRARY__mslfile2_H__

#include "mslstr2.h"

namespace msl
{
	bool FileStrRpc( const char* szFile, vector<string> &rpcFromList, vector<string> &rpcToList, int nBufSize=-1 );
	bool FileStrRpc( const char* szFile, CStrRpcList &rpcList, int nBufSize=-1 );
}//namespace msl



class CMyuFilePath {
private:
	std::string m_strFilePath;
	std::string m_strDirPathWork;
	std::string m_strNoExtWork;
public:
	CMyuFilePath(){}
	CMyuFilePath(const char* szFilePath){ m_strFilePath = szFilePath; }
	void SetFilePath(const char* szFilePath){ m_strFilePath = szFilePath; }

	/*void AppendFileName(const char* szFileName){
	}*/
	const char* GetExtIncDot(){
		return strchr(m_strFilePath.c_str(), '.');
	}
	const char* GetExtNoDot(){
		const char *p = GetExtIncDot();
		return p == NULL ? NULL : p+1;
	}
	const char* GetExt(){ return GetExtNoDot(); }
	const char* GetFilename(){
		const char *p = strchr(m_strFilePath.c_str(), '\\');
		return p == NULL ? m_strFilePath.c_str() : p+1;
	}

	const char* GetDirPath(){
		m_strDirPathWork = m_strFilePath;
		//char *p = strchr(m_strDirPathWork.c_str(), '\\');
		char *p = (char*)strchr(m_strDirPathWork.c_str(), '\\'); // VC++2005Ή
		if ( p != NULL )
			*p = '\0';
		return m_strDirPathWork.c_str();
	}
	const char* GetNoExtFilename(){
		m_strNoExtWork = GetFilename();
		//char *p = strchr(m_strNoExtWork.c_str(), '.');
		char *p = (char*)strchr(m_strNoExtWork.c_str(), '.'); // VC++2005Ή
		if ( p != NULL )
			*p = '\0';
		return m_strNoExtWork.c_str();
	}
	bool IsExt(const char* szExtIncDot){
		if ( strcmp(GetExt(),szExtIncDot) == 0 )
			return true;
		else
			return false;
	}

	//	t@CTCY擾
	long GetFileSize(){ return msl::get_filesize(m_strFilePath.c_str()); }
	long GetSize(){ return GetFileSize(); }

	//	t@C̑ݗL
	bool IsExist(){ return msl::exist_file(m_strFilePath.c_str()); }
};

//////////////////////////////////
//
//	NXmɂb...

#include "MyuCharbuf.h"

//	NX錾
class CMyuFileMemory
{
private:
	CMyuCharbuf m_buf;

public:
	//	RXgN^EfXgN^
	CMyuFileMemory(){}
	virtual ~CMyuFileMemory(){}

	bool Read( const char* szFile );
	bool Write( const char* szFile );

	//char* 
};

#endif//__MYU_STANDARD_LIBRARY__mslfile2_H__
