#ifndef __MyuIniReader_H__
#define __MyuIniReader_H__

#pragma warning( disable : 4786 ) // VC ł̌x菜܂B
#include <string>
#include <map>

#define VALUE_BUF_SIZE		(1024)
#define SECNAME_BUF_SIZE	(128)
#define VALNAME_BUF_SIZE	(128)

//	NX錾
class CMyuIniReader
{
protected:
	std::string m_strIniPath;

	//	LbV
	std::map<std::string,std::string> m_cache;

	//	\bh
	static const char* GetL( const char* szName );
	static const char* GetR( const char* szName );
	static const char* GetIniFullPath( const char* szIniFile, char* szOutFullPath, int nBufSize );
	static const char* GetIniFullPath( const char* szIniFile ){
		char work[MAX_PATH+1];
		return GetIniFullPath( szIniFile, work, sizeof(work) );
	}

public:
	//	RXgN^EfXgN^
	CMyuIniReader();
	virtual ~CMyuIniReader();

	//	t@CEAPP̐ݒ
	//void SetFileName( const char* szIniFile );
	//void SetAppName( const char* szAppName ){ m_strApp = szAppName; }
	void Setup( const char* szIniFile );

	//	擾iszName="APP::ږ"j
	const char* GetString( const char* szName, const char* szDefault="" );
	const char* GetStr( const char* szName, const char* szDefault="" ){ return GetString( szName, szDefault ); }
	unsigned int GetInt( const char* szName, int nDefault=-1 );
	unsigned int GetNum( const char* szName, int nDefault=-1 ){ return GetInt( szName, nDefault ); }
	const char* operator[]( const char* szName ){ return GetString(szName); }
	BOOL GetBool( const char* szName, BOOL bDefault ){ return GetInt( szName, bDefault ); }

	/*
	BOOL WriteString( const char* szName, const char* szStr ){
		m_cache[szName] = szStr;	//	LbVXV
		return WritePrivateProfileString( GetL(szName), GetR(szName), szStr, m_strIniPath.c_str() ); }
	BOOL WriteString( const char* szSectionName, const char* szValueName, const char* szValueStr ){
		string strNameWork = szSectionName;
		strNameWork += "::";
		strNameWork += szValueName;
		m_cache[strNameWork] = szValueStr;	//	LbVXV
		return WritePrivateProfileString( szSectionName, szValueName, szValueStr, m_strIniPath.c_str() ); }
	BOOL WriteStr( const char* szName, const char* szStr ){ return WriteString( szName, szStr ); }
	BOOL WriteInt( const char* szName, int nNum ){
		char work[32];
		return WriteString( szName, dectostr( nNum, work ) ); }
	BOOL WriteNum( const char* szName, int nNum ){ return WriteInt( szName, nNum ); }
	BOOL WriteNum( const char* szSectionName, const char* szValueName, int nValueNum ){
		char work[32];
		return WriteString( szSectionName, szValueName, dectostr( nValueNum, work ) ); }
	BOOL WriteBool( const char* szName, BOOL bFlg ){ return WriteInt( szName, bFlg ); }
	*/
	
	//	static : Read
	static const char* GetEzString( const char* szIniFile, const char* szName, const char* szDefault="" );
	static const char* GetEzStr( const char* szIniFile, const char* szName, const char* szDefault="" ){ return GetEzString( szIniFile, szName, szDefault ); }
	static unsigned int GetEzInt( const char* szIniFile, const char* szName, int nDefault=-1 ){
		char work[32];
		const char* p = GetEzString( szIniFile, szName, dectostr(nDefault,work) );
		return atoi(p);
	}
	static unsigned int GetEzNum( const char* szIniFile, const char* szName, int nDefault=-1 ){ return GetEzInt( szIniFile, szName, nDefault ); }
	
	/*
	//	static : Write
	static BOOL WriteEzString( const char* szIniFile, const char* szName, const char* szStr ){
		return WritePrivateProfileString( GetL(szName), GetR(szName), szStr, GetIniFullPath(szIniFile) ); }
	static BOOL WriteEzStr( const char* szIniFile, const char* szName, const char* szStr ){
		return WriteEzString( szIniFile, szName, szStr ); }
	static BOOL WriteEzInt( const char* szIniFile, const char* szName, int nNum ){
		char work[32];
		return WriteEzString( szIniFile, szName, dectostr( nNum, work ) ); }
	static BOOL WriteEzNum( const char* szIniFile, const char* szName, int nNum ){
		return WriteEzInt( szIniFile, szName, nNum ); }
	*/

	//	
	void ClearCache(){ m_cache.clear(); }
};

//typedef CMyuIniReader CMyuIniWriter;

#endif//__MyuIniReader_H__
