#ifndef __MyuThreadManager_H__
#define __MyuThreadManager_H__

#include <mwlcommon.h>

//	NX錾
class CMyuThreadManager
{
private:
	HANDLE m_hThread;
	DWORD m_dwId;
	DWORD m_dwUserSingal;

	void Close(){ SAFE_CLOSE_HANDLE( m_hThread ); }

public:
	//	RXgN^EfXgN^
	CMyuThreadManager(){ m_hThread=NULL; m_dwId=0; m_dwUserSingal=0; }
	virtual ~CMyuThreadManager(){}

	BOOL Create( LPTHREAD_START_ROUTINE lpThreadFunc, LPVOID lpFuncParam=NULL,
		LPSECURITY_ATTRIBUTES lpThreadAttributes=NULL,
		SIZE_T dwStackSize=0,
		DWORD dwCreationFlags=0 );
	BOOL Cleanup(){
		if ( IsAlive() == TRUE )
			return FALSE;
		Close();
		m_dwId=0;
		m_dwUserSingal=0; 
		return TRUE;
	}

	BOOL IsAlive()
	{
		if ( m_hThread == NULL )	//	`FbN
			return FALSE;

		//	̕CNiCH
		if ( WaitForSingleObject(m_hThread,0) == WAIT_TIMEOUT )
			return TRUE;
		else
			return FALSE;
		/*
		DWORD dwExitCode; 
		if ( GetExitCodeThread( m_hThread, &dwExitCode ) == 0 )
			return FALSE;

		if ( dwExitCode == STILL_ACTIVE )
			return TRUE;	//	Ă܂
		else{
			//	ł܂
			Close();	//	邩H
			return FALSE;
		}
		*/
	}
	BOOL WaitEnd( DWORD dwTimeoutMs=INFINITE );
	BOOL ForceEnd( DWORD dwExitCode=0xffffffff );

	void SetUserSignal( DWORD dwSignal ){ m_dwUserSingal=dwSignal; }
	DWORD GetUserSignal(){ return m_dwUserSingal; }
	BOOL SendSignalWaitEnd( DWORD dwSignal, DWORD dwTimeoutMs=INFINITE ){
		if ( IsAlive() == FALSE )
			return FALSE;
		SetUserSignal( dwSignal );
		return WaitEnd( dwTimeoutMs );
	}
	LPDWORD GetUserSignalPtr(){ return &m_dwUserSingal; }
};

#endif//__MyuThreadManager_H__