/*
 * simple -- example of the minimum (Oniguruma API)
 */
import onig4j.OnigRegex;
import onig4j.OnigRegion;

public class simple {
    public static void main(String[] args) {
        final String pattern = "a(.*)b|[e-f]+";
        final String str = "zzzzaffffffffb";
        
        final OnigRegex reg = new OnigRegex(pattern);
        final OnigRegion region = new OnigRegion();
        final int r = reg.search(str, region);
        if (r >= 0) {
            System.out.printf("match at %d\n", r);
            for (int i = 0; i < region.count(); ++i) {
                System.out.printf("%d: (%d-%d)\n", i, region.begin(i), region.end(i));
            }
        } else if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }
        
        region.close();
        reg.close();
    }
    
    @org.junit.Test
    public void run() {
        simple.main(null);
    }
}
