/*
 * Decompiled with CFR 0.152.
 */
package onig4j;

import java.util.Collection;
import onig4j.OnigHandle;
import onig4j.OnigOptionType;
import onig4j.OnigRegex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnigSyntaxType
extends OnigHandle
implements Cloneable {
    public static final OnigSyntaxType ONIG_SYNTAX_ASIS = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_ASIS());
    public static final OnigSyntaxType ONIG_SYNTAX_POSIX_BASIC = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_POSIX_BASIC());
    public static final OnigSyntaxType ONIG_SYNTAX_POSIX_EXTENDED = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_POSIX_EXTENDED());
    public static final OnigSyntaxType ONIG_SYNTAX_EMACS = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_EMACS());
    public static final OnigSyntaxType ONIG_SYNTAX_GREP = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_GREP());
    public static final OnigSyntaxType ONIG_SYNTAX_GNU_REGEX = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_GNU_REGEX());
    public static final OnigSyntaxType ONIG_SYNTAX_JAVA = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_JAVA());
    public static final OnigSyntaxType ONIG_SYNTAX_PERL = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_PERL());
    public static final OnigSyntaxType ONIG_SYNTAX_PERL_NG = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_PERL_NG());
    public static final OnigSyntaxType ONIG_SYNTAX_RUBY;
    public static final OnigSyntaxType ONIG_SYNTAX_DEFAULT;
    public static final int ONIG_SYN_OP_VARIABLE_META_CHARACTERS = 1;
    public static final int ONIG_SYN_OP_DOT_ANYCHAR = 2;
    public static final int ONIG_SYN_OP_ASTERISK_ZERO_INF = 4;
    public static final int ONIG_SYN_OP_ESC_ASTERISK_ZERO_INF = 8;
    public static final int ONIG_SYN_OP_PLUS_ONE_INF = 16;
    public static final int ONIG_SYN_OP_ESC_PLUS_ONE_INF = 32;
    public static final int ONIG_SYN_OP_QMARK_ZERO_ONE = 64;
    public static final int ONIG_SYN_OP_ESC_QMARK_ZERO_ONE = 128;
    public static final int ONIG_SYN_OP_BRACE_INTERVAL = 256;
    public static final int ONIG_SYN_OP_ESC_BRACE_INTERVAL = 512;
    public static final int ONIG_SYN_OP_VBAR_ALT = 1024;
    public static final int ONIG_SYN_OP_ESC_VBAR_ALT = 2048;
    public static final int ONIG_SYN_OP_LPAREN_SUBEXP = 4096;
    public static final int ONIG_SYN_OP_ESC_LPAREN_SUBEXP = 8192;
    public static final int ONIG_SYN_OP_ESC_AZ_BUF_ANCHOR = 16384;
    public static final int ONIG_SYN_OP_ESC_CAPITAL_G_BEGIN_ANCHOR = 32768;
    public static final int ONIG_SYN_OP_DECIMAL_BACKREF = 65536;
    public static final int ONIG_SYN_OP_BRACKET_CC = 131072;
    public static final int ONIG_SYN_OP_ESC_W_WORD = 262144;
    public static final int ONIG_SYN_OP_ESC_LTGT_WORD_BEGIN_END = 524288;
    public static final int ONIG_SYN_OP_ESC_B_WORD_BOUND = 0x100000;
    public static final int ONIG_SYN_OP_ESC_S_WHITE_SPACE = 0x200000;
    public static final int ONIG_SYN_OP_ESC_D_DIGIT = 0x400000;
    public static final int ONIG_SYN_OP_LINE_ANCHOR = 0x800000;
    public static final int ONIG_SYN_OP_POSIX_BRACKET = 0x1000000;
    public static final int ONIG_SYN_OP_QMARK_NON_GREEDY = 0x2000000;
    public static final int ONIG_SYN_OP_ESC_CONTROL_CHARS = 0x4000000;
    public static final int ONIG_SYN_OP_ESC_C_CONTROL = 0x8000000;
    public static final int ONIG_SYN_OP_ESC_OCTAL3 = 0x10000000;
    public static final int ONIG_SYN_OP_ESC_X_HEX2 = 0x20000000;
    public static final int ONIG_SYN_OP_ESC_X_BRACE_HEX8 = 0x40000000;
    public static final int ONIG_SYN_OP2_ESC_CAPITAL_Q_QUOTE = 1;
    public static final int ONIG_SYN_OP2_QMARK_GROUP_EFFECT = 2;
    public static final int ONIG_SYN_OP2_OPTION_PERL = 4;
    public static final int ONIG_SYN_OP2_OPTION_RUBY = 8;
    public static final int ONIG_SYN_OP2_PLUS_POSSESSIVE_REPEAT = 16;
    public static final int ONIG_SYN_OP2_PLUS_POSSESSIVE_INTERVAL = 32;
    public static final int ONIG_SYN_OP2_CCLASS_SET_OP = 64;
    public static final int ONIG_SYN_OP2_QMARK_LT_NAMED_GROUP = 128;
    public static final int ONIG_SYN_OP2_ESC_K_NAMED_BACKREF = 256;
    public static final int ONIG_SYN_OP2_ESC_G_SUBEXP_CALL = 512;
    public static final int ONIG_SYN_OP2_ATMARK_CAPTURE_HISTORY = 1024;
    public static final int ONIG_SYN_OP2_ESC_CAPITAL_C_BAR_CONTROL = 2048;
    public static final int ONIG_SYN_OP2_ESC_CAPITAL_M_BAR_META = 4096;
    public static final int ONIG_SYN_OP2_ESC_V_VTAB = 8192;
    public static final int ONIG_SYN_OP2_ESC_U_HEX4 = 16384;
    public static final int ONIG_SYN_OP2_ESC_GNU_BUF_ANCHOR = 32768;
    public static final int ONIG_SYN_OP2_ESC_P_BRACE_CHAR_PROPERTY = 65536;
    public static final int ONIG_SYN_OP2_ESC_P_BRACE_CIRCUMFLEX_NOT = 131072;
    public static final int ONIG_SYN_OP2_ESC_H_XDIGIT = 524288;
    public static final int ONIG_SYN_OP2_INEFFECTIVE_ESCAPE = 0x100000;
    public static final int ONIG_SYN_CONTEXT_INDEP_ANCHORS = Integer.MIN_VALUE;
    public static final int ONIG_SYN_CONTEXT_INDEP_REPEAT_OPS = 1;
    public static final int ONIG_SYN_CONTEXT_INVALID_REPEAT_OPS = 2;
    public static final int ONIG_SYN_ALLOW_UNMATCHED_CLOSE_SUBEXP = 4;
    public static final int ONIG_SYN_ALLOW_INVALID_INTERVAL = 8;
    public static final int ONIG_SYN_ALLOW_INTERVAL_LOW_ABBREV = 16;
    public static final int ONIG_SYN_STRICT_CHECK_BACKREF = 32;
    public static final int ONIG_SYN_DIFFERENT_LEN_ALT_LOOK_BEHIND = 64;
    public static final int ONIG_SYN_CAPTURE_ONLY_NAMED_GROUP = 128;
    public static final int ONIG_SYN_ALLOW_MULTIPLEX_DEFINITION_NAME = 256;
    public static final int ONIG_SYN_FIXED_INTERVAL_IS_GREEDY_ONLY = 512;
    public static final int ONIG_SYN_NOT_NEWLINE_IN_NEGATIVE_CC = 0x100000;
    public static final int ONIG_SYN_BACKSLASH_ESCAPE_IN_CC = 0x200000;
    public static final int ONIG_SYN_ALLOW_EMPTY_RANGE_IN_CC = 0x400000;
    public static final int ONIG_SYN_ALLOW_DOUBLE_RANGE_OP_IN_CC = 0x800000;
    public static final int ONIG_SYN_WARN_CC_OP_NOT_ESCAPED = 0x1000000;
    public static final int ONIG_SYN_WARN_REDUNDANT_NESTED_REPEAT = 0x2000000;
    public static final int ONIG_META_CHAR_ESCAPE = 0;
    public static final int ONIG_META_CHAR_ANYCHAR = 1;
    public static final int ONIG_META_CHAR_ANYTIME = 2;
    public static final int ONIG_META_CHAR_ZERO_OR_ONE_TIME = 3;
    public static final int ONIG_META_CHAR_ONE_OR_MORE_TIME = 4;
    public static final int ONIG_META_CHAR_ANYCHAR_ANYTIME = 5;
    public static final int ONIG_INEFFECTIVE_META_CHAR = 0;

    public OnigSyntaxType() {
        this(OnigSyntaxType.onig_syntax_new());
    }

    private OnigSyntaxType(long handle) {
        this.handle = handle;
    }

    public OnigSyntaxType clone() {
        return this.onig_copy_syntax();
    }

    @Override
    protected native void free();

    public boolean isActiveCaputureHistory() {
        return (this.onig_get_syntax_op2() & 0x400) != 0;
    }

    public int getOperator() {
        return this.onig_get_syntax_op();
    }

    public int getOperator2() {
        return this.onig_get_syntax_op2();
    }

    public int getBehavior() {
        return this.onig_get_syntax_behavior();
    }

    public int getOptions() {
        return this.onig_get_syntax_options();
    }

    public void setOperator(int op) {
        this.onig_set_syntax_op(op);
    }

    public void setOperator2(int op2) {
        this.onig_set_syntax_op2(op2);
    }

    public void setBehavior(int behavior) {
        this.onig_set_syntax_behavior(behavior);
    }

    public void setOptions(int options) {
        this.onig_set_syntax_options(options);
    }

    public void setOptions(OnigOptionType ... options) {
        this.onig_set_syntax_options(OnigOptionType.values(options));
    }

    public void setOptions(Collection<OnigOptionType> options) {
        this.onig_set_syntax_options(OnigOptionType.values(options));
    }

    public void setMetaChar(int what, int codePoint) {
        int ret = this.onig_set_meta_char(what, codePoint);
        if (ret != 0) {
            throw new IllegalArgumentException(OnigRegex.getErrorMessage(ret, null));
        }
    }

    public static OnigSyntaxType getDefaultSyntax() {
        return new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_DEFAULT());
    }

    public static void setDefaultSyntax(OnigSyntaxType syntax) {
        int ret = OnigSyntaxType.onig_set_default_syntax(syntax);
        if (ret != 0) {
            throw new IllegalArgumentException(OnigRegex.getErrorMessage(ret, null));
        }
    }

    static OnigSyntaxType[] values() {
        return new OnigSyntaxType[]{ONIG_SYNTAX_ASIS, ONIG_SYNTAX_POSIX_BASIC, ONIG_SYNTAX_POSIX_EXTENDED, ONIG_SYNTAX_EMACS, ONIG_SYNTAX_GREP, ONIG_SYNTAX_GNU_REGEX, ONIG_SYNTAX_JAVA, ONIG_SYNTAX_PERL, ONIG_SYNTAX_PERL_NG, ONIG_SYNTAX_RUBY};
    }

    private static native long onig_syntax_new();

    private native OnigSyntaxType onig_copy_syntax();

    private static native int onig_set_default_syntax(OnigSyntaxType var0);

    private native int onig_get_syntax_op();

    private native int onig_get_syntax_op2();

    private native int onig_get_syntax_behavior();

    private native int onig_get_syntax_options();

    private native void onig_set_syntax_op(int var1);

    private native void onig_set_syntax_op2(int var1);

    private native void onig_set_syntax_behavior(int var1);

    private native void onig_set_syntax_options(int var1);

    private native int onig_set_meta_char(int var1, int var2);

    native boolean isBuiltIn();

    static {
        ONIG_SYNTAX_DEFAULT = ONIG_SYNTAX_RUBY = new OnigSyntaxType(OnigRegex.ONIG_SYNTAX_RUBY());
    }
}

