/************************************************

  固定端反力計算ツール

  部材の固定端反力を計算します。
  2011.05.31 軸力は無効。
  2011.05.31 分布荷重の仮想荷重の求め方がスマートでない。

  http://1-stop.co.cc/

************************************************/

#include <QtGui>
#include "widget.h"
#include "singlebar.h"


//メインウィンドウ

Widget::Widget(QWidget *parent)
    : QWidget(parent)
{
    setWindowTitle("固定端反力計算ツール - OneStop構造計算プログラム");

    //部材条件グループ
    group_memberProperty = new QGroupBox("部材条件");
    layout_memberProperty=new QHBoxLayout;

    label_memberLength = new QLabel("部材長:");
    spin_memberLength = new QDoubleSpinBox;
        CostomizeSpinBox(spin_memberLength);
    label_m1 = new QLabel("m");

    layout_memberProperty->addWidget(label_memberLength);
    layout_memberProperty->addWidget(spin_memberLength);
    layout_memberProperty->addWidget(label_m1);
    layout_memberProperty->addStretch();
    group_memberProperty->setLayout(layout_memberProperty);


    //荷重条件グループ
    group_load = new QGroupBox("荷重条件");
    layout_loadGroup = new QVBoxLayout;

    layout_load = new QGridLayout;
    label_loadSpecify = new QLabel("種別");
    label_load1 = new QLabel("荷重(集中／左)");
    label_load2 = new QLabel("荷重(右)");
    label_loadPosition1 = new QLabel("載荷位置(左)");
    label_loadPosition2 = new QLabel("載荷位置(右)");

    layout_load->addWidget(label_loadSpecify,1,1);
    layout_load->addWidget(label_load1,1,2);
    layout_load->addWidget(label_load2,1,4);
    layout_load->addWidget(label_loadPosition1,1,6);
    layout_load->addWidget(label_loadPosition2,1,8);

    add_load();

    layout_loadGroup->addLayout(layout_load);

    layout_loadButtons = new QHBoxLayout;
    button_addLoad = new QPushButton("追加");
        connect(button_addLoad,SIGNAL(clicked()),this,SLOT(add_load()));
    button_deleteLoad = new QPushButton("削除");
        connect(button_deleteLoad,SIGNAL(clicked()),this,SLOT(delete_load()));
    layout_loadButtons->addStretch();
    layout_loadButtons->addWidget(button_addLoad);
    layout_loadButtons->addWidget(button_deleteLoad);
    layout_loadGroup->addLayout(layout_loadButtons);

    group_load->setLayout(layout_loadGroup);


    //固定端応力（結果）グループ
    group_result = new QGroupBox("固定端応力");
    layout_result = new QHBoxLayout;

    layout_leftResult = new QGridLayout;
    label_left = new QLabel("左端");
    label_leftM = new QLabel("M");
    label_leftBendingMoment = new QLabel("0.000");
    label_kNm1 = new QLabel("kN・m");
    label_leftQ = new QLabel("Q");
    label_leftSharingForce = new QLabel("0.000");
    label_kN2 = new QLabel("kN");
    label_leftN = new QLabel("N");
    label_leftAxialForce = new QLabel("0.000");
    label_kN3 = new QLabel("kN");

    layout_leftResult->addWidget(label_left,1,1);
    layout_leftResult->addWidget(label_leftM,1,2);
    layout_leftResult->addWidget(label_leftBendingMoment,1,3);
    layout_leftResult->addWidget(label_kNm1,1,4);
    layout_leftResult->addWidget(label_leftQ,2,2);
    layout_leftResult->addWidget(label_leftSharingForce,2,3);
    layout_leftResult->addWidget(label_kN2,2,4);
    layout_leftResult->addWidget(label_leftN,3,2);
    layout_leftResult->addWidget(label_leftAxialForce,3,3);
    layout_leftResult->addWidget(label_kN3,3,4);

    layout_rightResult = new QGridLayout;
    label_right = new QLabel("右端");
    label_rightM = new QLabel("M");
    label_rightBendingMoment = new QLabel("0.000");
    label_kNm2 = new QLabel("kN・m");
    label_rightQ = new QLabel("Q");
    label_rightSharingForce = new QLabel("0.000");
    label_kN4 = new QLabel("kN");
    label_rightN = new QLabel("N");
    label_rightAxialForce = new QLabel("0.000");
    label_kN5 = new QLabel("kN");

    layout_rightResult->addWidget(label_right,1,1);
    layout_rightResult->addWidget(label_rightM,1,2);
    layout_rightResult->addWidget(label_rightBendingMoment,1,3);
    layout_rightResult->addWidget(label_kNm2,1,4);
    layout_rightResult->addWidget(label_rightQ,2,2);
    layout_rightResult->addWidget(label_rightSharingForce,2,3);
    layout_rightResult->addWidget(label_kN4,2,4);
    layout_rightResult->addWidget(label_rightN,3,2);
    layout_rightResult->addWidget(label_rightAxialForce,3,3);
    layout_rightResult->addWidget(label_kN5,3,4);

    layout_result->addLayout(layout_leftResult);
    layout_result->addStretch();
    layout_result->addLayout(layout_rightResult);
    group_result->setLayout(layout_result);


    //グループボックスレイアウト
    layout = new QVBoxLayout;
    layout->addWidget(group_memberProperty);
    layout->addWidget(group_load);
    layout->addWidget(group_result);
    setLayout(layout);

    connect(spin_memberLength,SIGNAL(valueChanged(double)),this,SLOT(reLoad()));
}

//荷重条件を追加
void Widget::add_load()
{
    load_set.append(new LoadSet);

    load_set.last()->spin_loadPosition1->setMaximum(spin_memberLength->value());
    load_set.last()->spin_loadPosition2->setMaximum(spin_memberLength->value());

    connect(load_set.last()->combo_loadSpecify,SIGNAL(currentIndexChanged(int)),this,SLOT(reLoad()));
    connect(load_set.last()->spin_load1,SIGNAL(valueChanged(double)),this,SLOT(reLoad()));
    connect(load_set.last()->spin_load2,SIGNAL(valueChanged(double)),this,SLOT(reLoad()));
    connect(load_set.last()->spin_loadPosition1,SIGNAL(valueChanged(double)),this,SLOT(reLoad()));
    connect(load_set.last()->spin_loadPosition2,SIGNAL(valueChanged(double)),this,SLOT(reLoad()));

    int i = load_set.count() + 1;
    layout_load->addWidget(load_set.last()->combo_loadSpecify,i,1);
    layout_load->addWidget(load_set.last()->spin_load1,i,2);
    layout_load->addWidget(load_set.last()->kN_m1,i,3);
    layout_load->addWidget(load_set.last()->spin_load2,i,4);
    layout_load->addWidget(load_set.last()->kN_m2,i,5);
    layout_load->addWidget(load_set.last()->spin_loadPosition1,i,6);
    layout_load->addWidget(load_set.last()->m1,i,7);
    layout_load->addWidget(load_set.last()->spin_loadPosition2,i,8);
    layout_load->addWidget(load_set.last()->m2,i,9);
}

//荷重条件を削除
void Widget::delete_load()
{
    delete load_set.last();
    load_set.pop_back();
    if (load_set.count()<1) add_load();
}

//入力変更をリアルタイムに処理します
void Widget::reLoad()
{
    if (spin_memberLength->value()<=0) return;
    SingleBar *model = new SingleBar(spin_memberLength->value());
    for (int i=0;i<load_set.size();i++)
    {
        switch (load_set.at(i)->combo_loadSpecify->currentIndex())
        {
        case 0: //集中荷重の場合
            model->addSharingLoad(-load_set.at(i)->spin_load1->value(),load_set.at(i)->spin_loadPosition1->value(),(load_set.at(i)->spin_loadPosition1->value() - spin_memberLength->value()) * load_set.at(i)->spin_loadPosition1->value() * load_set.at(i)->spin_load1->value() / 2,(spin_memberLength->value() + load_set.at(i)->spin_loadPosition1->value()) / 3);
            break;
        case 1: //分布荷重の場合
            double W = (load_set.at(i)->spin_load1->value() + load_set.at(i)->spin_load2->value()) * (load_set.at(i)->spin_loadPosition2->value() - load_set.at(i)->spin_loadPosition1->value()) / 2;
            double Gw = ((load_set.at(i)->spin_loadPosition2->value() - load_set.at(i)->spin_loadPosition1->value()) * (load_set.at(i)->spin_loadPosition2->value() + load_set.at(i)->spin_loadPosition1->value()) * load_set.at(i)->spin_load1->value() + (load_set.at(i)->spin_load2->value() - load_set.at(i)->spin_load1->value()) * (load_set.at(i)->spin_loadPosition2->value() - load_set.at(i)->spin_loadPosition1->value()) * (load_set.at(i)->spin_loadPosition1->value() + load_set.at(i)->spin_loadPosition2->value() * 2) / 3) / 2;
            Gw /= W;
            double P1 = load_set.at(i)->spin_load1->value();
            double P2 = load_set.at(i)->spin_load2->value();
            double X1 = load_set.at(i)->spin_loadPosition1->value();
            double X2 = load_set.at(i)->spin_loadPosition2->value();
            double Q2 = Gw / spin_memberLength->value() * W;
            double Q1 = W - Q2;
            double S = Q1 * X1 * X1 / 2;
            S += Q2 * (spin_memberLength->value() - X2) * (spin_memberLength->value() - X2) / 2;
            double A = (P2-P1)/(X2-X1);
            S += -A/24*X1*X1*X1*X1-A/24*X2*X2*X2*X2+A*X1*X1*X1*X2/6+2*P1*X1*X1*X1/3-P1*X2*X2*X2/6+A*X1*X2*X2*X2/6-A*X1*X1*X2*X2/4-P1*X1*X1*X2/2-Q1*X1*X1/2+Q1*X2*X2/2-P1*X1*X1+P1*X1*X2;
            double Gs = Q1 * X1 * X1 / 2 * X1 / 1.5;
            Gs += Q2 * (spin_memberLength->value() - X2) * (spin_memberLength->value() - X2) / 2 * (X2 + (spin_memberLength->value() - X2) / 3);
            Gs += Q1*X2*X2*X2/3-P1*X2*X2*X2*X2/8+P1*X1*X2*X2/2-P1*X1*X1*X2*X2/4-A*X2*X2*X2*X2*X2/30+A*X1/8-A*X1*X1*X2*X2*X2/6+A*X1*X1*X1*X2*X2/12;
            Gs -= Q1*X1*X1*X1/3-P1*X1*X1*X1*X1/8+P1*X1*X1*X1/2-P1*X1*X1*X1*X1/4-A*X1*X1*X1*X1*X1/30+A/8*X1-A*X1*X1*X1*X1*X1/6+A*X1*X1*X1*X1*X1/12;
            Gs /= S;
            model->addSharingLoad(-W,Gw,-S,Gs);
        }        
        load_set.at(i)->spin_loadPosition1->setMaximum(spin_memberLength->value());
        load_set.at(i)->spin_loadPosition2->setMaximum(spin_memberLength->value());
    }
    label_leftBendingMoment->setText(QString::number(model->end_M(false),'a',3));
    label_leftSharingForce->setText(QString::number(model->end_Q(false),'a',3));
    label_leftAxialForce->setText(QString::number(model->end_N(false),'a',3));
    label_rightBendingMoment->setText(QString::number(model->end_M(true),'a',3));
    label_rightSharingForce->setText(QString::number(model->end_Q(true),'a',3));
    label_rightAxialForce->setText(QString::number(model->end_N(true),'a',3));
    delete model;
}

//荷重条件入力オブジェクト群
LoadSet::LoadSet(QWidget *parent)
    : QWidget(parent)
{
    combo_loadSpecify=new QComboBox;
        combo_loadSpecify->addItem("集中荷重");
        combo_loadSpecify->addItem("分布荷重");
    spin_load1=new QDoubleSpinBox;
        CostomizeSpinBox(spin_load1);
    kN_m1=new QLabel("kN");
    spin_load2=new QDoubleSpinBox;
        CostomizeSpinBox(spin_load2);
        spin_load2->setDisabled(true);
    kN_m2=new QLabel("kN/m");
        kN_m2->setDisabled(true);
    spin_loadPosition1=new QDoubleSpinBox;
        CostomizeSpinBox(spin_loadPosition1);
    m1=new QLabel("m");
    spin_loadPosition2=new QDoubleSpinBox;
        CostomizeSpinBox(spin_loadPosition2);
        spin_loadPosition2->setDisabled(true);
    m2=new QLabel("m");
        m2->setDisabled(true);
    connect(combo_loadSpecify,SIGNAL(currentIndexChanged(int)),this,SLOT(changeSpecify(int)));
}

//デストラクタ
LoadSet::~LoadSet()
{
    delete combo_loadSpecify;
    delete spin_load1;
    delete kN_m1;
    delete spin_load2;
    delete kN_m2;
    delete spin_loadPosition1;
    delete m1;
    delete spin_loadPosition2;
    delete m2;
}


//荷重種別に合わせて入力項目を設定
void LoadSet::changeSpecify(int index)
{
    bool secondary_load = (index!=0);
    spin_load2->setEnabled(secondary_load);
    kN_m2->setEnabled(secondary_load);
    spin_loadPosition2->setEnabled(secondary_load);
    m2->setEnabled(secondary_load);
    if (secondary_load) kN_m1->setText("kN/m");
    else kN_m1->setText("kN");
}

//スピンボックスの桁と範囲を揃えます。
void CostomizeSpinBox(QDoubleSpinBox *target)
{
    target->setDecimals(5);
    target->setRange(0,100000);
    target->setSingleStep(0.1);
}
