/************************************************

  メインウィンドウを表すサブクラス

  http://1-stop.co.cc/

************************************************/

#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>

class QGroupBox;
class QLabel;
class QDoubleSpinBox;
class QComboBox;
class QPushButton;
class QGridLayout;
class QHBoxLayout;
class QVBoxLayout;


//荷重条件の入力セット

class LoadSet : public QWidget
{
    Q_OBJECT

public:
    LoadSet(QWidget *parent = 0);
    ~LoadSet();

    QComboBox *combo_loadSpecify;
    QDoubleSpinBox *spin_load1;
    QLabel *kN_m1;
    QDoubleSpinBox *spin_load2;
    QLabel *kN_m2;
    QDoubleSpinBox *spin_loadPosition1;
    QLabel *m1;
    QDoubleSpinBox *spin_loadPosition2;
    QLabel *m2;

private slots:
    void changeSpecify(int);
};


//メインウィンドウ

class Widget : public QWidget
{
    Q_OBJECT

public:
    Widget(QWidget *parent = 0);

private slots:
    void add_load();
    void delete_load();
    void reLoad();

private:
    QVBoxLayout *layout;

    //部材条件グループ
    QGroupBox *group_memberProperty;
        QHBoxLayout *layout_memberProperty;
        QDoubleSpinBox *spin_memberLength;
        QLabel *label_memberLength;
        QLabel *label_m1;

    //荷重条件グループ
    QGroupBox *group_load;
        QGridLayout *layout_load;
        QVBoxLayout *layout_loadGroup;
        QHBoxLayout *layout_loadButtons;
        QPushButton *button_addLoad;
        QPushButton *button_deleteLoad;
        QLabel *label_loadSpecify;
        QLabel *label_load1;
        QLabel *label_load2;
        QLabel *label_loadPosition1;
        QLabel *label_loadPosition2;
        QVector<LoadSet *> load_set;

    //固定端応力（結果）グループ
    QGroupBox *group_result;
    QHBoxLayout *layout_result;
        //左端
        QGridLayout *layout_leftResult;
        QLabel *label_left;
        QLabel *label_leftM;
        QLabel *label_leftQ;
        QLabel *label_leftN;
        QLabel *label_leftBendingMoment;
        QLabel *label_leftSharingForce;
        QLabel *label_leftAxialForce;
        QLabel *label_kNm1;
        QLabel *label_kN2;
        QLabel *label_kN3;
        //右端
        QGridLayout *layout_rightResult;
        QLabel *label_right;
        QLabel *label_rightM;
        QLabel *label_rightQ;
        QLabel *label_rightN;
        QLabel *label_rightBendingMoment;
        QLabel *label_rightSharingForce;
        QLabel *label_rightAxialForce;
        QLabel *label_kNm2;
        QLabel *label_kN4;
        QLabel *label_kN5;
};


//スピンボックスの書式を揃えます。

void CostomizeSpinBox(QDoubleSpinBox*);


#endif // WIDGET_H
